/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana;

import com.mojang.brigadier.CommandDispatcher;
import eu.midnightdust.lib.config.MidnightConfig;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.command.ViaRomanaCommands;
import net.rasanovum.viaromana.core.DimensionHandler;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.core.SignInteract;
import net.rasanovum.viaromana.init.DataInit;
import net.rasanovum.viaromana.integration.IntegrationManager;
import net.rasanovum.viaromana.map.ChunkPixelRenderer;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.tags.ServerResourcesGenerator;
import net.rasanovum.viaromana.teleport.ServerTeleportHandler;
import net.rasanovum.viaromana.util.PathSyncUtils;
import net.rasanovum.viaromana.util.VersionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ViaRomana {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "via_romana";
    public static final DynamicDataPack DYNAMIC_PACK = new DynamicDataPack(VersionUtils.getLocation("via_romana", "dynamic_tags"));
    private static final int PATH_GRAPH_SYNC_DELAY = 40;
    private static final int PATH_GRAPH_SYNC_MAX_ATTEMPTS = 10;
    private static final Map<UUID, PendingPathGraphSync> pendingPathGraphSyncs = new HashMap<UUID, PendingPathGraphSync>();
    private static MinecraftServer currentServer = null;

    public static void initialize() {
        LOGGER.info("Initializing Via Romana");
        DataInit.load();
        MidnightConfig.init((String)MODID, CommonConfig.class);
        ServerResourcesGenerator generator = new ServerResourcesGenerator(DYNAMIC_PACK);
        generator.register();
        IntegrationManager.initialize();
    }

    public static void onJoin(class_3222 player) {
        PlayerData.resetVariables((class_1657)player);
        PathSyncUtils.syncConfigToPlayer(player);
        MinecraftServer server = player.method_5682();
        if (server != null) {
            server.execute(() -> {
                boolean synced = PathSyncUtils.syncPathGraphToPlayer(player);
                int maxAttempts = synced ? 1 : 10;
                ViaRomana.queueDelayedPathGraphSync(player, maxAttempts);
            });
        }
    }

    public static void onServerTick(class_3218 level) {
        ServerTeleportHandler.tick(level);
        MinecraftServer server = level.method_8503();
        if (level == server.method_30002()) {
            ViaRomana.tickPendingPathGraphSyncs(server);
        }
    }

    public static void onServerStart(MinecraftServer server) {
        currentServer = server;
        ServerMapCache.init(server);
        ChunkPixelRenderer.init();
    }

    public static void onServerStop() {
        ServerMapCache.shutdown();
        ServerMapCache.saveAllToDisk(true);
        ServerMapCache.clear();
        pendingPathGraphSyncs.clear();
        currentServer = null;
    }

    public static void onDataPackReload(MinecraftServer server) {
        ServerMapCache.shutdown();
        ServerMapCache.clear();
        ServerMapCache.init(server);
        ChunkPixelRenderer.init();
        PathSyncUtils.syncConfigToAllPlayers(server);
    }

    public static void onDimensionChange(class_3218 level, class_3222 player) {
        DimensionHandler.preventHopping((class_1936)level, (class_1297)player);
        DimensionHandler.syncPathDataOnDimensionChange((class_1936)level, (class_1297)player);
    }

    public static boolean onBlockBreak(class_1936 world, class_2338 pos, class_3222 player) {
        if (LinkHandler.isSignBlock(world, pos) && LinkHandler.isSignLinked(world, pos)) {
            if (!player.method_5715()) {
                return false;
            }
            SignInteract.broken(world, pos, (class_1297)player);
        }
        return true;
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        ViaRomanaCommands.register(dispatcher);
    }

    public static MinecraftServer getServer() {
        return currentServer;
    }

    private static void queueDelayedPathGraphSync(class_3222 player, int maxAttempts) {
        pendingPathGraphSyncs.put(player.method_5667(), new PendingPathGraphSync(40, maxAttempts));
        if (CommonConfig.logging_enum.ordinal() > 0) {
            LOGGER.info("Queued delayed PathGraph sync for player {} (max attempts: {})", (Object)player.method_5477().getString(), (Object)maxAttempts);
        }
    }

    private static void tickPendingPathGraphSyncs(MinecraftServer server) {
        if (pendingPathGraphSyncs.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<UUID, PendingPathGraphSync>> iterator = pendingPathGraphSyncs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, PendingPathGraphSync> entry = iterator.next();
            PendingPathGraphSync pending = entry.getValue();
            if (!pending.tick()) continue;
            class_3222 player = server.method_3760().method_14602(entry.getKey());
            if (player == null) {
                iterator.remove();
                continue;
            }
            if (PathSyncUtils.syncPathGraphToPlayer(player)) {
                iterator.remove();
                if (CommonConfig.logging_enum.ordinal() <= 0) continue;
                LOGGER.info("Delayed PathGraph sync succeeded for player {}", (Object)player.method_5477().getString());
                continue;
            }
            if (pending.incrementAttempts() >= pending.maxAttempts) {
                LOGGER.warn("Giving up on PathGraph sync for player {} after {} attempts", (Object)player.method_5477().getString(), (Object)pending.maxAttempts);
                iterator.remove();
                continue;
            }
            pending.ticksUntilAttempt = 40;
        }
    }

    private static final class PendingPathGraphSync {
        private int ticksUntilAttempt;
        private int attempts;
        private final int maxAttempts;

        private PendingPathGraphSync(int initialDelay, int maxAttempts) {
            this.ticksUntilAttempt = initialDelay;
            this.attempts = 0;
            this.maxAttempts = Math.max(1, maxAttempts);
        }

        private boolean tick() {
            if (this.ticksUntilAttempt > 0) {
                --this.ticksUntilAttempt;
            }
            return this.ticksUntilAttempt <= 0;
        }

        private int incrementAttempts() {
            return ++this.attempts;
        }
    }
}

