/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.client.ClientConfigCache;
import net.rasanovum.viaromana.items.ChartingMap;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.util.PathUtils;
import net.rasanovum.viaromana.util.VersionUtils;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class InvalidBlockRenderer {
    private static final class_2960 BARRIER_TEXTURE = VersionUtils.getLocation("minecraft:textures/item/barrier.png");

    private static float getAlpha() {
        return CommonConfig.invalid_block_overlay_opacity;
    }

    private static int getRadius() {
        return ClientConfigCache.infrastructureCheckRadius;
    }

    public static void renderInfrastructureBlocks(class_4587 poseStack, class_1937 level, class_1657 player, float tickDelta) {
        boolean shouldRender;
        boolean bl = shouldRender = InvalidBlockRenderer.getAlpha() > 0.0f && (PlayerData.isChartingPath(player) || player.method_6047().method_7909() instanceof ChartingMap || player.method_6079().method_7909() instanceof ChartingMap);
        if (!shouldRender) {
            return;
        }
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        class_4588 consumer = bufferSource.getBuffer(class_1921.method_23689((class_2960)BARRIER_TEXTURE));
        poseStack.method_22903();
        poseStack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        class_2338 centerPos = player.method_24515();
        int radius = InvalidBlockRenderer.getRadius();
        float baseAlpha = InvalidBlockRenderer.getAlpha();
        double maxDistance = Math.sqrt(3.0) * (double)radius;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius; y <= radius; ++y) {
                    class_265 currentShape;
                    class_2338 blockAbove;
                    class_2680 blockStateAbove;
                    class_2338 pos = centerPos.method_10069(x, y, z);
                    class_2680 state = level.method_8320(pos);
                    if (state.method_26215() || !(blockStateAbove = level.method_8320(blockAbove = pos.method_10084())).method_26215() && blockStateAbove.method_26234((class_1922)level, blockAbove) || (currentShape = state.method_26220((class_1922)level, pos)).method_1110() || PathUtils.isBlockValidPath((class_1936)level, pos)) continue;
                    double distance = Math.sqrt(x * x + y * y + z * z);
                    float fadeFactor = 1.0f - (float)(distance / maxDistance) * 0.75f;
                    float alpha = baseAlpha * fadeFactor;
                    float topY = (float)currentShape.method_1107().field_1325;
                    poseStack.method_22903();
                    poseStack.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
                    class_4587.class_4665 blockPose = poseStack.method_23760();
                    InvalidBlockRenderer.renderTopFace(blockPose, consumer, 0.0f, 1.0f, topY, 0.0f, 1.0f, alpha);
                    poseStack.method_22909();
                }
            }
        }
        poseStack.method_22909();
        bufferSource.method_22994(class_1921.method_23689((class_2960)BARRIER_TEXTURE));
    }

    private static void renderTopFace(class_4587.class_4665 pose, class_4588 consumer, float minX, float maxX, float y, float minZ, float maxZ, float alpha) {
        int light = 0xF000F0;
        int overlay = 655360;
        float yOffset = y + 0.06f;
        int color = (int)(alpha * 255.0f) << 24 | 0xFF0000 | 0xFF00 | 0xFF;
        Matrix4f matrix = pose.method_23761();
        consumer.method_22918(matrix, minX, yOffset, minZ).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(0.0f, 0.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        consumer.method_22918(matrix, minX, yOffset, maxZ).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(0.0f, 1.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        consumer.method_22918(matrix, maxX, yOffset, maxZ).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(1.0f, 1.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
        consumer.method_22918(matrix, maxX, yOffset, minZ).method_22915(1.0f, 1.0f, 1.0f, alpha).method_22913(1.0f, 0.0f).method_22922(overlay).method_22916(light).method_22914(0.0f, 1.0f, 0.0f).method_1344();
    }
}

