/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.map;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.MapInfo;
import net.rasanovum.viaromana.map.MapPixelAssembler;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.path.PathGraph;

public class MapBaker {
    public static CompletableFuture<MapInfo> bakeAsync(UUID networkId, class_3218 level, ExecutorService executor) {
        return CompletableFuture.supplyAsync(() -> MapBaker.bake(networkId, level), executor);
    }

    public static MapInfo bake(UUID networkId, class_3218 level) {
        int srcZ;
        if (CommonConfig.logging_enum.ordinal() > 1) {
            ViaRomana.LOGGER.info("Starting full map bake for network {}", (Object)networkId);
        }
        long bakeStartTime = System.nanoTime();
        PathGraph graph = PathGraph.getInstance(level);
        if (graph == null) {
            throw new IllegalStateException("PathGraph is null");
        }
        PathGraph.NetworkCache network = graph.getNetworkCache(networkId);
        if (network == null) {
            throw new IllegalStateException("Network cache not found for " + String.valueOf(networkId));
        }
        PathGraph.FoWCache fowCache = graph.getOrComputeFoWCache(network);
        if (fowCache == null) {
            throw new IllegalStateException("FoW cache is null");
        }
        boolean isPseudo = ServerMapCache.isPseudoNetwork(networkId);
        Set<class_1923> bakeChunks = fowCache.allowedChunks();
        class_1923 bakeMinChunk = fowCache.minChunk();
        class_1923 bakeMaxChunk = fowCache.maxChunk();
        class_2338 desiredMinBlock = fowCache.minBlock();
        class_2338 desiredMaxBlock = fowCache.maxBlock();
        if (CommonConfig.logging_enum.ordinal() > 1) {
            ViaRomana.LOGGER.info("Chunks Allowed: {}", (Object)bakeChunks.size());
        }
        HashSet<class_1923> mapChunks = new HashSet<class_1923>();
        for (int cx = bakeMinChunk.field_9181; cx <= bakeMaxChunk.field_9181; ++cx) {
            for (int cz = bakeMinChunk.field_9180; cz <= bakeMaxChunk.field_9180; ++cz) {
                mapChunks.add(new class_1923(cx, cz));
            }
        }
        int fullChunkWidth = (bakeMaxChunk.field_9181 - bakeMinChunk.field_9181 + 1) * 16;
        int fullChunkHeight = (bakeMaxChunk.field_9180 - bakeMinChunk.field_9180 + 1) * 16;
        MapPixelAssembler.RenderScale renderScale = MapPixelAssembler.calculateRenderScale(fullChunkWidth, fullChunkHeight);
        int scaleFactor = renderScale.chunkScale();
        int chunkStride = renderScale.chunkStride();
        int effectiveScale = renderScale.effectiveScale();
        long renderStartTime = System.nanoTime();
        int pixelWidth = fullChunkWidth / effectiveScale;
        int pixelHeight = fullChunkHeight / effectiveScale;
        byte[] biomePixels = new byte[pixelWidth * pixelHeight];
        byte[] chunkPixels = new byte[pixelWidth * pixelHeight];
        int chunksWithData = MapPixelAssembler.processChunkPixels(biomePixels, chunkPixels, level, mapChunks, bakeChunks, scaleFactor, pixelWidth, pixelHeight, bakeMinChunk, isPseudo, chunkStride);
        long renderTime = System.nanoTime() - renderStartTime;
        if (isPseudo) {
            long totalBakeTime = System.nanoTime() - bakeStartTime;
            if (CommonConfig.logging_enum.ordinal() > 1) {
                ViaRomana.LOGGER.info("Pseudonetwork {} pre-processing completed: total={}ms, render={}ms, dimensions={}x{}, scale={}, chunks={}", (Object)networkId, (Object)((double)totalBakeTime / 1000000.0), (Object)((double)renderTime / 1000000.0), (Object)pixelWidth, (Object)pixelHeight, (Object)effectiveScale, (Object)chunksWithData);
            }
            return MapInfo.fromServer(networkId, new byte[0], new byte[0], 0, 0, 1, 0, 0, 0, 0, new ArrayList<class_1923>(bakeChunks), new ArrayList<DestinationResponseS2C.NodeNetworkInfo>());
        }
        int desiredMinX = desiredMinBlock.method_10263();
        int desiredMinZ = desiredMinBlock.method_10260();
        int desiredMaxX = desiredMaxBlock.method_10263();
        int desiredMaxZ = desiredMaxBlock.method_10260();
        int bakedMinX = bakeMinChunk.field_9181 * 16;
        int bakedMinZ = bakeMinChunk.field_9180 * 16;
        int startPixelX = (desiredMinX - bakedMinX) / effectiveScale;
        int startPixelZ = (desiredMinZ - bakedMinZ) / effectiveScale;
        int croppedPixelWidth = (desiredMaxX - desiredMinX + 1) / effectiveScale;
        int croppedPixelHeight = (desiredMaxZ - desiredMinZ + 1) / effectiveScale;
        int effectiveStartX = Math.max(0, startPixelX);
        int effectiveStartZ = Math.max(0, startPixelZ);
        int effectiveWidth = Math.min(croppedPixelWidth, pixelWidth - effectiveStartX);
        int effectiveHeight = Math.min(croppedPixelHeight, pixelHeight - effectiveStartZ);
        byte[] croppedBiomePixels = new byte[effectiveWidth * effectiveHeight];
        byte[] croppedChunkPixels = new byte[effectiveWidth * effectiveHeight];
        for (int z = 0; z < effectiveHeight && (srcZ = effectiveStartZ + z) < pixelHeight; ++z) {
            int srcIdx = srcZ * pixelWidth + effectiveStartX;
            int dstIdx = z * effectiveWidth;
            int copyWidth = Math.min(effectiveWidth, pixelWidth - effectiveStartX);
            System.arraycopy(biomePixels, srcIdx, croppedBiomePixels, dstIdx, copyWidth);
            System.arraycopy(chunkPixels, srcIdx, croppedChunkPixels, dstIdx, copyWidth);
        }
        long totalBakeTime = System.nanoTime() - bakeStartTime;
        if (CommonConfig.logging_enum.ordinal() > 0) {
            ViaRomana.LOGGER.info("Map bake completed for network {}: total={}ms, render={}ms, dimensions={}x{}, scale={}, rawSize={}KB, chunks={}", (Object)networkId, (Object)((double)totalBakeTime / 1000000.0), (Object)((double)renderTime / 1000000.0), (Object)effectiveWidth, (Object)effectiveHeight, (Object)effectiveScale, (Object)((double)(croppedBiomePixels.length + croppedChunkPixels.length) / 1024.0), (Object)chunksWithData);
        }
        return MapInfo.fromServer(networkId, croppedBiomePixels, croppedChunkPixels, effectiveWidth, effectiveHeight, effectiveScale, desiredMinX, desiredMinZ, desiredMaxX, desiredMaxZ, new ArrayList<class_1923>(bakeChunks), graph.getNodesAsInfo(network));
    }

    public MapInfo updateMap(MapInfo previousResult, Set<class_1923> dirtyChunks, class_3218 level) {
        if (CommonConfig.logging_enum.ordinal() > 0) {
            ViaRomana.LOGGER.info("Incremental update requested for {} dirty chunks, performing rebake.", (Object)dirtyChunks.size());
        }
        return MapBaker.bake(previousResult.networkId(), level);
    }
}

