/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.api.Dispatcher;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.util.VersionUtils;

public record DestinationRequestC2S(class_2338 sourceSignPos) {
    public static final class_2960 TYPE = VersionUtils.getLocation("viaromana:destination_request_c2s");
    public static final Object STREAM_CODEC = null;

    public static void encode(class_2540 buf, DestinationRequestC2S packet) {
        buf.method_10807(packet.sourceSignPos);
    }

    public static DestinationRequestC2S decode(class_2540 buf) {
        return new DestinationRequestC2S(buf.method_10811());
    }

    public static void handle(PacketContext<DestinationRequestC2S> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            class_2338 signPos;
            class_3218 level = ctx.sender().method_51469();
            PathGraph graph = PathGraph.getInstance(level);
            Optional<Node> sourceNodeOpt = graph.getNodeBySignPos(signPos = ((DestinationRequestC2S)ctx.message()).sourceSignPos());
            if (sourceNodeOpt.isEmpty()) {
                ViaRomana.LOGGER.warn("Received destination request for unknown sign at {}", (Object)signPos);
                return;
            }
            Node sourceNode = sourceNodeOpt.get();
            List<Node> destinations = graph.getCachedTeleportDestinationsFor(ctx.sender().method_5667(), sourceNode);
            PathGraph.NetworkCache cache = graph.getNetworkCache(sourceNode);
            List<DestinationResponseS2C.DestinationInfo> destInfos = destinations.stream().map(dest -> {
                double distance = Math.sqrt(sourceNode.getBlockPos().method_10262((class_2382)dest.getBlockPos()));
                return new DestinationResponseS2C.DestinationInfo(dest.getBlockPos(), dest.getDestinationName().orElse("Unknown"), distance, dest.getDestinationIcon().orElse(Node.Icon.SIGNPOST));
            }).toList();
            List<DestinationResponseS2C.NodeNetworkInfo> networkInfos = graph.getNodesAsInfo(cache);
            DestinationResponseS2C response = new DestinationResponseS2C(destInfos, signPos, sourceNode.getBlockPos(), networkInfos, cache.id());
            Dispatcher.sendToClient((Object)response, (class_3222)ctx.sender());
        }
    }
}

