/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.util.VersionUtils;

public record PathGraphSyncPacket(class_2487 pathGraphData, class_5321<class_1937> dimension) {
    public static final class_2960 TYPE = VersionUtils.getLocation("via_romana:path_graph_sync_s2c");
    public static final Object STREAM_CODEC = null;

    public PathGraphSyncPacket(PathGraph graph, class_5321<class_1937> dimension) {
        this(graph.serialize(new class_2487()), dimension);
    }

    public static void encode(class_2540 buf, PathGraphSyncPacket packet) {
        buf.method_10794(packet.pathGraphData);
        buf.method_10814(packet.dimension.method_29177().toString());
    }

    public static PathGraphSyncPacket decode(class_2540 buf) {
        class_2487 data = buf.method_10798();
        String dimensionStr = buf.method_19772();
        class_5321 dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)VersionUtils.getLocation(dimensionStr));
        return new PathGraphSyncPacket(data, (class_5321<class_1937>)dimension);
    }

    public static void handle(PacketContext<PathGraphSyncPacket> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            try {
                PathGraph clientGraph = new PathGraph();
                clientGraph.deserialize(((PathGraphSyncPacket)ctx.message()).pathGraphData());
                class_5321<class_1937> dimension = ((PathGraphSyncPacket)ctx.message()).dimension();
                ClientPathData.getInstance().updatePathData(clientGraph, dimension);
                ViaRomana.LOGGER.debug("Client received PathGraph sync for dimension {} with {} nodes", (Object)dimension.method_29177(), (Object)clientGraph.size());
            }
            catch (Exception e) {
                ViaRomana.LOGGER.error("Failed to process PathGraph sync packet on client", (Throwable)e);
            }
        }
    }
}

