/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.teleport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3738;
import net.minecraft.class_7923;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.network.packets.TeleportFadeS2C;
import net.rasanovum.viaromana.network.packets.TeleportRequestC2S;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.util.EffectUtils;
import net.rasanovum.viaromana.util.NetworkUtils;

public class ServerTeleportHandler {
    private static final Map<UUID, Node> activeTeleports = new ConcurrentHashMap<UUID, Node>();
    private static final Map<UUID, Long> teleportStartTimes = new ConcurrentHashMap<UUID, Long>();
    private static final int FADE_UP_TICKS = 20;
    private static final int HOLD_TICKS = 10;
    private static final int FADE_DOWN_TICKS = 20;
    private static final int FOOTSTEP_INTERVAL = 7;

    public static boolean isTeleporting(class_3222 player) {
        return activeTeleports.containsKey(player.method_5667());
    }

    public static void tick(class_3218 level) {
        long currentTime = level.method_8510();
        activeTeleports.forEach((playerUUID, targetNode) -> {
            Long startTime = teleportStartTimes.get(playerUUID);
            if (startTime == null) {
                return;
            }
            long elapsedTicks = currentTime - startTime;
            class_3222 player = level.method_8503().method_3760().method_14602(playerUUID);
            if (elapsedTicks == 20L) {
                if (player != null && player.method_5805()) {
                    ServerTeleportHandler.executeTeleportation(player, targetNode);
                    EffectUtils.applyEffect((class_1297)player, "travellers_fatigue");
                }
            } else if (elapsedTicks == 50L) {
                activeTeleports.remove(playerUUID);
                teleportStartTimes.remove(playerUUID);
            }
        });
    }

    public static void handleTeleportRequest(TeleportRequestC2S packet, class_3222 player) {
        class_3218 level = player.method_51469();
        PathGraph graph = PathGraph.getInstance(level);
        if (graph == null || !ServerTeleportHandler.validateOriginSign(level, packet.originSignPos())) {
            return;
        }
        graph.getNodeAt(packet.destinationPos()).ifPresent(targetNode -> {
            activeTeleports.put(player.method_5667(), (Node)targetNode);
            teleportStartTimes.put(player.method_5667(), level.method_8510());
            NetworkUtils.sendToPlayer((class_1657)player, new TeleportFadeS2C(20, 10, 20, 7));
        });
    }

    private static void executeTeleportation(class_3222 player, Node targetNode) {
        if (!player.method_5805()) {
            return;
        }
        class_3218 level = player.method_51469();
        class_2338 safePos = ServerTeleportHandler.findSafePosition(level, class_2338.method_10092((long)targetNode.getPos()));
        if (safePos == null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.via_romana.unsafe"), true);
            activeTeleports.remove(player.method_5667());
            return;
        }
        double x = (double)safePos.method_10263() + 0.5;
        double y = ServerTeleportHandler.getAccurateYPosition(level, safePos);
        double z = (double)safePos.method_10260() + 0.5;
        class_1297 rootVehicle = player.method_5668();
        if (rootVehicle != player && !ServerTeleportHandler.isValidTeleportEntity(rootVehicle)) {
            player.method_5848();
            rootVehicle = player;
        }
        ServerTeleportHandler.teleportStack(rootVehicle, level, x, y, z);
    }

    private static void teleportStack(class_1297 rootEntity, class_3218 level, double x, double y, double z) {
        HashMap passengerMap = new HashMap();
        ArrayList<class_1297> allEntities = new ArrayList<class_1297>();
        ArrayList<Object> toProcess = new ArrayList<Object>();
        toProcess.add(rootEntity);
        while (!toProcess.isEmpty()) {
            class_1297 current = (class_1297)toProcess.remove(0);
            allEntities.add(current);
            List passengers = List.copyOf(current.method_5685());
            if (passengers.isEmpty()) continue;
            passengerMap.put(current, passengers);
            toProcess.addAll(passengers);
        }
        rootEntity.method_5772();
        HashMap<class_1297, class_1297> newEntityMap = new HashMap<class_1297, class_1297>();
        for (class_1297 oldEntity : allEntities) {
            class_1297 newEntity = ServerTeleportHandler.recreateAndTeleportEntity(oldEntity, level, x, y, z);
            if (newEntity == null) continue;
            newEntityMap.put(oldEntity, newEntity);
        }
        if (!passengerMap.isEmpty()) {
            level.method_8503().method_18858((Runnable)new class_3738(3, () -> passengerMap.forEach((oldVehicle, oldPassengers) -> {
                class_1297 newVehicle = (class_1297)newEntityMap.get(oldVehicle);
                if (newVehicle != null && newVehicle.method_5805()) {
                    oldPassengers.forEach(oldPassenger -> {
                        class_1297 newPassenger = (class_1297)newEntityMap.get(oldPassenger);
                        if (newPassenger != null && newPassenger.method_5805()) {
                            newPassenger.method_5873(newVehicle, true);
                        }
                    });
                }
            })));
        }
    }

    private static class_1297 recreateAndTeleportEntity(class_1297 oldEntity, class_3218 level, double x, double y, double z) {
        if (oldEntity.method_31481()) {
            return null;
        }
        if (oldEntity instanceof class_3222) {
            class_3222 player = (class_3222)oldEntity;
            player.method_14251(level, x, y, z, player.method_36454(), player.method_36455());
            player.field_6017 = 0.0f;
            return player;
        }
        class_1297 newEntity = oldEntity.method_5864().method_5883((class_1937)level);
        if (newEntity == null) {
            return null;
        }
        class_2487 nbt = oldEntity.method_5647(new class_2487());
        nbt.method_10551("Passengers");
        nbt.method_10551("UUID");
        newEntity.method_5651(nbt);
        newEntity.method_5808(x, y, z, oldEntity.method_36454(), oldEntity.method_36455());
        level.method_8649(newEntity);
        oldEntity.method_5650(class_1297.class_5529.field_27002);
        return newEntity;
    }

    private static boolean validateOriginSign(class_3218 level, class_2338 signPos) {
        boolean isValid = LinkHandler.isSignLinked((class_1936)level, signPos);
        return isValid;
    }

    private static class_2338 findSafePosition(class_3218 level, class_2338 center) {
        int dx = 0;
        while (dx <= 1) {
            int dz = 0;
            while (dz <= 1) {
                class_2338 checkPos = center.method_10069(dx, 0, dz);
                if (!ServerTeleportHandler.isHole(level, checkPos)) {
                    return checkPos;
                }
                dz = dz > 0 ? -dz : -dz + 1;
            }
            dx = dx > 0 ? -dx : -dx + 1;
        }
        return null;
    }

    private static boolean isHole(class_3218 level, class_2338 pos) {
        for (int i = 0; i < 5; ++i) {
            class_2338 checkPos = pos.method_10087(i);
            class_2680 state = level.method_8320(checkPos);
            if (state.method_26215() || state.method_26194((class_1922)level, checkPos, class_3726.method_16194()).method_1110()) continue;
            return false;
        }
        return true;
    }

    private static double getAccurateYPosition(class_3218 level, class_2338 pos) {
        for (int i = 0; i < 10; ++i) {
            class_2338 groundPos = pos.method_10087(i);
            class_2680 groundState = level.method_8320(groundPos);
            class_265 shape = groundState.method_26194((class_1922)level, groundPos, class_3726.method_16194());
            if (shape.method_1110()) continue;
            return (double)groundPos.method_10264() + shape.method_1105(class_2350.class_2351.field_11052);
        }
        return (double)pos.method_10264() + 1.0;
    }

    private static boolean isValidTeleportEntity(class_1297 entity) {
        String entityType = class_7923.field_41177.method_10221((Object)entity.method_5864()).toString();
        return !CommonConfig.invalid_entities.contains(entityType);
    }
}

