/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import commonnetwork.api.Dispatcher;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.ColorUtil;
import net.rasanovum.viaromana.client.FadeManager;
import net.rasanovum.viaromana.client.HudMessageManager;
import net.rasanovum.viaromana.client.MapClient;
import net.rasanovum.viaromana.client.gui.MapRenderer;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.network.packets.SignValidationRequestC2S;
import net.rasanovum.viaromana.network.packets.TeleportRequestC2S;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.teleport.TeleportHelper;
import net.rasanovum.viaromana.util.EffectUtils;
import net.rasanovum.viaromana.util.VersionUtils;

@OnlyIn(value=Dist.CLIENT)
public class TeleportMapScreen
extends Screen {
    private MapClient.MapTexture mapTexture;
    private MapRenderer mapRenderer;
    private final List<DestinationResponseS2C.NodeNetworkInfo> networkNodes;
    private final BlockPos signPos;
    private final BlockPos sourceNodePos;
    private final UUID networkId;
    private final List<TeleportHelper.TeleportDestination> destinations;
    private final Map<BlockPos, DestinationResponseS2C.NodeNetworkInfo> networkNodeMap;
    private BlockPos minBounds;
    private BlockPos maxBounds;
    private float animationProgress = 0.0f;
    private final Set<BlockPos> animatedNodes = new HashSet<BlockPos>();
    private final List<DestinationResponseS2C.NodeNetworkInfo> nodesToAnimate = new ArrayList<DestinationResponseS2C.NodeNetworkInfo>();
    private final Map<BlockPos, Float> destinationFadeProgress = new HashMap<BlockPos, Float>();
    private final Set<BlockPos> validatedNodes = new HashSet<BlockPos>();
    private final Set<BlockPos> destinationPositions;
    private static final int MARKER_SIZE = 16;
    private static final int PLAYER_MARKER_SIZE = 8;
    private static final float MARKER_FADE_SPEED = 0.05f;
    private static final int DIRECTION_INDICATOR_BUFFER = 2;
    private static final float DIRECTION_ANGLE_RANGE = 45.0f;
    private static final float DIRECTION_BASE_OPACITY = 1.0f;
    private static final float DIRECTION_FADE_CURVE = 1.0f;
    private static final int DIRECTION_COLOR_RGB = ColorUtil.rgbToHex(1.0f, 1.0f, 1.0f);
    private static final int THICKNESS = 1;

    private static float getAnimationSpeed() {
        return CommonConfig.spline_animation_speed;
    }

    public TeleportMapScreen(DestinationResponseS2C packet) {
        super((Component)Component.m_237113_((String)"Teleport Network"));
        this.signPos = packet.signPos();
        this.sourceNodePos = packet.sourceNodePos();
        this.networkId = packet.networkId();
        this.networkNodes = new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(packet.networkNodes());
        this.destinations = packet.destinations().stream().map(dest -> new TeleportHelper.TeleportDestination(dest.position, dest.name, dest.distance, dest.icon)).collect(Collectors.toList());
        this.networkNodeMap = packet.networkNodes().stream().collect(Collectors.toMap(info -> info.position, info -> info));
        this.destinationPositions = this.destinations.stream().map(dest -> dest.position).collect(Collectors.toSet());
        this.calculateBounds();
        this.mapRenderer = new MapRenderer(this.minBounds, this.maxBounds);
        this.requestMapAsync(this.minBounds, this.maxBounds);
    }

    private void requestMapAsync(BlockPos paddedMin, BlockPos paddedMax) {
        ((CompletableFuture)MapClient.requestMap(this.networkId, paddedMin, paddedMax, this.networkNodes).thenAccept(mapInfo -> {
            if (mapInfo != null) {
                assert (this.f_96541_ != null);
                this.f_96541_.execute(() -> {
                    if (this.mapTexture != null) {
                        this.mapTexture.close();
                    }
                    this.mapTexture = MapClient.createTexture(mapInfo);
                    if (this.mapRenderer != null) {
                        this.mapRenderer.setMapTexture(this.mapTexture);
                    }
                });
            }
        })).exceptionally(ex -> {
            ViaRomana.LOGGER.error("Failed to load map for network {}", (Object)this.networkId, ex);
            return null;
        });
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.sourceNodePos != null) {
            Optional.ofNullable(this.networkNodeMap.get(this.sourceNodePos)).ifPresent(this.nodesToAnimate::add);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.mapTexture == null || this.f_96541_ == null || this.f_96541_.f_91074_ == null || this.mapRenderer == null) {
            return;
        }
        this.mapRenderer.render(guiGraphics, this.f_96543_, this.f_96544_);
        this.renderNetwork(guiGraphics, partialTicks);
        HashSet<BlockPos> revealedNodes = new HashSet<BlockPos>(this.animatedNodes);
        this.nodesToAnimate.forEach(n -> revealedNodes.add(n.position));
        this.renderDestinationMarkers(guiGraphics, revealedNodes, mouseX, mouseY);
        this.renderPlayerMarker(guiGraphics, (Player)this.f_96541_.f_91074_);
        this.renderTooltip(guiGraphics, revealedNodes, mouseX, mouseY);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void renderNetwork(GuiGraphics guiGraphics, float partialTicks) {
        if (this.networkNodeMap.isEmpty()) {
            return;
        }
        if (!this.nodesToAnimate.isEmpty()) {
            this.animationProgress = Math.min(1.0f, this.animationProgress + partialTicks * TeleportMapScreen.getAnimationSpeed());
        }
        Set currentlyAnimatingSources = this.nodesToAnimate.stream().map(info -> info.position).collect(Collectors.toSet());
        for (DestinationResponseS2C.NodeNetworkInfo nodeInfo : this.networkNodeMap.values()) {
            BlockPos startPos = nodeInfo.position;
            boolean isStartCompleted = this.animatedNodes.contains(startPos);
            boolean isStartAnimating = currentlyAnimatingSources.contains(startPos);
            if (!isStartCompleted && !isStartAnimating) continue;
            this.worldToScreen(startPos).ifPresent(startScreenPos -> {
                for (BlockPos endPos : nodeInfo.connections) {
                    int lineColor;
                    boolean isEndCompleted = this.animatedNodes.contains(endPos);
                    boolean isEndAnimating = currentlyAnimatingSources.contains(endPos);
                    DestinationResponseS2C.NodeNetworkInfo endNodeInfo = this.networkNodeMap.get(endPos);
                    boolean bothUnderground = nodeInfo.clearance > 0.0f && nodeInfo.clearance < 24.0f && endNodeInfo != null && endNodeInfo.clearance > 0.0f && endNodeInfo.clearance < 24.0f;
                    int n = lineColor = bothUnderground ? -5592406 : -1;
                    if (isStartCompleted && isEndCompleted) {
                        if (startPos.hashCode() >= endPos.hashCode()) continue;
                        this.worldToScreen(endPos).ifPresent(endScreenPos -> this.drawLine(guiGraphics, (Point)startScreenPos, (Point)endScreenPos, lineColor, 1));
                        continue;
                    }
                    if (isStartCompleted && isEndAnimating) {
                        this.worldToScreen(endPos).ifPresent(endScreenPos -> this.drawLine(guiGraphics, (Point)startScreenPos, (Point)endScreenPos, lineColor, 1));
                        continue;
                    }
                    if (!isStartAnimating || isEndCompleted) continue;
                    this.worldToScreen(endPos).ifPresent(endScreenPos -> {
                        Point animatedEndPoint = this.getAnimatedPoint((Point)startScreenPos, (Point)endScreenPos, this.animationProgress);
                        this.drawLine(guiGraphics, (Point)startScreenPos, animatedEndPoint, lineColor, 1);
                    });
                }
            });
        }
        if (this.animationProgress >= 1.0f && !this.nodesToAnimate.isEmpty()) {
            HashSet<BlockPos> nextWavePositions = new HashSet<BlockPos>();
            for (DestinationResponseS2C.NodeNetworkInfo completedNode : this.nodesToAnimate) {
                this.animatedNodes.add(completedNode.position);
                if (this.destinationPositions.contains(completedNode.position)) {
                    this.validateNodeSign(completedNode.position);
                }
                for (BlockPos connPos : completedNode.connections) {
                    if (this.animatedNodes.contains(connPos)) continue;
                    nextWavePositions.add(connPos);
                }
            }
            this.nodesToAnimate.clear();
            nextWavePositions.stream().map(this.networkNodeMap::get).filter(Objects::nonNull).forEach(this.nodesToAnimate::add);
            this.animationProgress = 0.0f;
        }
    }

    private Point getAnimatedPoint(Point start, Point end, float progress) {
        float dx = end.x - start.x;
        float dy = end.y - start.y;
        return new Point((int)((float)start.x + dx * progress), (int)((float)start.y + dy * progress));
    }

    private void renderDestinationMarkers(GuiGraphics guiGraphics, Set<BlockPos> revealedNodes, int mouseX, int mouseY) {
        revealedNodes.stream().filter(this.destinationPositions::contains).filter(this.validatedNodes::contains).forEach(pos -> {
            float progress = this.destinationFadeProgress.getOrDefault(pos, Float.valueOf(0.0f)).floatValue();
            if (progress < 1.0f) {
                this.destinationFadeProgress.put((BlockPos)pos, Float.valueOf(Math.min(1.0f, progress + 0.05f)));
            }
        });
        for (TeleportHelper.TeleportDestination dest : this.destinations) {
            if (!this.destinationFadeProgress.containsKey(dest.position) || !this.validatedNodes.contains(dest.position)) continue;
            this.worldToScreen(dest.position).ifPresent(screenPos -> {
                float alpha = this.destinationFadeProgress.get(dest.position).floatValue();
                boolean isHovered = this.getDestinationAtPosition(revealedNodes, mouseX, mouseY).map(hovered -> hovered.position.equals((Object)dest.position)).orElse(false);
                ResourceLocation markerTexture = VersionUtils.getLocation("via_romana:textures/screens/marker_" + dest.icon.toString().toLowerCase() + ".png");
                int x = screenPos.x - 8;
                int y = screenPos.y - 8;
                guiGraphics.m_280168_().m_85836_();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)(alpha / 2.0f));
                guiGraphics.m_280163_(markerTexture, x + 1, y + 1, 0.0f, 0.0f, 16, 16, 16, 16);
                float brightness = isHovered ? 1.25f : 1.0f;
                RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)alpha);
                guiGraphics.m_280163_(markerTexture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                guiGraphics.m_280168_().m_85849_();
            });
        }
    }

    private void renderPlayerMarker(GuiGraphics guiGraphics, Player player) {
        if (player == null || this.f_96541_ == null) {
            return;
        }
        this.worldToScreen(player.m_20183_()).ifPresent(screenPos -> {
            int x = screenPos.x - 4;
            int y = screenPos.y - 4;
            ResourceLocation skin = this.f_96541_.m_91109_().m_240306_(player.m_36316_());
            guiGraphics.m_280168_().m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            guiGraphics.m_280163_(skin, x + 1, y + 1, 8.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280163_(skin, x, y, 8.0f, 8.0f, 8, 8, 64, 64);
            guiGraphics.m_280163_(skin, x, y, 40.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.disableBlend();
            guiGraphics.m_280168_().m_85849_();
            this.renderPlayerDirectionIndicator(guiGraphics, (Point)screenPos, 8, player.m_146908_());
        });
    }

    private void renderPlayerDirectionIndicator(GuiGraphics guiGraphics, Point centerPos, int markerSize, float yaw) {
        int indicatorSize = markerSize + 2;
        float facingAngle = (yaw % 360.0f + 360.0f + 180.0f) % 360.0f;
        int baseAlpha = 255;
        int directionColor = baseAlpha << 24 | DIRECTION_COLOR_RGB;
        this.renderDirectionalPixels(guiGraphics, centerPos, indicatorSize, facingAngle, directionColor);
    }

    private void renderDirectionalPixels(GuiGraphics guiGraphics, Point center, int size, float facingAngle, int baseColor) {
        int half = size / 2;
        int left = center.x - half;
        int top = center.y - half;
        for (int i = 0; i < size * 4 - 4; ++i) {
            int y;
            int x;
            if (i < size) {
                x = left + i;
                y = top;
            } else if (i < size * 2 - 1) {
                x = left + size - 1;
                y = top + (i - size + 1);
            } else if (i < size * 3 - 2) {
                x = left + size - 1 - (i - (size * 2 - 2));
                y = top + size - 1;
            } else {
                x = left;
                y = top + size - 1 - (i - (size * 3 - 3));
            }
            float pixelAngle = this.getPixelAngle(center, new Point(x, y));
            if (!this.isWithinAngleRange(pixelAngle, facingAngle, 45.0f)) continue;
            int fadedColor = this.getFadedColor(baseColor, pixelAngle, facingAngle, 45.0f);
            guiGraphics.m_280509_(x, y, x + 1, y + 1, fadedColor);
        }
    }

    private void renderTooltip(GuiGraphics guiGraphics, Set<BlockPos> revealedNodes, int mouseX, int mouseY) {
        this.getDestinationAtPosition(revealedNodes, mouseX, mouseY).ifPresentOrElse(dest -> {
            long dist = Math.round(dest.distance);
            long displayDist = dist > 1000L ? dist / 1000L : dist;
            MutableComponent text = Component.m_237110_((String)("gui.viaromana.distance_" + (dist > 1000L ? "kilometers" : "meters")), (Object[])new Object[]{dest.name, displayDist});
            guiGraphics.m_280557_(this.f_96547_, (Component)text, mouseX, mouseY);
        }, () -> {
            if (this.isMouseOverPlayer(mouseX, mouseY)) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.viaromana.player_marker"), mouseX, mouseY);
            }
        });
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            HashSet<BlockPos> revealedNodes = new HashSet<BlockPos>(this.animatedNodes);
            this.nodesToAnimate.forEach(node -> revealedNodes.add(node.position));
            this.getDestinationAtPosition(revealedNodes, (int)mouseX, (int)mouseY).ifPresent(this::selectDestination);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void selectDestination(TeleportHelper.TeleportDestination destination) {
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        if (PlayerData.isChartingPath((Player)this.f_96541_.f_91074_)) {
            HudMessageManager.queueMessage("message.via_romana.cannot_warp_when_recording");
            this.m_7379_();
            return;
        }
        if (EffectUtils.hasEffect((Entity)this.f_96541_.f_91074_, "travellers_fatigue")) {
            HudMessageManager.queueMessage("message.via_romana.has_fatigue");
            this.m_7379_();
            return;
        }
        if (FadeManager.isActive()) {
            HudMessageManager.queueMessage("message.via_romana.cannot_warp_when_warping");
            this.m_7379_();
            return;
        }
        TeleportRequestC2S packet = new TeleportRequestC2S(this.signPos, destination.position);
        Dispatcher.sendToServer((Object)packet);
        this.m_7379_();
    }

    private void validateNodeSign(BlockPos nodePos) {
        if (!this.validatedNodes.contains(nodePos)) {
            SignValidationRequestC2S packet = new SignValidationRequestC2S(nodePos);
            Dispatcher.sendToServer((Object)packet);
        }
    }

    public void handleSignValidation(BlockPos nodePos, boolean isValid) {
        if (isValid) {
            this.validatedNodes.add(nodePos);
        }
    }

    private void calculateBounds() {
        if (this.networkNodeMap.isEmpty()) {
            BlockPos playerPos = this.f_96541_.f_91074_ != null ? this.f_96541_.f_91074_.m_20183_() : BlockPos.f_121853_;
            this.minBounds = playerPos.m_7918_(-128, 0, -128);
            this.maxBounds = playerPos.m_7918_(128, 0, 128);
            return;
        }
        IntSummaryStatistics xStats = this.networkNodeMap.keySet().stream().mapToInt(Vec3i::m_123341_).summaryStatistics();
        IntSummaryStatistics zStats = this.networkNodeMap.keySet().stream().mapToInt(Vec3i::m_123343_).summaryStatistics();
        this.minBounds = new BlockPos(xStats.getMin(), 0, zStats.getMin());
        this.maxBounds = new BlockPos(xStats.getMax(), 0, zStats.getMax());
    }

    private Optional<Point> worldToScreen(BlockPos worldPos) {
        if (this.mapRenderer == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.mapRenderer.worldToScreen(worldPos, this.f_96543_, this.f_96544_));
    }

    private boolean isMouseOver(Point screenPos, int size, int mouseX, int mouseY) {
        int tolerance = size / 2;
        return Math.abs(mouseX - screenPos.x) <= tolerance && Math.abs(mouseY - screenPos.y) <= tolerance;
    }

    private boolean isMouseOverPlayer(int mouseX, int mouseY) {
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return false;
        }
        return this.worldToScreen(this.f_96541_.f_91074_.m_20183_()).map(screenPos -> this.isMouseOver((Point)screenPos, 8, mouseX, mouseY)).orElse(false);
    }

    private Optional<TeleportHelper.TeleportDestination> getDestinationAtPosition(Set<BlockPos> revealedNodes, int mouseX, int mouseY) {
        for (TeleportHelper.TeleportDestination dest : this.destinations) {
            Optional<Point> screenPosOpt;
            if (!revealedNodes.contains(dest.position) || !this.validatedNodes.contains(dest.position) || !(screenPosOpt = this.worldToScreen(dest.position)).isPresent() || !this.isMouseOver(screenPosOpt.get(), 16, mouseX, mouseY)) continue;
            return Optional.of(dest);
        }
        return Optional.empty();
    }

    private void drawLine(GuiGraphics guiGraphics, Point start, Point end, int color, int thickness) {
        int dx = Math.abs(end.x - start.x);
        int sx = start.x < end.x ? 1 : -1;
        int dy = -Math.abs(end.y - start.y);
        int sy = start.y < end.y ? 1 : -1;
        int err = dx + dy;
        int x = start.x;
        int y = start.y;
        int half = thickness / 2;
        while (true) {
            guiGraphics.m_280509_(x - half, y - half, x + thickness - half, y + thickness - half, color);
            if (x == end.x && y == end.y) break;
            int e2 = 2 * err;
            if (e2 >= dy) {
                err += dy;
                x += sx;
            }
            if (e2 > dx) continue;
            err += dx;
            y += sy;
        }
    }

    private float getPixelAngle(Point center, Point pixel) {
        return (float)((Math.toDegrees(Math.atan2(pixel.x - center.x, center.y - pixel.y)) + 360.0) % 360.0);
    }

    private boolean isWithinAngleRange(float angle, float target, float range) {
        float diff = Math.abs(angle - target);
        if (diff > 180.0f) {
            diff = 360.0f - diff;
        }
        return diff <= range;
    }

    private int getFadedColor(int baseColor, float pixelAngle, float facingAngle, float angleRange) {
        float diff = Math.abs(pixelAngle - facingAngle);
        if (diff > 180.0f) {
            diff = 360.0f - diff;
        }
        float fadeFactor = (float)Math.pow(1.0f - diff / angleRange, 1.0);
        fadeFactor = Math.max(0.0f, Math.min(1.0f, fadeFactor));
        int alpha = baseColor >> 24 & 0xFF;
        int fadedAlpha = (int)((float)alpha * fadeFactor);
        return fadedAlpha << 24 | baseColor & 0xFFFFFF;
    }

    public void m_7379_() {
        if (this.mapTexture != null) {
            this.mapTexture.close();
            this.mapTexture = null;
        }
        if (this.mapRenderer != null) {
            this.mapRenderer.close();
            this.mapRenderer = null;
        }
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }
}

