/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.render.NodeRenderer;
import net.rasanovum.viaromana.util.VersionUtils;

@OnlyIn(value=Dist.CLIENT)
public class VignetteRenderer {
    private static final ResourceLocation VIGNETTE_TEXTURE = VersionUtils.getLocation("via_romana:textures/screens/overlay_vignette.png");
    private static final ResourceLocation CHARTING_VIGNETTE_TEXTURE = VersionUtils.getLocation("via_romana:textures/screens/overlay_vignette_charting.png");

    public static void renderVignette(GuiGraphics guiGraphics) {
        try {
            ResourceLocation texture;
            float intensity = NodeRenderer.getCurrentVignetteIntensity();
            int color = NodeRenderer.getCurrentNodeColor();
            ResourceLocation resourceLocation = texture = color == NodeRenderer.CHARTING_BEAM_COLOR ? CHARTING_VIGNETTE_TEXTURE : VIGNETTE_TEXTURE;
            if (intensity > 0.0f) {
                VignetteRenderer.renderVignetteOverlay(guiGraphics, intensity, texture);
            }
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("Error rendering vignette effect", (Throwable)e);
        }
    }

    private static void renderVignetteOverlay(GuiGraphics guiGraphics, float intensity, ResourceLocation texture) {
        Minecraft mc = Minecraft.m_91087_();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(intensity * CommonConfig.node_vignette_opacity));
        guiGraphics.m_280163_(texture, 0, 0, 0.0f, 0.0f, screenWidth, screenHeight, screenWidth, screenHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }
}

