/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.core;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.integration.IntegrationManager;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.path.PathDataManager;
import net.rasanovum.viaromana.util.PathSyncUtils;
import net.rasanovum.viaromana.util.VersionUtils;

public class LinkHandler {
    public static boolean isSignBlock(LevelAccessor world, BlockPos blockPos) {
        BlockState targetBlock = world.m_8055_(blockPos);
        return targetBlock.m_204336_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)VersionUtils.getLocation("via_romana:warp_block")));
    }

    private static PathGraph getPathGraph(LevelAccessor level) {
        if (level instanceof Level) {
            Level levelInstance = (Level)level;
            if (levelInstance.m_5776_()) {
                ClientPathData clientData = ClientPathData.getInstance();
                return clientData.hasValidData() ? clientData.getGraph((ResourceKey<Level>)levelInstance.m_46472_()) : null;
            }
            if (levelInstance instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)levelInstance;
                return PathGraph.getInstance(serverLevel);
            }
        }
        return null;
    }

    public static boolean linkSignToNode(ServerLevel level, LinkData linkData) {
        if (!level.m_46805_(linkData.signPos())) {
            level.m_46865_(linkData.signPos());
        }
        if (!LinkHandler.isSignBlock((LevelAccessor)level, linkData.signPos())) {
            ViaRomana.LOGGER.warn("linkSignToNode: Sign block entity not found at {} or chunk not loaded.", (Object)linkData.signPos());
            return false;
        }
        PathGraph graph = PathGraph.getInstance(level);
        Optional<Node> nodeOpt = graph.getNodeAt(linkData.nodePos());
        if (nodeOpt.isEmpty()) {
            ViaRomana.LOGGER.warn("linkSignToNode: Node not found at {}", (Object)linkData.nodePos());
            return false;
        }
        Node node = nodeOpt.get();
        graph.linkSignToNode(linkData.nodePos(), linkData.signPos(), linkData.linkType(), linkData.owner());
        node.setDestinationName(linkData.destinationName());
        node.setDestinationIcon(linkData.icon());
        PathDataManager.markDirty(level);
        PathSyncUtils.syncPathGraphToAllPlayers(level);
        IntegrationManager.addDestination(level, node);
        return true;
    }

    public static void unlinkSignFromNode(ServerLevel level, BlockPos signPos) {
        if (!LinkHandler.isSignBlock((LevelAccessor)level, signPos)) {
            return;
        }
        PathGraph graph = PathGraph.getInstance(level);
        Optional<Node> nodeOpt = graph.getNodeBySignPos(signPos);
        if (nodeOpt.isPresent()) {
            Node node = nodeOpt.get();
            graph.removeSignLink(signPos);
            PathDataManager.markDirty(level);
            PathSyncUtils.syncPathGraphToAllPlayers(level);
            IntegrationManager.removeDestination(level, node);
        }
    }

    public static void handleSignDestruction(ServerLevel level, BlockPos signPos) {
        Node linkedNode;
        PathGraph graph = PathGraph.getInstance(level);
        Optional<Node> node = LinkHandler.getLinkedNode((LevelAccessor)level, signPos);
        if (node.isPresent() && (linkedNode = node.get()).getSignPos().isPresent() && linkedNode.getSignPos().get().longValue() == signPos.m_121878_()) {
            graph.removeSignLink(signPos);
            PathDataManager.markDirty(level);
            PathSyncUtils.syncPathGraphToAllPlayers(level);
            IntegrationManager.removeDestination(level, linkedNode);
        }
    }

    public static boolean isSignLinked(LevelAccessor world, BlockPos signPos) {
        return LinkHandler.getLinkedNode(world, signPos).isPresent();
    }

    public static Optional<Node> getLinkedNode(LevelAccessor level, BlockPos signPos) {
        if (!LinkHandler.isSignBlock(level, signPos)) {
            return Optional.empty();
        }
        ViaRomana.LOGGER.debug("getLinkedNode: Checking sign at {}", (Object)signPos);
        PathGraph graph = LinkHandler.getPathGraph(level);
        if (graph == null) {
            return Optional.empty();
        }
        return graph.getNodeBySignPos(signPos);
    }

    public static boolean hasAccess(Entity player, Node node) {
        UUID playerUuid = player.m_20148_();
        if (node == null) {
            return false;
        }
        if (node.getPrivateOwner().isEmpty()) {
            return true;
        }
        return playerUuid.equals(node.getPrivateOwner().get());
    }

    public static Optional<LinkData> getLinkData(LevelAccessor level, BlockPos signPos) {
        Level levelInstance;
        Optional<Node> nodeOpt = LinkHandler.getLinkedNode(level, signPos);
        if (nodeOpt.isPresent()) {
            Node node = nodeOpt.get();
            return Optional.of(new LinkData(signPos, node.getBlockPos(), node.getLinkType(), node.getDestinationIcon().orElse(Node.Icon.SIGNPOST), node.getDestinationName().orElse("Travel Destination"), node.getPrivateOwner().orElse(null)));
        }
        if (level instanceof Level && (levelInstance = (Level)level).m_5776_()) {
            ClientPathData clientData = ClientPathData.getInstance();
            return clientData.getTemporarySignLink(signPos);
        }
        return Optional.empty();
    }

    public record LinkData(BlockPos signPos, BlockPos nodePos, Node.LinkType linkType, Node.Icon icon, String destinationName, UUID owner) {
    }
}

