/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.map;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.RandomState;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.ChunkPixelRenderer;
import net.rasanovum.viaromana.storage.level.LevelDataManager;

public class MapPixelAssembler {
    public static RenderScale calculateRenderScale(int width, int height) {
        int maxDim = Math.max(width, height);
        int MAX_DIM = CommonConfig.maximum_map_dimension;
        int totalScale = 1;
        if (maxDim > MAX_DIM) {
            int requiredScale = (int)Math.ceil((double)maxDim / (double)MAX_DIM);
            totalScale = Integer.highestOneBit(requiredScale - 1) << 1;
        }
        int chunkScale = Math.min(totalScale, 16);
        int chunkStride = Math.max(1, totalScale / 16);
        return new RenderScale(chunkScale, chunkStride, chunkScale * chunkStride);
    }

    public static int processChunkPixels(byte[] biomePixels, byte[] chunkPixels, ServerLevel level, Set<ChunkPos> allChunks, Set<ChunkPos> renderedChunks, int scaleFactor, int pixelWidth, int pixelHeight, ChunkPos minChunk, boolean isPseudo, int chunkStride) {
        AtomicInteger chunksWithData = new AtomicInteger(0);
        AtomicInteger chunksFromCache = new AtomicInteger(0);
        AtomicInteger chunksRendered = new AtomicInteger(0);
        AtomicInteger chunksFromBiomeCache = new AtomicInteger(0);
        AtomicInteger chunksRenderedBiome = new AtomicInteger(0);
        Set<ChunkPos> targetChunkSet = !isPseudo ? allChunks : renderedChunks;
        int scaledChunkSize = 16 / scaleFactor;
        int totalChunks = allChunks.size();
        ServerChunkCache chunkSource = level.m_7726_();
        RandomState randomState = chunkSource.m_214994_();
        BiomeSource biomeSource = chunkSource.m_8481_().m_62218_();
        Climate.Sampler climateSampler = randomState.m_224579_();
        int maxBuildHeight = level.m_151558_();
        if (CommonConfig.logging_enum.ordinal() > 1) {
            ViaRomana.LOGGER.info("Starting parallel bake for {} total chunks, {} renderable (isPseudo: {}, stride: {})", (Object)totalChunks, (Object)renderedChunks.size(), (Object)isPseudo, (Object)chunkStride);
        }
        targetChunkSet.parallelStream().forEach(chunkToProcess -> {
            ChunkPixelResult result;
            if (chunkStride > 1) {
                int relX = chunkToProcess.f_45578_ - minChunk.f_45578_;
                int relZ = chunkToProcess.f_45579_ - minChunk.f_45579_;
                if (relX % chunkStride != 0 || relZ % chunkStride != 0) {
                    return;
                }
            }
            byte[] biomeChunkPixels = null;
            if (!isPseudo) {
                BiomePixelResult biomeResult = ChunkPixelRenderer.getOrRenderBiomePixels(level, chunkToProcess, biomeSource, climateSampler, maxBuildHeight);
                biomeChunkPixels = biomeResult.pixels();
                if (biomeChunkPixels == null || biomeChunkPixels.length != 256) {
                    ViaRomana.LOGGER.warn("Failed to generate biome pixels for chunk {}", chunkToProcess);
                    return;
                }
                chunksFromBiomeCache.addAndGet(biomeResult.cacheIncrement());
                chunksRenderedBiome.addAndGet(biomeResult.renderIncrement());
            }
            byte[] chunkPixelData = null;
            if (renderedChunks.contains(chunkToProcess) && (result = MapPixelAssembler.getOrRenderChunkPixels(level, chunkToProcess, scaleFactor, biomeChunkPixels)).pixels() != null && result.pixels().length == 256) {
                chunkPixelData = result.pixels();
                chunksFromCache.addAndGet(result.cacheIncrement());
                chunksRendered.addAndGet(result.renderIncrement());
            }
            if (isPseudo) {
                return;
            }
            int baseX = (chunkToProcess.f_45578_ - minChunk.f_45578_) / chunkStride * scaledChunkSize;
            int baseZ = (chunkToProcess.f_45579_ - minChunk.f_45579_) / chunkStride * scaledChunkSize;
            if (baseX < 0 || baseZ < 0 || baseX + scaledChunkSize > pixelWidth || baseZ + scaledChunkSize > pixelHeight) {
                ViaRomana.LOGGER.warn("Chunk {} out of pixel bounds, skipping", chunkToProcess);
                return;
            }
            byte[] scaledBiomePixels = scaleFactor > 1 ? ChunkPixelRenderer.scalePixels(biomeChunkPixels, scaleFactor) : biomeChunkPixels;
            MapPixelAssembler.copyChunkToFullDirect(scaledBiomePixels, baseX, baseZ, scaledChunkSize, pixelWidth, biomePixels);
            if (chunkPixelData != null) {
                byte[] scaledChunkPixels = scaleFactor > 1 ? ChunkPixelRenderer.scalePixels(chunkPixelData, scaleFactor) : chunkPixelData;
                MapPixelAssembler.copyChunkToFullDirect(scaledChunkPixels, baseX, baseZ, scaledChunkSize, pixelWidth, chunkPixels);
            }
            chunksWithData.incrementAndGet();
        });
        if (CommonConfig.logging_enum.ordinal() > 1) {
            ViaRomana.LOGGER.info("Render attempt complete: {}/{} chunks processed. High-res: {} cached, {} rendered. Biome: {} cached, {} rendered.", (Object)chunksWithData.get(), (Object)totalChunks, (Object)chunksFromCache.get(), (Object)chunksRendered.get(), (Object)chunksFromBiomeCache.get(), (Object)chunksRenderedBiome.get());
        }
        if (!isPseudo) {
            int missingCount = totalChunks - chunksWithData.get();
            if (chunksWithData.get() == 0 && totalChunks > 0) {
                ViaRomana.LOGGER.warn("Map Bake: No chunk pixel data was available for the requested map area.");
            } else if (missingCount > 0) {
                ViaRomana.LOGGER.warn("Map Bake: {} chunks were allowed but had no pixel data.", (Object)missingCount);
            }
        }
        return chunksWithData.get();
    }

    private static ChunkPixelResult getOrRenderChunkPixels(ServerLevel level, ChunkPos chunkPos, int scaleFactor, byte[] biomePixels) {
        byte[] pixels;
        Optional<byte[]> cached = LevelDataManager.getPixelBytes(level, chunkPos);
        if (cached.isPresent() && (pixels = cached.get()).length == 256) {
            return new ChunkPixelResult(pixels, 1, 0);
        }
        if (CommonConfig.use_biome_fallback_for_lowres && scaleFactor >= 4 && biomePixels != null && biomePixels.length == 256) {
            return new ChunkPixelResult(biomePixels, 0, 0);
        }
        level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        pixels = ChunkPixelRenderer.renderChunkPixels(level, chunkPos);
        if (pixels.length == 256) {
            LevelDataManager.setPixelBytes(level, chunkPos, pixels);
            return new ChunkPixelResult(pixels, 0, 1);
        }
        ViaRomana.LOGGER.warn("Chunk {} failed to render (invalid size: {}), skipping", (Object)chunkPos, (Object)pixels.length);
        return new ChunkPixelResult(null, 0, 0);
    }

    private static void copyChunkToFullDirect(byte[] chunkPixels, int baseX, int baseZ, int scaledChunkSize, int pixelWidth, byte[] fullPixels) {
        for (int dz = 0; dz < scaledChunkSize; ++dz) {
            int srcIdx = dz * scaledChunkSize;
            int dstIdx = (baseZ + dz) * pixelWidth + baseX;
            System.arraycopy(chunkPixels, srcIdx, fullPixels, dstIdx, scaledChunkSize);
        }
    }

    public record RenderScale(int chunkScale, int chunkStride, int effectiveScale) {
    }

    public record ChunkPixelResult(byte[] pixels, int cacheIncrement, int renderIncrement) {
    }

    public record BiomePixelResult(byte[] pixels, int cacheIncrement, int renderIncrement) {
    }
}

