/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.mixins;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.rasanovum.viaromana.storage.path.legacy.ICustomDataHolder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockEntity.class})
public class BlockEntityMixin
implements ICustomDataHolder {
    @Unique
    private CompoundTag fabricData = new CompoundTag();

    @Inject(method={"saveAdditional"}, at={@At(value="RETURN")})
    private void onSaveAdditional(CompoundTag nbt, CallbackInfo ci) {
        if (!this.fabricData.m_128456_()) {
            nbt.m_128365_("FabricData", (Tag)this.fabricData);
        }
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private void onLoad(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.m_128441_("FabricData")) {
            this.fabricData = nbt.m_128469_("FabricData");
        }
    }

    @Inject(method={"saveWithoutMetadata"}, at={@At(value="RETURN")}, cancellable=true)
    private void onSaveWithoutMetadata(CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag nbt = (CompoundTag)cir.getReturnValue();
        if (!this.fabricData.m_128456_()) {
            nbt.m_128365_("FabricData", (Tag)this.fabricData);
        }
        cir.setReturnValue((Object)nbt);
    }

    @Override
    public CompoundTag getCustomData() {
        return this.fabricData;
    }

    @Override
    public void setCustomData(CompoundTag data) {
        this.fabricData = data;
    }
}

