/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import dev.corgitaco.dataanchor.data.TrackedDataContainer;
import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.registry.TrackedDataRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.init.DataInit;
import net.rasanovum.viaromana.storage.player.PlayerTrackedData;
import net.rasanovum.viaromana.util.VersionUtils;

public record SyncPlayerDataC2S(int playerId, ResourceLocation keyId, CompoundTag dataTag) {
    public static final ResourceLocation TYPE = VersionUtils.getLocation("via_romana:sync_player_data_c2s");
    public static final Object STREAM_CODEC = null;

    public SyncPlayerDataC2S(int playerId, ResourceLocation keyId, CompoundTag dataTag) {
        this.playerId = playerId;
        this.keyId = keyId;
        this.dataTag = dataTag != null ? dataTag.m_6426_() : new CompoundTag();
    }

    public SyncPlayerDataC2S(TrackedDataKey<?> key, Player player, CompoundTag dataTag) {
        this(player.m_19879_(), key.getId(), dataTag);
    }

    public static void encode(FriendlyByteBuf buffer, SyncPlayerDataC2S packet) {
        buffer.m_130130_(packet.playerId);
        buffer.m_130085_(packet.keyId);
        buffer.m_130079_(packet.dataTag);
    }

    public static SyncPlayerDataC2S decode(FriendlyByteBuf buffer) {
        int playerId = buffer.m_130242_();
        ResourceLocation keyId = buffer.m_130281_();
        CompoundTag dataTag = buffer.m_130260_();
        return new SyncPlayerDataC2S(playerId, keyId, dataTag);
    }

    public static void handle(PacketContext<SyncPlayerDataC2S> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            ServerPlayer player = ctx.sender();
            if (player == null || player.m_19879_() != ((SyncPlayerDataC2S)ctx.message()).playerId) {
                ViaRomana.LOGGER.warn("Invalid player ID in sync packet from {}", (Object)(player != null ? player.m_7755_().getString() : "unknown"));
                return;
            }
            SyncPlayerDataC2S packet = (SyncPlayerDataC2S)ctx.message();
            if (DataInit.PLAYER_DATA_KEY == null) {
                ViaRomana.LOGGER.warn("Unknown TrackedData key {} in sync packet from {}", (Object)packet.keyId, (Object)player.m_7755_().getString());
                return;
            }
            TrackedDataContainer container = TrackedDataRegistries.ENTITY.getContainer((Object)player);
            if (container == null) {
                ViaRomana.LOGGER.warn("No data container for player {} on sync", (Object)player.m_7755_().getString());
                return;
            }
            container.dataAnchor$getTrackedData(DataInit.PLAYER_DATA_KEY).filter(data -> data instanceof PlayerTrackedData).ifPresent(data -> {
                try {
                    data.readFromNetwork(packet.dataTag);
                }
                catch (Exception e) {
                    ViaRomana.LOGGER.error("Failed to apply C2S sync for player {}: {}", (Object)player.m_7755_().getString(), (Object)e.getMessage());
                }
            });
        }
    }
}

