/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.tags;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.loaders.Platform;
import net.rasanovum.viaromana.util.VersionUtils;

public class TagGenerator {
    public static final TagKey<Block> PATH_BLOCK_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)VersionUtils.getLocation("via_romana:path_block"));
    public static final TagKey<Block> WARP_BLOCK_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)VersionUtils.getLocation("via_romana:warp_block"));
    public static final TagKey<Block> LEAVES_BLOCK_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)VersionUtils.getLocation("minecraft:leaves"));

    public static void generateAllTags(DynamicDataPack pack, ResourceManager resourceManager) {
        try {
            pack.setClearOnReload(true);
            SimpleTagBuilder pathTagBuilder = TagGenerator.generatePathBlockTagBuilder(resourceManager);
            SimpleTagBuilder warpTagBuilder = TagGenerator.generateWarpBlockTagBuilder(resourceManager);
            pack.addTag(pathTagBuilder, Registries.f_256747_);
            pack.addTag(warpTagBuilder, Registries.f_256747_);
            ViaRomana.LOGGER.info("Successfully generated dynamic tags");
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("Failed to generate tag files", (Throwable)e);
        }
    }

    private static SimpleTagBuilder generatePathBlockTagBuilder(ResourceManager resourceManager) {
        return TagGenerator.generateBlockTagBuilder(PATH_BLOCK_TAG, CommonConfig.path_block_ids, CommonConfig.path_block_tags, CommonConfig.path_block_strings, resourceManager);
    }

    private static SimpleTagBuilder generateWarpBlockTagBuilder(ResourceManager resourceManager) {
        return TagGenerator.generateBlockTagBuilder(WARP_BLOCK_TAG, CommonConfig.warp_block_ids, CommonConfig.warp_block_tags, null, resourceManager);
    }

    private static SimpleTagBuilder generateBlockTagBuilder(TagKey<Block> tagKey, List<String> explicitIds, List<String> tagStrings, List<String> searchStrings, ResourceManager resourceManager) {
        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of(tagKey);
        for (String blockId : explicitIds) {
            if (blockId.isEmpty() || TagGenerator.isBlacklistedBlock(blockId)) continue;
            try {
                tagBuilder.m_215900_(VersionUtils.getLocation(blockId));
            }
            catch (Exception e) {
                ViaRomana.LOGGER.warn("Invalid block ID in config: {}", (Object)blockId);
            }
        }
        for (String tagString : tagStrings) {
            if (tagString.isEmpty() || !TagGenerator.isModLoadedForTag(tagString) || TagGenerator.isBlacklistedBlock(tagString)) continue;
            try {
                ResourceLocation tagLocation = VersionUtils.getLocation(tagString);
                if (!TagGenerator.tagExists(resourceManager, tagLocation)) continue;
                tagBuilder.addTag(tagLocation);
            }
            catch (Exception e) {
                ViaRomana.LOGGER.warn("Invalid tag reference in config: {}", (Object)tagString);
            }
        }
        if (searchStrings != null && !searchStrings.isEmpty()) {
            block6: for (Block block : BuiltInRegistries.f_256975_) {
                ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)block);
                String blockIdString = blockId.toString();
                if (TagGenerator.isBlacklistedBlock(blockIdString)) continue;
                for (String searchString : searchStrings) {
                    if (searchString.isEmpty() || !blockIdString.contains(searchString.toLowerCase())) continue;
                    tagBuilder.m_215900_(blockId);
                    continue block6;
                }
            }
        }
        return tagBuilder;
    }

    private static boolean isModLoadedForTag(String tagString) {
        try {
            ResourceLocation tagLocation = VersionUtils.getLocation(tagString);
            String modId = tagLocation.m_135827_();
            return "minecraft".equals(modId) || Platform.INSTANCE.isModLoaded(modId);
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Invalid tag format: '{}'", (Object)tagString);
            return false;
        }
    }

    private static boolean tagExists(ResourceManager resourceManager, ResourceLocation tagLocation) {
        return true;
    }

    private static boolean isBlacklistedBlock(String blockIdString) {
        for (String blacklistString : CommonConfig.block_string_blacklist) {
            if (blacklistString.isEmpty() || !blockIdString.contains(blacklistString.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

