/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.util;

import commonnetwork.api.Dispatcher;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.integration.IntegrationManager;
import net.rasanovum.viaromana.network.packets.ConfigSyncS2C;
import net.rasanovum.viaromana.network.packets.PathGraphSyncPacket;
import net.rasanovum.viaromana.path.PathGraph;

public class PathSyncUtils {
    public static void syncPathGraphToAllPlayers(ServerLevel level) {
        try {
            PathGraph graph = PathGraph.getInstance(level);
            if (CommonConfig.enable_surveyor_landmark && CommonConfig.enable_surveyor_landmark_coloring) {
                try {
                    IntegrationManager.updateAllNetworkColors(graph, level);
                }
                catch (NullPointerException e) {
                    ViaRomana.LOGGER.warn("Surveyor landmark system not ready yet, skipping network color update for sync");
                }
            }
            PathGraphSyncPacket packet = new PathGraphSyncPacket(graph, (ResourceKey<Level>)level.m_46472_());
            for (ServerPlayer player2 : level.m_8795_(player -> true)) {
                Dispatcher.sendToClient((Object)packet, (ServerPlayer)player2);
            }
            ViaRomana.LOGGER.debug("Synced PathGraph with {} nodes to {} players", (Object)graph.size(), (Object)level.m_8795_(player -> true).size());
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("Failed to sync PathGraph to players in level " + String.valueOf(level.m_46472_().m_135782_()), (Throwable)e);
        }
    }

    public static void syncPathGraphToPlayer(ServerPlayer player) {
        try {
            ServerLevel level = player.m_284548_();
            PathGraph graph = PathGraph.getInstance(level);
            PathGraphSyncPacket packet = new PathGraphSyncPacket(graph, (ResourceKey<Level>)level.m_46472_());
            Dispatcher.sendToClient((Object)packet, (ServerPlayer)player);
            ViaRomana.LOGGER.debug("Synced PathGraph with {} nodes to player {}", (Object)graph.size(), (Object)player.m_7755_().getString());
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("Failed to sync PathGraph to player " + player.m_7755_().getString(), (Throwable)e);
        }
    }

    public static void syncNetworkInvalidationToPlayers(ServerLevel level, int networkId) {
    }

    public static void syncConfigToPlayer(ServerPlayer player) {
        try {
            ConfigSyncS2C packet = new ConfigSyncS2C(CommonConfig.path_quality_threshold, CommonConfig.node_distance_minimum, CommonConfig.node_distance_maximum, CommonConfig.node_utility_distance, CommonConfig.infrastructure_check_radius);
            Dispatcher.sendToClient((Object)packet, (ServerPlayer)player);
            ViaRomana.LOGGER.debug("Synced config to player {}", (Object)player.m_7755_().getString());
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("Failed to sync config to player " + player.m_7755_().getString(), (Throwable)e);
        }
    }

    public static void syncConfigToAllPlayers(MinecraftServer server) {
        try {
            ConfigSyncS2C packet = new ConfigSyncS2C(CommonConfig.path_quality_threshold, CommonConfig.node_distance_minimum, CommonConfig.node_distance_maximum, CommonConfig.node_utility_distance, CommonConfig.infrastructure_check_radius);
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                Dispatcher.sendToClient((Object)packet, (ServerPlayer)player);
            }
            ViaRomana.LOGGER.debug("Synced config to {} players", (Object)server.m_6846_().m_11309_());
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("Failed to sync config to all players", (Throwable)e);
        }
    }
}

