/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client;

import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.rasanovum.viaromana.util.VersionUtils;

public class FadeManager {
    private static int fadeUpTicks = 0;
    private static int holdTicks = 0;
    private static int fadeDownTicks = 0;
    private static int footstepInterval = 0;
    private static int currentTick = 0;
    private static boolean active = false;

    private FadeManager() {
    }

    public static boolean isActive() {
        return active;
    }

    public static void startFade(int fadeUp, int hold, int fadeDown, int footstep) {
        fadeUpTicks = fadeUp;
        holdTicks = hold;
        fadeDownTicks = fadeDown;
        footstepInterval = footstep;
        currentTick = 0;
        active = true;
    }

    public static void onClientTick() {
        int totalTicks;
        if (!active) {
            return;
        }
        if (footstepInterval > 0 && ++currentTick % footstepInterval == 0) {
            FadeManager.playFootstep();
        }
        if (currentTick >= (totalTicks = fadeUpTicks + holdTicks + fadeDownTicks)) {
            active = false;
            currentTick = 0;
        }
    }

    public static float getCurrentFadeAlpha() {
        if (!active) {
            return 0.0f;
        }
        int tick = currentTick;
        if (tick < fadeUpTicks) {
            return (float)tick / (float)fadeUpTicks;
        }
        if ((tick -= fadeUpTicks) < holdTicks) {
            return 1.0f;
        }
        if ((tick -= holdTicks) < fadeDownTicks) {
            return 1.0f - (float)tick / (float)fadeDownTicks;
        }
        return 0.0f;
    }

    private static void playFootstep() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        class_638 level = mc.field_1687;
        if (player == null || level == null) {
            return;
        }
        class_2338 soundSource = player.method_23312();
        class_2680 blockState = level.method_8320(soundSource);
        class_2960 soundId = class_7923.field_41172.method_10221((Object)blockState.method_26231().method_10594());
        if (soundId == null) {
            soundId = VersionUtils.getLocation("minecraft:block.grass.step");
        }
        level.method_8486((double)soundSource.method_10263(), (double)soundSource.method_10264(), (double)soundSource.method_10260(), (class_3414)class_7923.field_41172.method_10223(soundId), class_3419.field_15245, 0.2f, 1.0f, false);
    }
}

