/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.map;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;

public record MapInfo(UUID networkId, byte[] biomePixels, byte[] chunkPixels, int pixelWidth, int pixelHeight, int scaleFactor, int worldMinX, int worldMinZ, int worldMaxX, int worldMaxZ, Long createdAtMs, List<class_1923> allowedChunks, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
    public MapInfo {
        networkNodes = networkNodes != null ? new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(networkNodes) : new ArrayList();
        allowedChunks = allowedChunks != null ? new ArrayList<class_1923>(allowedChunks) : null;
        biomePixels = biomePixels != null ? (byte[])biomePixels.clone() : null;
        chunkPixels = chunkPixels != null ? (byte[])chunkPixels.clone() : null;
    }

    public static MapInfo request(UUID networkId, class_2338 minBounds, class_2338 maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
        return new MapInfo(networkId, null, null, 0, 0, 1, minBounds.method_10263(), minBounds.method_10260(), maxBounds.method_10263(), maxBounds.method_10260(), null, null, networkNodes != null ? new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(networkNodes) : new ArrayList());
    }

    public static MapInfo fromServer(UUID networkId, byte[] biomePixels, byte[] chunkPixels, int pixelWidth, int pixelHeight, int scaleFactor, int worldMinX, int worldMinZ, int worldMaxX, int worldMaxZ, List<class_1923> allowedChunks, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
        return new MapInfo(networkId, biomePixels != null ? (byte[])biomePixels.clone() : null, chunkPixels != null ? (byte[])chunkPixels.clone() : null, pixelWidth, pixelHeight, scaleFactor, worldMinX, worldMinZ, worldMaxX, worldMaxZ, System.currentTimeMillis(), allowedChunks != null ? new ArrayList<class_1923>(allowedChunks) : null, networkNodes != null ? new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(networkNodes) : new ArrayList());
    }

    public boolean hasImageData() {
        return (this.biomePixels != null || this.chunkPixels != null) && this.pixelWidth > 0 && this.pixelHeight > 0;
    }

    public void writeToBuffer(class_2540 buffer) {
        buffer.method_10797(this.networkId);
        buffer.method_53002(this.networkNodes.size());
        for (DestinationResponseS2C.NodeNetworkInfo node : this.networkNodes) {
            buffer.method_10807(node.position);
            buffer.method_52941(node.clearance);
            buffer.method_53002(node.connections.size());
            for (class_2338 connection : node.connections) {
                buffer.method_10807(connection);
            }
        }
        if (this.hasImageData()) {
            buffer.method_52964(true);
            if (this.biomePixels != null) {
                buffer.method_52964(true);
                buffer.method_53002(this.biomePixels.length);
                buffer.method_52983(this.biomePixels);
            } else {
                buffer.method_52964(false);
            }
            if (this.chunkPixels != null) {
                buffer.method_52964(true);
                buffer.method_53002(this.chunkPixels.length);
                buffer.method_52983(this.chunkPixels);
            } else {
                buffer.method_52964(false);
            }
            buffer.method_53002(this.pixelWidth);
            buffer.method_53002(this.pixelHeight);
            buffer.method_53002(this.scaleFactor);
            buffer.method_53002(this.worldMinX);
            buffer.method_53002(this.worldMinZ);
            buffer.method_53002(this.worldMaxX);
            buffer.method_53002(this.worldMaxZ);
            buffer.method_52974(this.createdAtMs != null ? this.createdAtMs : 0L);
        } else {
            buffer.method_52964(false);
        }
    }

    public static MapInfo readFromBuffer(class_2540 buffer) {
        UUID networkId = buffer.method_10790();
        int nodeCount = buffer.readInt();
        ArrayList<DestinationResponseS2C.NodeNetworkInfo> networkNodes = new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            class_2338 nodePos = buffer.method_10811();
            float clearance = buffer.readFloat();
            int connectionCount = buffer.readInt();
            ArrayList<class_2338> connections = new ArrayList<class_2338>(connectionCount);
            for (int j = 0; j < connectionCount; ++j) {
                connections.add(buffer.method_10811());
            }
            networkNodes.add(new DestinationResponseS2C.NodeNetworkInfo(nodePos, clearance, connections));
        }
        boolean hasPixelData = buffer.readBoolean();
        byte[] biomePixels = null;
        byte[] chunkPixels = null;
        int pixelWidth = 0;
        int pixelHeight = 0;
        int scaleFactor = 1;
        int worldMinX = 0;
        int worldMinZ = 0;
        int worldMaxX = 0;
        int worldMaxZ = 0;
        Long createdAtMs = null;
        if (hasPixelData) {
            boolean hasChunkPixels;
            boolean hasBiomePixels = buffer.readBoolean();
            if (hasBiomePixels) {
                int biomeLength = buffer.readInt();
                biomePixels = new byte[biomeLength];
                buffer.method_52979(biomePixels);
            }
            if (hasChunkPixels = buffer.readBoolean()) {
                int chunkLength = buffer.readInt();
                chunkPixels = new byte[chunkLength];
                buffer.method_52979(chunkPixels);
            }
            pixelWidth = buffer.readInt();
            pixelHeight = buffer.readInt();
            scaleFactor = buffer.readInt();
            worldMinX = buffer.readInt();
            worldMinZ = buffer.readInt();
            worldMaxX = buffer.readInt();
            worldMaxZ = buffer.readInt();
            long ts = buffer.readLong();
            createdAtMs = ts == 0L ? null : Long.valueOf(ts);
        }
        return new MapInfo(networkId, biomePixels, chunkPixels, pixelWidth, pixelHeight, scaleFactor, worldMinX, worldMinZ, worldMaxX, worldMaxZ, createdAtMs, null, networkNodes);
    }
}

