/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.tags;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.loaders.Platform;
import net.rasanovum.viaromana.util.VersionUtils;

public class TagGenerator {
    public static final class_6862<class_2248> PATH_BLOCK_TAG = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)VersionUtils.getLocation("via_romana:path_block"));
    public static final class_6862<class_2248> WARP_BLOCK_TAG = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)VersionUtils.getLocation("via_romana:warp_block"));
    public static final class_6862<class_2248> LEAVES_BLOCK_TAG = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)VersionUtils.getLocation("minecraft:leaves"));

    public static void generateAllTags(DynamicDataPack pack) {
        try {
            pack.setClearOnReload(true);
            SimpleTagBuilder pathTagBuilder = TagGenerator.generatePathBlockTagBuilder();
            SimpleTagBuilder warpTagBuilder = TagGenerator.generateWarpBlockTagBuilder();
            pack.addTag(pathTagBuilder, class_7924.field_41254);
            pack.addTag(warpTagBuilder, class_7924.field_41254);
            ViaRomana.LOGGER.info("Successfully generated dynamic tags to Moonlight DynamicResourcePack");
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("Failed to generate tag files", (Throwable)e);
        }
    }

    private static SimpleTagBuilder generatePathBlockTagBuilder() {
        return TagGenerator.generateBlockTagBuilder(PATH_BLOCK_TAG, CommonConfig.path_block_ids, CommonConfig.path_block_tags, CommonConfig.path_block_strings);
    }

    private static SimpleTagBuilder generateWarpBlockTagBuilder() {
        return TagGenerator.generateBlockTagBuilder(WARP_BLOCK_TAG, CommonConfig.warp_block_ids, CommonConfig.warp_block_tags, null);
    }

    private static SimpleTagBuilder generateBlockTagBuilder(class_6862<class_2248> tagKey, List<String> explicitIds, List<String> tagStrings, List<String> searchStrings) {
        SimpleTagBuilder tagBuilder = SimpleTagBuilder.of(tagKey);
        for (String blockId : explicitIds) {
            if (blockId.isEmpty() || TagGenerator.isBlacklistedBlock(blockId)) continue;
            try {
                class_2960 blockLocation = VersionUtils.getLocation(blockId);
                tagBuilder.method_26784(blockLocation);
                ViaRomana.LOGGER.debug("Added explicit block {} to tag {}", (Object)blockId, (Object)tagKey.comp_327());
            }
            catch (Exception e) {
                ViaRomana.LOGGER.warn("Invalid block ID in config: {}", (Object)blockId);
            }
        }
        for (String tagString : tagStrings) {
            if (tagString.isEmpty() || !TagGenerator.isModLoadedForTag(tagString) || TagGenerator.isBlacklistedBlock(tagString)) continue;
            try {
                class_2960 tagLocation = VersionUtils.getLocation(tagString);
                tagBuilder.addTag(tagLocation);
                ViaRomana.LOGGER.debug("Added tag reference {} to tag {}", (Object)tagString, (Object)tagKey.comp_327());
            }
            catch (Exception e) {
                ViaRomana.LOGGER.warn("Invalid tag reference in config: {}", (Object)tagString);
            }
        }
        if (searchStrings != null && !searchStrings.isEmpty()) {
            block6: for (class_2248 block : class_7923.field_41175) {
                class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
                String blockIdString = blockId.toString();
                if (TagGenerator.isBlacklistedBlock(blockIdString)) continue;
                for (String searchString : searchStrings) {
                    if (searchString.isEmpty() || !blockIdString.contains(searchString.toLowerCase())) continue;
                    tagBuilder.method_26784(blockId);
                    ViaRomana.LOGGER.debug("Added block {} via string match '{}' to tag {}", (Object)blockIdString, (Object)searchString, (Object)tagKey.comp_327());
                    continue block6;
                }
            }
        }
        ViaRomana.LOGGER.info("Generated tag {}", (Object)tagKey.comp_327());
        return tagBuilder;
    }

    private static boolean isModLoadedForTag(String tagString) {
        try {
            class_2960 tagLocation = VersionUtils.getLocation(tagString);
            String modId = tagLocation.method_12836();
            return "minecraft".equals(modId) || Platform.INSTANCE.isModLoaded(modId);
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Invalid tag format: '{}'", (Object)tagString);
            return false;
        }
    }

    private static boolean isBlacklistedBlock(String blockIdString) {
        for (String blacklistString : CommonConfig.block_string_blacklist) {
            if (blacklistString.isEmpty() || !blockIdString.contains(blacklistString.toLowerCase())) continue;
            ViaRomana.LOGGER.debug("Blacklisted block: '{}' from Via Romana block tag", (Object)blockIdString);
            return true;
        }
        return false;
    }
}

