/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.MapClient;
import net.rasanovum.viaromana.client.gui.MapCoordinateSystem;
import net.rasanovum.viaromana.util.VersionUtils;

@OnlyIn(value=Dist.CLIENT)
public class MapRenderer
implements AutoCloseable {
    private static final int SCREEN_MARGIN = 40;
    private static final int BACKGROUND_TILE_SIZE = 32;
    private static final float MIN_VISIBLE_TILE_FRACTION = 0.4f;
    private static final float GRADIENT_RANDOMNESS = 0.3f;
    private static final float MAP_OPACITY = 0.75f;
    private static final int BIOME_LAYER_BLUR_RADIUS = 2;
    private static final ResourceLocation[] CORNER_TILES = MapRenderer.createTileLocations("corner-", 4);
    private static final ResourceLocation[] EDGE_TILES = MapRenderer.createTileLocations("edge-", 24);
    private static final ResourceLocation[] CENTER_TILES = MapRenderer.createTileLocations("center-", 4);
    private static final Map<ResourceLocation, NativeImage> tileImageCache = new ConcurrentHashMap<ResourceLocation, NativeImage>();
    private final long tileSeed;
    private MapClient.MapTexture mapTexture;
    private DynamicTexture bakedDynamicTexture;
    private ResourceLocation bakedTextureLocation;
    private MapCoordinateSystem coordinateSystem;
    private float lastRenderScale = -1.0f;
    private int bakedTextureWidth;
    private int bakedTextureHeight;

    public MapRenderer(BlockPos minBounds, BlockPos maxBounds) {
        this.tileSeed = (long)minBounds.hashCode() * 31L + (long)maxBounds.hashCode();
    }

    public void setMapTexture(MapClient.MapTexture mapTexture) {
        this.mapTexture = mapTexture;
    }

    public void render(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        if (this.mapTexture == null) {
            return;
        }
        int availableWidth = screenWidth - 40;
        int availableHeight = screenHeight - 40;
        float scale = Math.min((float)availableWidth / (float)this.mapTexture.biomeImage().m_84982_(), (float)availableHeight / (float)this.mapTexture.biomeImage().m_85084_());
        if (this.bakedDynamicTexture == null || Math.abs(scale - this.lastRenderScale) > 0.1f) {
            this.rebuildBakedTexture(scale);
        }
        if (this.bakedDynamicTexture == null || this.coordinateSystem == null) {
            return;
        }
        MapCoordinateSystem.MapRenderInfo renderInfo = this.coordinateSystem.updateAndGetRenderInfo(screenWidth, screenHeight);
        guiGraphics.m_280411_(this.bakedTextureLocation, renderInfo.x, renderInfo.y, renderInfo.width, renderInfo.height, 0.0f, 0.0f, this.bakedTextureWidth, this.bakedTextureHeight, this.bakedTextureWidth, this.bakedTextureHeight);
    }

    public Point worldToScreen(BlockPos worldPos, int screenWidth, int screenHeight) {
        if (this.coordinateSystem == null) {
            return null;
        }
        this.coordinateSystem.updateAndGetRenderInfo(screenWidth, screenHeight);
        return this.coordinateSystem.worldToScreen(worldPos);
    }

    @Override
    public void close() {
        if (this.bakedDynamicTexture != null) {
            this.bakedDynamicTexture.close();
            this.bakedDynamicTexture = null;
            this.bakedTextureLocation = null;
        }
    }

    private void rebuildBakedTexture(float scale) {
        this.lastRenderScale = scale;
        if (this.bakedDynamicTexture != null) {
            this.bakedDynamicTexture.close();
        }
        try (NativeImage newBakedImage = this.bakeLayersOnBackground(this.mapTexture.biomeImage(), this.mapTexture.chunkImage());){
            this.bakedTextureWidth = newBakedImage.m_84982_();
            this.bakedTextureHeight = newBakedImage.m_85084_();
            this.bakedDynamicTexture = new DynamicTexture(newBakedImage);
            this.bakedTextureLocation = Minecraft.m_91087_().m_91097_().m_118490_("baked_map", this.bakedDynamicTexture);
        }
        BlockPos imageMin = new BlockPos(this.mapTexture.mapInfo().worldMinX(), 0, this.mapTexture.mapInfo().worldMinZ());
        BlockPos imageMax = new BlockPos(this.mapTexture.mapInfo().worldMaxX(), 0, this.mapTexture.mapInfo().worldMaxZ());
        this.coordinateSystem = new MapCoordinateSystem(imageMin, imageMax, this.mapTexture.biomeImage().m_84982_(), this.mapTexture.biomeImage().m_85084_(), this.bakedTextureWidth, this.bakedTextureHeight, this.mapTexture.mapInfo().scaleFactor());
    }

    private NativeImage bakeLayersOnBackground(NativeImage biomeImage, NativeImage chunkImage) {
        int mapWidthPx = biomeImage.m_84982_();
        int mapHeightPx = biomeImage.m_85084_();
        int padding = (int)Math.ceil(12.8f);
        int requiredWidth = mapWidthPx + 2 * padding;
        int requiredHeight = mapHeightPx + 2 * padding;
        int tilesWide = Math.max(3, (requiredWidth + 32 - 1) / 32);
        int tilesHigh = Math.max(3, (requiredHeight + 32 - 1) / 32);
        NativeImage stackedMap = new NativeImage(biomeImage.m_85102_(), mapWidthPx, mapHeightPx, false);
        try (NativeImage biomeWithOpacity = this.applyImageOpacity(biomeImage, CommonConfig.biome_map_opacity);){
            stackedMap.m_85054_(biomeWithOpacity);
        }
        try (NativeImage biomeWithBlur = this.applyImageBlur(stackedMap, 2);){
            stackedMap.m_85054_(biomeWithBlur);
        }
        try (NativeImage chunkGradient = this.applyEdgeGradient(chunkImage, 12);){
            this.blendImage(stackedMap, chunkGradient, 0, 0, 1.0f);
        }
        NativeImage combined = this.createTiledBackground(tilesWide, tilesHigh);
        try (NativeImage mapGradient = this.applyEdgeGradient(stackedMap, 5);){
            int mapX = (combined.m_84982_() - mapWidthPx) / 2;
            int mapY = (combined.m_85084_() - mapHeightPx) / 2;
            this.blendImage(combined, mapGradient, mapX, mapY, 0.75f);
        }
        stackedMap.close();
        return combined;
    }

    private NativeImage createTiledBackground(int tilesWide, int tilesHigh) {
        int bakedWidth = tilesWide * 32;
        int bakedHeight = tilesHigh * 32;
        NativeImage background = new NativeImage(NativeImage.Format.RGBA, bakedWidth, bakedHeight, true);
        for (int tileY = 0; tileY < tilesHigh; ++tileY) {
            for (int tileX = 0; tileX < tilesWide; ++tileX) {
                TileInfo tileInfo = this.getTileInfo(tileX, tileY, tilesWide, tilesHigh);
                NativeImage source = this.getCachedTileImage(tileInfo.texture());
                if (source == null) continue;
                NativeImage rotated = this.rotateImage(source, tileInfo.rotation());
                this.blitScaled(background, rotated, tileX * 32, tileY * 32, 32, 32);
                if (rotated == source) continue;
                rotated.close();
            }
        }
        return background;
    }

    private NativeImage applyEdgeGradient(NativeImage mapImage, int percentDistance) {
        int width = mapImage.m_84982_();
        int height = mapImage.m_85084_();
        float[][] distanceMap = this.calculateDistanceMap(mapImage);
        int gradientDist = Math.max(2, Math.min(width, height) / (100 / percentDistance));
        NativeImage result = new NativeImage(mapImage.m_85102_(), width, height, false);
        result.m_85054_(mapImage);
        Random gradientRandom = new Random(this.tileSeed);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float distance = distanceMap[x][y];
                if (!(distance < (float)gradientDist)) continue;
                float randomFactor = 1.0f + (gradientRandom.nextFloat() - 0.5f) * 0.3f;
                float gradient = Math.min(1.0f, distance * randomFactor / (float)gradientDist);
                gradient = gradient * gradient * (3.0f - 2.0f * gradient);
                int pixel = result.m_84985_(x, y);
                int adjustedPixel = MapRenderer.applyOpacity(pixel, gradient);
                result.m_84988_(x, y, adjustedPixel);
            }
        }
        return result;
    }

    private float[][] calculateDistanceMap(NativeImage image) {
        int x;
        int y;
        int width = image.m_84982_();
        int height = image.m_85084_();
        float[][] distanceMap = new float[width][height];
        float maxDist = (float)width + (float)height;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                boolean isTransparent = (image.m_84985_(x, y) >>> 24 & 0xFF) < 10;
                boolean isBorder = x == 0 || y == 0 || x == width - 1 || y == height - 1;
                distanceMap[x][y] = isTransparent || isBorder ? 0.0f : maxDist;
            }
        }
        for (y = 1; y < height; ++y) {
            for (x = 1; x < width; ++x) {
                float minNeighbor = Math.min(distanceMap[x - 1][y], distanceMap[x][y - 1]);
                distanceMap[x][y] = Math.min(distanceMap[x][y], minNeighbor + 1.0f);
            }
        }
        for (y = height - 2; y >= 0; --y) {
            for (x = width - 2; x >= 0; --x) {
                float minNeighbor = Math.min(distanceMap[x + 1][y], distanceMap[x][y + 1]);
                distanceMap[x][y] = Math.min(distanceMap[x][y], minNeighbor + 1.0f);
            }
        }
        return distanceMap;
    }

    private void blendImage(NativeImage background, NativeImage foreground, int startX, int startY, float opacity) {
        for (int px = 0; px < foreground.m_84982_(); ++px) {
            for (int py = 0; py < foreground.m_85084_(); ++py) {
                int targetX = startX + px;
                int targetY = startY + py;
                if (targetX < 0 || targetX >= background.m_84982_() || targetY < 0 || targetY >= background.m_85084_()) continue;
                int bgPixel = background.m_84985_(targetX, targetY);
                int fgPixel = MapRenderer.applyOpacity(foreground.m_84985_(px, py), opacity);
                background.m_84988_(targetX, targetY, this.blendOver(bgPixel, fgPixel));
            }
        }
    }

    private NativeImage rotateImage(NativeImage src, int degrees) {
        if (degrees == 0) {
            return src;
        }
        int sw = src.m_84982_();
        int sh = src.m_85084_();
        int dw = degrees == 90 || degrees == 270 ? sh : sw;
        int dh = degrees == 90 || degrees == 270 ? sw : sh;
        NativeImage dest = new NativeImage(src.m_85102_(), dw, dh, false);
        for (int sx = 0; sx < sw; ++sx) {
            block6: for (int sy = 0; sy < sh; ++sy) {
                int dy;
                int dx;
                switch (degrees) {
                    case 90: {
                        dx = sh - 1 - sy;
                        dy = sx;
                        break;
                    }
                    case 180: {
                        dx = sw - 1 - sx;
                        dy = sh - 1 - sy;
                        break;
                    }
                    case 270: {
                        dx = sy;
                        dy = sw - 1 - sx;
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                dest.m_84988_(dx, dy, src.m_84985_(sx, sy));
            }
        }
        return dest;
    }

    private void blitScaled(NativeImage target, NativeImage src, int tx, int ty, int tw, int th) {
        for (int dy = 0; dy < th; ++dy) {
            for (int dx = 0; dx < tw; ++dx) {
                int sx = (int)((float)dx * (float)src.m_84982_() / (float)tw);
                int sy = (int)((float)dy * (float)src.m_85084_() / (float)th);
                if (dx + tx >= target.m_84982_() || dy + ty >= target.m_85084_()) continue;
                target.m_84988_(dx + tx, dy + ty, src.m_84985_(sx, sy));
            }
        }
    }

    private TileInfo getTileInfo(int tileX, int tileY, int tilesWide, int tilesHigh) {
        boolean isRight;
        Random tileRandom = new Random(this.tileSeed + (long)tileY * (long)tilesWide + (long)tileX);
        boolean isTop = tileY == 0;
        boolean isBottom = tileY == tilesHigh - 1;
        boolean isLeft = tileX == 0;
        boolean bl = isRight = tileX == tilesWide - 1;
        if (isTop && isLeft) {
            return new TileInfo(CORNER_TILES[0], 0);
        }
        if (isTop && isRight) {
            return new TileInfo(CORNER_TILES[1], 0);
        }
        if (isBottom && isLeft) {
            return new TileInfo(CORNER_TILES[2], 0);
        }
        if (isBottom && isRight) {
            return new TileInfo(CORNER_TILES[3], 0);
        }
        ResourceLocation edgeTexture = EDGE_TILES[tileRandom.nextInt(EDGE_TILES.length)];
        if (isTop) {
            return new TileInfo(edgeTexture, 0);
        }
        if (isRight) {
            return new TileInfo(edgeTexture, 90);
        }
        if (isBottom) {
            return new TileInfo(edgeTexture, 180);
        }
        if (isLeft) {
            return new TileInfo(edgeTexture, 270);
        }
        return new TileInfo(CENTER_TILES[tileRandom.nextInt(CENTER_TILES.length)], 0);
    }

    private NativeImage getCachedTileImage(ResourceLocation location) {
        return tileImageCache.computeIfAbsent(location, loc -> {
            block8: {
                NativeImage nativeImage;
                block9: {
                    Optional resourceOpt = Minecraft.m_91087_().m_91098_().m_213713_(loc);
                    if (!resourceOpt.isPresent()) break block8;
                    InputStream inputStream = ((Resource)resourceOpt.get()).m_215507_();
                    try {
                        nativeImage = NativeImage.m_85058_((InputStream)inputStream);
                        if (inputStream == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            ViaRomana.LOGGER.error("Failed to load background tile texture: {}", loc, (Object)e);
                        }
                    }
                    inputStream.close();
                }
                return nativeImage;
            }
            return null;
        });
    }

    private static int applyOpacity(int color, float opacity) {
        int alpha = (int)((float)(color >>> 24 & 0xFF) * opacity);
        return alpha << 24 | color & 0xFFFFFF;
    }

    private NativeImage applyImageOpacity(NativeImage source, float opacity) {
        int width = source.m_84982_();
        int height = source.m_85084_();
        NativeImage result = new NativeImage(source.m_85102_(), width, height, false);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = source.m_84985_(x, y);
                int adjustedPixel = MapRenderer.applyOpacity(pixel, opacity);
                result.m_84988_(x, y, adjustedPixel);
            }
        }
        return result;
    }

    private NativeImage applyImageBlur(NativeImage source, int blurRadius) {
        if (blurRadius < 1) {
            return source;
        }
        NativeImage temp = this.applyBlurPass(source, blurRadius, true);
        NativeImage result = this.applyBlurPass(temp, blurRadius, false);
        temp.close();
        return result;
    }

    private NativeImage applyBlurPass(NativeImage source, int blurRadius, boolean horizontal) {
        int width = source.m_84982_();
        int height = source.m_85084_();
        NativeImage result = new NativeImage(source.m_85102_(), width, height, false);
        int kernelSize = 2 * blurRadius + 1;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int sumA = 0;
                int sumR = 0;
                int sumG = 0;
                int sumB = 0;
                for (int k = -blurRadius; k <= blurRadius; ++k) {
                    int sampleY;
                    int sampleX;
                    if (horizontal) {
                        sampleX = Math.min(width - 1, Math.max(0, x + k));
                        sampleY = y;
                    } else {
                        sampleX = x;
                        sampleY = Math.min(height - 1, Math.max(0, y + k));
                    }
                    int pixel = source.m_84985_(sampleX, sampleY);
                    sumA += pixel >> 24 & 0xFF;
                    sumR += pixel >> 16 & 0xFF;
                    sumG += pixel >> 8 & 0xFF;
                    sumB += pixel & 0xFF;
                }
                int avgA = sumA / kernelSize;
                int avgR = sumR / kernelSize;
                int avgG = sumG / kernelSize;
                int avgB = sumB / kernelSize;
                result.m_84988_(x, y, avgA << 24 | avgR << 16 | avgG << 8 | avgB);
            }
        }
        return result;
    }

    private int blendOver(int bg, int fg) {
        int fgA = fg >> 24 & 0xFF;
        if (fgA == 0) {
            return bg;
        }
        int bgA = bg >> 24 & 0xFF;
        int invA = 255 - fgA;
        int outR = ((fg >> 16 & 0xFF) * fgA + (bg >> 16 & 0xFF) * invA) / 255;
        int outG = ((fg >> 8 & 0xFF) * fgA + (bg >> 8 & 0xFF) * invA) / 255;
        int outB = ((fg & 0xFF) * fgA + (bg & 0xFF) * invA) / 255;
        int outA = fgA + bgA * invA / 255;
        return outA << 24 | outR << 16 | outG << 8 | outB;
    }

    private static ResourceLocation[] createTileLocations(String prefix, int count) {
        String basePath = "via_romana:textures/screens/background_tile/";
        return (ResourceLocation[])IntStream.range(1, count + 1).mapToObj(i -> VersionUtils.getLocation(basePath + prefix + i + ".png")).toArray(ResourceLocation[]::new);
    }

    public static void clearCache() {
        ViaRomana.LOGGER.info("Clearing MapRenderer tile image cache ({} entries)", (Object)tileImageCache.size());
        tileImageCache.values().forEach(NativeImage::close);
        tileImageCache.clear();
    }

    private record TileInfo(ResourceLocation texture, int rotation) {
    }

    public static class Holder {
        private MapRenderer current;
        private MapKey lastKey;

        public MapRenderer getOrCreate(BlockPos minBounds, BlockPos maxBounds) {
            MapKey currentKey = new MapKey(minBounds, maxBounds);
            if (this.current == null || !currentKey.equals(this.lastKey)) {
                if (this.current != null) {
                    this.current.close();
                }
                this.current = new MapRenderer(minBounds, maxBounds);
                this.lastKey = currentKey;
            }
            return this.current;
        }

        public void close() {
            if (this.current != null) {
                this.current.close();
                this.current = null;
            }
        }
    }

    private record MapKey(BlockPos min, BlockPos max) {
    }
}

