/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.map;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.MapPixelAssembler;
import net.rasanovum.viaromana.storage.level.LevelDataManager;
import net.rasanovum.viaromana.util.VersionUtils;

public class ChunkPixelRenderer {
    private static final Map<ResourceLocation, Integer> biomeColorCache = new HashMap<ResourceLocation, Integer>();
    private static Map<String, Integer> parsedBiomeColors = null;
    private static final MapColor WATER_MAP_COLOR = MapColor.f_283864_;
    private static TagKey<Biome> badlandsTag;
    private static TagKey<Biome> beachTag;
    private static TagKey<Biome> oceanTag;
    private static TagKey<Biome> deepOceanTag;
    private static TagKey<Biome> endTag;
    private static TagKey<Biome> forestTag;
    private static TagKey<Biome> hillTag;
    private static TagKey<Biome> jungleTag;
    private static TagKey<Biome> mountainTag;
    private static TagKey<Biome> netherTag;
    private static TagKey<Biome> riverTag;
    private static TagKey<Biome> savannaTag;
    private static TagKey<Biome> taigaTag;
    private static TagKey<Biome> desertTag;
    private static TagKey<Biome> swampTag;
    private static TagKey<Biome> plainsTag;

    public static void init() {
        biomeColorCache.clear();
        parsedBiomeColors = new HashMap<String, Integer>();
        for (String biomePair : CommonConfig.biomeColor) {
            if (biomePair.trim().isEmpty()) continue;
            try {
                String[] parts = biomePair.split("=", 2);
                if (parts.length != 2) continue;
                String biome = parts[0].trim();
                int color = Integer.parseInt(parts[1].trim());
                parsedBiomeColors.put(biome, color);
            }
            catch (Exception e) {
                ViaRomana.LOGGER.warn("Skipping invalid biome color pair '{}': {}", (Object)biomePair, (Object)e.getMessage());
            }
        }
        ViaRomana.LOGGER.info("Loaded {} biome-color pairs from config.", (Object)parsedBiomeColors.size());
        badlandsTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)VersionUtils.getLocation("minecraft:is_badlands"));
        beachTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)VersionUtils.getLocation("minecraft:is_beach"));
        oceanTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)VersionUtils.getLocation("minecraft:is_ocean"));
        deepOceanTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)VersionUtils.getLocation("minecraft:is_deep_ocean"));
        endTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)VersionUtils.getLocation("minecraft:is_end"));
        forestTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)VersionUtils.getLocation("minecraft:is_forest"));
        hillTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)VersionUtils.getLocation("minecraft:is_hill"));
        jungleTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)VersionUtils.getLocation("minecraft:is_jungle"));
        mountainTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)VersionUtils.getLocation("minecraft:is_mountain"));
        netherTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)VersionUtils.getLocation("minecraft:is_nether"));
        riverTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)VersionUtils.getLocation("minecraft:is_river"));
        savannaTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)VersionUtils.getLocation("minecraft:is_savanna"));
        taigaTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)VersionUtils.getLocation("minecraft:is_taiga"));
        desertTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)VersionUtils.getLocation("minecraft:is_desert"));
        swampTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)VersionUtils.getLocation("minecraft:allows_surface_slime_spawns"));
        plainsTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)VersionUtils.getLocation("minecraft:has_structure/village_plains"));
    }

    public static byte[] renderChunkPixels(ServerLevel level, ChunkPos pos) {
        long startTime = System.nanoTime();
        LevelChunk chunk = level.m_6325_(pos.f_45578_, pos.f_45579_);
        int minY = chunk.m_141937_();
        byte[] pixels = new byte[256];
        int chunkMinX = pos.m_45604_();
        int chunkMinZ = pos.m_45605_();
        int[] surfaceHeights = new int[256];
        int[] floorHeights = new int[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int idx = x + z * 16;
                surfaceHeights[idx] = chunk.m_5885_(Heightmap.Types.MOTION_BLOCKING, x, z);
                floorHeights[idx] = chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR, x, z);
            }
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                MapColor.Brightness brightness;
                MapColor mapColor;
                int idx = x + z * 16;
                int surfaceY = surfaceHeights[idx];
                if (surfaceY <= minY) {
                    pixels[idx] = 0;
                    continue;
                }
                int waterDepth = surfaceY - floorHeights[idx];
                if (waterDepth > 0) {
                    mapColor = WATER_MAP_COLOR;
                    brightness = ChunkPixelRenderer.calculateWaterBrightness(idx, waterDepth);
                } else {
                    mutablePos.m_122178_(chunkMinX + x, surfaceY, chunkMinZ + z);
                    BlockState state = chunk.m_8055_((BlockPos)mutablePos);
                    mapColor = state.m_284242_((BlockGetter)level, (BlockPos)mutablePos);
                    if (mapColor == MapColor.f_283808_) {
                        pixels[idx] = 0;
                        continue;
                    }
                    brightness = ChunkPixelRenderer.calculateTerrainBrightness(surfaceHeights, idx);
                }
                pixels[idx] = mapColor.m_284523_(brightness);
            }
        }
        long totalTime = System.nanoTime() - startTime;
        ViaRomana.LOGGER.debug("[PERF] Chunk {} render (raw pixels): total={}ms, size=256B", (Object)pos, (Object)((double)totalTime / 1000000.0));
        return pixels;
    }

    public static byte[] scalePixels(byte[] pixels, int scaleFactor) {
        if (scaleFactor == 1) {
            return pixels;
        }
        int newSize = 16 / scaleFactor;
        byte[] scaled = new byte[newSize * newSize];
        for (int dx = 0; dx < newSize; ++dx) {
            for (int dz = 0; dz < newSize; ++dz) {
                int srcX = dx * scaleFactor;
                int srcZ = dz * scaleFactor;
                int srcIdx = srcX + srcZ * 16;
                scaled[dx + dz * newSize] = pixels[srcIdx];
            }
        }
        return scaled;
    }

    private static MapColor.Brightness calculateWaterBrightness(int idx, int waterDepth) {
        double shade = Math.min((double)waterDepth / 8.0, 1.0) + (double)((idx >> 4) + (idx & 0xF) & 1) * 0.15;
        if ((shade = Math.max(0.1, Math.min(0.9, shade))) < 0.3) {
            return MapColor.Brightness.HIGH;
        }
        if (shade > 0.7) {
            return MapColor.Brightness.LOW;
        }
        return MapColor.Brightness.NORMAL;
    }

    private static MapColor.Brightness calculateTerrainBrightness(int[] heights, int idx) {
        int z_row;
        int currentHeight = heights[idx];
        int x_col = idx & 0xF;
        int westHeight = x_col > 0 ? heights[idx - 1] : currentHeight;
        double shade = (double)(currentHeight - westHeight) * 4.0 / 2.0 + ((double)(x_col + (z_row = idx >> 4) & 1) - 0.5) * 0.4;
        if (shade > 0.6) {
            return MapColor.Brightness.HIGH;
        }
        if (shade < -0.6) {
            return MapColor.Brightness.LOW;
        }
        return MapColor.Brightness.NORMAL;
    }

    public static MapPixelAssembler.BiomePixelResult getOrRenderBiomePixels(ServerLevel level, ChunkPos biomeChunk, BiomeSource biomeSource, Climate.Sampler climateSampler, int maxBuildHeight) {
        int i;
        Optional<byte[]> cachedCorners = LevelDataManager.getCornerBytes(level, biomeChunk);
        int[] cornerPackedIds = new int[4];
        int cacheIncrement = 0;
        int renderIncrement = 0;
        if (cachedCorners.isPresent()) {
            corners = cachedCorners.get();
            for (i = 0; i < 4; ++i) {
                cornerPackedIds[i] = corners[i] & 0xFF;
            }
            cacheIncrement = 1;
        } else {
            corners = new int[][]{{0, 0}, {3, 0}, {0, 3}, {3, 3}};
            Holder[] cornerBiomes = new Holder[4];
            for (int c = 0; c < 4; ++c) {
                int blockX = biomeChunk.m_45604_() + corners[c][0] * 4;
                int blockZ = biomeChunk.m_45605_() + corners[c][1] * 4;
                int blockY = maxBuildHeight;
                int quartX = blockX >> 2;
                int quartY = blockY >> 2;
                int quartZ = blockZ >> 2;
                cornerBiomes[c] = biomeSource.m_203407_(quartX, quartY, quartZ, climateSampler);
            }
            byte[] cornerBytes = new byte[4];
            for (int c = 0; c < 4; ++c) {
                int colorIndex = ChunkPixelRenderer.getColorIndex(level, (Holder<Biome>)cornerBiomes[c]);
                int brightness = colorIndex == 12 ? 0 : 1;
                cornerPackedIds[c] = colorIndex * 4 + brightness;
                cornerBytes[c] = (byte)cornerPackedIds[c];
            }
            LevelDataManager.setCornerBytes(level, biomeChunk, cornerBytes);
            renderIncrement = 1;
        }
        byte[] pixels = new byte[256];
        for (i = 0; i < 256; ++i) {
            int px = i % 16;
            int pz = i / 16;
            int cornerIndex = pz >> 3 << 1 | px >> 3;
            pixels[i] = (byte)cornerPackedIds[cornerIndex];
        }
        return new MapPixelAssembler.BiomePixelResult(pixels, cacheIncrement, renderIncrement);
    }

    private static int getColorIndex(ServerLevel level, Holder<Biome> holder) {
        Biome biome = (Biome)holder.m_203334_();
        ResourceLocation biomeId = level.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)biome);
        assert (biomeId != null);
        if (biomeColorCache.containsKey(biomeId)) {
            return biomeColorCache.get(biomeId);
        }
        int colorIndex = 0;
        if (parsedBiomeColors != null && parsedBiomeColors.containsKey(biomeId.toString())) {
            colorIndex = parsedBiomeColors.get(biomeId.toString());
            biomeColorCache.put(biomeId, colorIndex);
            return colorIndex;
        }
        String biomePath = biomeId.m_135815_().toLowerCase();
        if (biomePath.contains("snow") || biomePath.contains("ice") || biomePath.contains("tundra")) {
            colorIndex = 8;
        } else if (holder.m_203656_(forestTag) || holder.m_203656_(taigaTag) || holder.m_203656_(jungleTag) || holder.m_203656_(swampTag) || biomePath.contains("forest")) {
            colorIndex = 7;
        } else if (holder.m_203656_(deepOceanTag) || holder.m_203656_(oceanTag) || holder.m_203656_(riverTag) || biomePath.contains("ocean")) {
            colorIndex = 12;
        } else if (holder.m_203656_(mountainTag) || holder.m_203656_(hillTag) || biomePath.contains("mountain") || biomePath.contains("hill") || biomePath.contains("stony_shore")) {
            colorIndex = 11;
        } else if (holder.m_203656_(plainsTag) || biomePath.contains("plains") || biomePath.contains("meadow")) {
            colorIndex = 1;
        } else if (holder.m_203656_(beachTag) || holder.m_203656_(endTag) || holder.m_203656_(desertTag) || biomePath.contains("desert")) {
            colorIndex = 2;
        } else if (holder.m_203656_(savannaTag) || biomePath.contains("savanna")) {
            colorIndex = 27;
        } else if (holder.m_203656_(badlandsTag) || biomePath.contains("badlands")) {
            colorIndex = 15;
        } else if (holder.m_203656_(netherTag)) {
            colorIndex = 35;
        } else if (biomePath.contains("mushroom_fields")) {
            colorIndex = 24;
        } else {
            ViaRomana.LOGGER.warn("Biome {} did not match any color index rules, defaulting to 0", (Object)biomeId);
        }
        biomeColorCache.put(biomeId, colorIndex);
        return colorIndex;
    }
}

