/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.path.PathDataManager;
import net.rasanovum.viaromana.util.PathSyncUtils;
import net.rasanovum.viaromana.util.VersionUtils;

public record ChartedPathC2S(List<Node.NodeData> chartedNodes) {
    public static final ResourceLocation TYPE = VersionUtils.getLocation("via_romana:charted_path_c2s");
    public static final Object STREAM_CODEC = null;

    public ChartedPathC2S(List<Node.NodeData> chartedNodes) {
        this.chartedNodes = chartedNodes != null ? List.copyOf(chartedNodes) : List.of();
    }

    public static void encode(FriendlyByteBuf buffer, ChartedPathC2S packet) {
        buffer.writeInt(packet.chartedNodes.size());
        for (Node.NodeData nodeData : packet.chartedNodes) {
            buffer.m_130064_(nodeData.pos());
            buffer.writeFloat(nodeData.quality());
            buffer.writeFloat(nodeData.clearance());
        }
    }

    public static ChartedPathC2S decode(FriendlyByteBuf buffer) {
        int nodeCount = buffer.readInt();
        ArrayList<Node.NodeData> nodes = new ArrayList<Node.NodeData>(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            BlockPos pos = buffer.m_130135_();
            float quality = buffer.readFloat();
            float clearance = buffer.readFloat();
            nodes.add(new Node.NodeData(pos, quality, clearance));
        }
        return new ChartedPathC2S(nodes);
    }

    public static void handle(PacketContext<ChartedPathC2S> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            ServerLevel level = ctx.sender().m_284548_();
            PathGraph graph = PathGraph.getInstance(level);
            UUID playerUUID = ctx.sender().m_20148_();
            List<Node.NodeData> chartingNodes = ((ChartedPathC2S)ctx.message()).chartedNodes();
            if (chartingNodes.isEmpty()) {
                ViaRomana.LOGGER.warn("Received empty charted path from player {}", (Object)ctx.sender().m_7755_().getString());
                return;
            }
            try {
                graph.createConnectedPath(chartingNodes);
                PathDataManager.markDirty(level);
                PathSyncUtils.syncPathGraphToAllPlayers(level);
                ChartedPathC2S.awardAdvancementIfNeeded(ctx.sender());
                UUID pseudoNetworkId = ServerMapCache.getPseudoNetworkId(playerUUID);
                ServerMapCache.invalidatePseudoNetwork(pseudoNetworkId);
                ViaRomana.LOGGER.debug("Created charted path with {} nodes for player {}, cleaned up pseudonetwork {}", (Object)chartingNodes.size(), (Object)ctx.sender().m_7755_().getString(), (Object)pseudoNetworkId);
            }
            catch (Exception e) {
                ViaRomana.LOGGER.error("Failed to create charted path for player {}: {}", (Object)ctx.sender().m_7755_().getString(), (Object)e.getMessage());
            }
        }
    }

    private static void awardAdvancementIfNeeded(ServerPlayer player) {
        try {
            AdvancementProgress advancementProgress;
            Advancement advancement = player.f_8924_.m_129889_().m_136041_(new ResourceLocation("via_romana:story/a_strand_type_game"));
            if (advancement != null && !(advancementProgress = player.m_8960_().m_135996_(advancement)).m_8193_()) {
                for (String c : advancementProgress.m_8219_()) {
                    player.m_8960_().m_135988_(advancement, c);
                }
            }
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Failed to award advancement {} to player {}: {}", (Object)"via_romana:story/a_strand_type_game", (Object)player.m_7755_().getString(), (Object)e.getMessage());
        }
    }
}

