/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.path;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.LongPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;

public class Node {
    private final long pos;
    private final float quality;
    private final float clearance;
    private final LongSet connectedNodes = new LongOpenHashSet();
    private DestinationInfo destinationInfo = null;

    public Node(long pos, float quality, float clearance) {
        this.pos = pos;
        this.quality = quality;
        this.clearance = clearance;
    }

    public Node(CompoundTag tag) {
        this(tag.m_128454_("pos"), tag.m_128457_("quality"), tag.m_128457_("clearance"));
        long[] connections;
        for (long c : connections = tag.m_128467_("connections")) {
            this.addConnection(c);
        }
        if (tag.m_128425_("destination", 10)) {
            CompoundTag destTag = tag.m_128469_("destination");
            DestinationInfo dest = this.getOrCreateDestinationInfo();
            dest.linkType = Node.safeEnum(LinkType.class, destTag.m_128461_("linkType"), LinkType.NONE);
            dest.signPos = destTag.m_128454_("signPos");
            dest.teleportPos = destTag.m_128454_("teleportPos");
            if (destTag.m_128403_("owner")) {
                dest.privateOwner = destTag.m_128342_("owner");
            }
            if (destTag.m_128425_("name", 8)) {
                dest.name = destTag.m_128461_("name");
            }
            if (destTag.m_128425_("icon", 8)) {
                dest.icon = Node.safeEnum(Icon.class, destTag.m_128461_("icon"), null);
            }
        }
    }

    public CompoundTag serialize(CompoundTag tag) {
        tag.m_128356_("pos", this.pos);
        tag.m_128350_("quality", this.quality);
        tag.m_128350_("clearance", this.clearance);
        tag.m_128388_("connections", this.connectedNodes.toLongArray());
        if (this.destinationInfo != null) {
            CompoundTag destTag = new CompoundTag();
            destTag.m_128359_("linkType", this.destinationInfo.linkType.name());
            destTag.m_128356_("signPos", this.destinationInfo.signPos);
            destTag.m_128356_("teleportPos", this.destinationInfo.teleportPos);
            if (this.destinationInfo.privateOwner != null) {
                destTag.m_128362_("owner", this.destinationInfo.privateOwner);
            }
            if (this.destinationInfo.name != null) {
                destTag.m_128359_("name", this.destinationInfo.name);
            }
            if (this.destinationInfo.icon != null) {
                destTag.m_128359_("icon", this.destinationInfo.icon.name());
            }
            tag.m_128365_("destination", (Tag)destTag);
        }
        return tag;
    }

    public long getPos() {
        return this.pos;
    }

    public BlockPos getBlockPos() {
        return BlockPos.m_122022_((long)this.pos);
    }

    public float getQuality() {
        return this.quality;
    }

    public float getClearance() {
        return this.clearance;
    }

    @NotNull
    private DestinationInfo getOrCreateDestinationInfo() {
        if (this.destinationInfo == null) {
            this.destinationInfo = new DestinationInfo(this.pos);
        }
        return this.destinationInfo;
    }

    public boolean isLinked() {
        return this.destinationInfo != null;
    }

    public void unlink() {
        this.destinationInfo = null;
    }

    public LinkType getLinkType() {
        return Optional.ofNullable(this.destinationInfo).map(d -> d.linkType).orElse(LinkType.NONE);
    }

    public void setLinkType(LinkType linkType) {
        if (linkType == LinkType.NONE) {
            this.unlink();
            return;
        }
        this.getOrCreateDestinationInfo().linkType = linkType;
        if (linkType != LinkType.PRIVATE) {
            this.getOrCreateDestinationInfo().privateOwner = null;
        }
    }

    public Optional<Long> getSignPos() {
        return Optional.ofNullable(this.destinationInfo).map(d -> d.signPos);
    }

    public void setSignPos(long signPos) {
        this.getOrCreateDestinationInfo().signPos = signPos;
    }

    public long getTeleportPos() {
        return Optional.ofNullable(this.destinationInfo).map(d -> d.teleportPos).orElse(this.pos);
    }

    public void setTeleportPos(long teleportPos) {
        this.getOrCreateDestinationInfo().teleportPos = teleportPos;
    }

    public Optional<UUID> getPrivateOwner() {
        return Optional.ofNullable(this.destinationInfo).map(d -> d.privateOwner);
    }

    public void setPrivateOwner(UUID owner) {
        DestinationInfo dest = this.getOrCreateDestinationInfo();
        dest.privateOwner = owner;
        dest.linkType = owner != null ? LinkType.PRIVATE : LinkType.DESTINATION;
    }

    public Optional<String> getDestinationName() {
        return Optional.ofNullable(this.destinationInfo).map(d -> d.name);
    }

    public void setDestinationName(String name) {
        this.getOrCreateDestinationInfo().name = name;
    }

    public Optional<Icon> getDestinationIcon() {
        return Optional.ofNullable(this.destinationInfo).map(d -> d.icon);
    }

    public void setDestinationIcon(Icon icon) {
        this.getOrCreateDestinationInfo().icon = icon;
    }

    public boolean isAccessibleBy(UUID playerId) {
        if (!this.isLinked()) {
            return false;
        }
        return switch (this.destinationInfo.linkType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0, 1 -> false;
            case 2 -> true;
            case 3 -> Objects.equals(playerId, this.destinationInfo.privateOwner);
        };
    }

    public LongSet getConnectedNodes() {
        return this.connectedNodes;
    }

    public void connect(Node other) {
        if (other == null || other == this) {
            return;
        }
        this.connectedNodes.add(other.pos);
        other.connectedNodes.add(this.pos);
    }

    public void disconnect(Node other) {
        if (other == null) {
            return;
        }
        this.connectedNodes.remove(other.pos);
        other.connectedNodes.remove(this.pos);
    }

    public void addConnection(long otherPos) {
        if (otherPos != this.pos) {
            this.connectedNodes.add(otherPos);
        }
    }

    public void removeConnection(long otherPos) {
        this.connectedNodes.remove(otherPos);
    }

    void removeConnectionIf(LongPredicate predicate) {
        this.connectedNodes.removeIf(predicate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Node{pos=").append(BlockPos.m_122022_((long)this.pos));
        sb.append(", quality=").append(this.quality);
        sb.append(", neighbors=").append(this.connectedNodes.size());
        if (this.isLinked()) {
            sb.append(", linkType=").append((Object)this.destinationInfo.linkType);
            if (this.destinationInfo.name != null) {
                sb.append(", name=").append(this.destinationInfo.name);
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private static <E extends Enum<E>> E safeEnum(Class<E> type, String name, E fallback) {
        if (name == null || name.isEmpty()) {
            return fallback;
        }
        try {
            return Enum.valueOf(type, name);
        }
        catch (IllegalArgumentException e) {
            return fallback;
        }
    }

    private static class DestinationInfo {
        LinkType linkType = LinkType.NONE;
        long signPos;
        long teleportPos;
        UUID privateOwner = null;
        String name = null;
        Icon icon = null;

        DestinationInfo(long nodePos) {
            this.signPos = nodePos;
            this.teleportPos = nodePos;
        }
    }

    public static enum LinkType {
        NONE,
        ACCESS,
        DESTINATION,
        PRIVATE;

    }

    public static enum Icon {
        SIGNPOST,
        HOUSE,
        SHOP,
        TOWER,
        CAVE,
        CROP,
        PORTAL,
        BOOK;

    }

    public record NodeData(BlockPos pos, float quality, float clearance) {
    }
}

