/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.storage.player;

import commonnetwork.api.Dispatcher;
import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.type.entity.EntityTrackedData;
import dev.corgitaco.dataanchor.data.type.entity.SyncedPlayerTrackedData;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.rasanovum.viaromana.network.packets.SyncPlayerDataC2S;

public class PlayerTrackedData
extends SyncedPlayerTrackedData {
    private boolean chartingPath = false;
    private BlockPos lastNodePos = BlockPos.f_121853_;
    private boolean receivedTutorial = false;

    public PlayerTrackedData(TrackedDataKey<? extends EntityTrackedData> key, Player player) {
        super(key, player);
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("ChartingPath", this.chartingPath);
        tag.m_128356_("LastNodePos", this.lastNodePos.m_121878_());
        tag.m_128379_("ReceivedTutorial", this.receivedTutorial);
        return tag;
    }

    public void load(CompoundTag tag) {
        if (tag.m_128441_("ChartingPath")) {
            this.chartingPath = tag.m_128471_("ChartingPath");
        }
        if (tag.m_128441_("LastNodePos")) {
            this.lastNodePos = BlockPos.m_122022_((long)tag.m_128454_("LastNodePos"));
        }
        if (tag.m_128441_("ReceivedTutorial")) {
            this.receivedTutorial = tag.m_128471_("ReceivedTutorial");
        }
    }

    public CompoundTag writeToNetwork() {
        return this.save();
    }

    public void readFromNetwork(CompoundTag tag) {
        this.load(tag);
    }

    public void sync() {
        if (this.entity.m_9236_() instanceof ServerLevel) {
            super.sync();
        } else if (this.entity.m_9236_() instanceof ClientLevel) {
            Dispatcher.sendToServer((Object)new SyncPlayerDataC2S(this.entity.m_19879_(), this.trackedDataKey.getId(), this.writeToNetwork()));
        }
    }

    public boolean isChartingPath() {
        return this.chartingPath;
    }

    public BlockPos getLastNodePos() {
        return this.lastNodePos;
    }

    public boolean hasReceivedTutorial() {
        return this.receivedTutorial;
    }

    public void setChartingPath(boolean value) {
        if (this.chartingPath != value) {
            this.chartingPath = value;
            this.sync();
        }
    }

    public void setLastNodePos(BlockPos value, boolean sync) {
        if (!this.lastNodePos.equals((Object)value)) {
            this.lastNodePos = value;
            if (sync) {
                this.sync();
            }
        }
    }

    public void setReceivedTutorial(boolean value) {
        if (this.receivedTutorial != value) {
            this.receivedTutorial = value;
            this.sync();
        }
    }

    public void resetVariables() {
        boolean changed = false;
        if (this.chartingPath) {
            this.chartingPath = false;
            changed = true;
        }
        if (!this.lastNodePos.equals((Object)BlockPos.f_121853_)) {
            this.lastNodePos = BlockPos.f_121853_;
            changed = true;
        }
        if (changed) {
            this.sync();
        }
    }
}

