/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.client.ClientConfigCache;
import net.rasanovum.viaromana.items.ChartingMap;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.util.PathUtils;
import net.rasanovum.viaromana.util.VersionUtils;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class InvalidBlockRenderer {
    private static final ResourceLocation BARRIER_TEXTURE = VersionUtils.getLocation("minecraft:textures/item/barrier.png");

    private static float getAlpha() {
        return CommonConfig.invalid_block_overlay_opacity;
    }

    private static int getRadius() {
        return ClientConfigCache.infrastructureCheckRadius;
    }

    public static void renderInfrastructureBlocks(PoseStack poseStack, Level level, Player player, float tickDelta) {
        boolean shouldRender;
        boolean bl = shouldRender = InvalidBlockRenderer.getAlpha() > 0.0f && (PlayerData.isChartingPath(player) || player.m_21205_().m_41720_() instanceof ChartingMap || player.m_21206_().m_41720_() instanceof ChartingMap);
        if (!shouldRender) {
            return;
        }
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110470_((ResourceLocation)BARRIER_TEXTURE));
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        BlockPos centerPos = player.m_20183_();
        int radius = InvalidBlockRenderer.getRadius();
        float baseAlpha = InvalidBlockRenderer.getAlpha();
        double maxDistance = Math.sqrt(3.0) * (double)radius;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius; y <= radius; ++y) {
                    VoxelShape currentShape;
                    BlockPos blockAbove;
                    BlockState blockStateAbove;
                    BlockPos pos = centerPos.m_7918_(x, y, z);
                    BlockState state = level.m_8055_(pos);
                    if (state.m_60795_() || !(blockStateAbove = level.m_8055_(blockAbove = pos.m_7494_())).m_60795_() && blockStateAbove.m_60838_((BlockGetter)level, blockAbove) || (currentShape = state.m_60812_((BlockGetter)level, pos)).m_83281_() || PathUtils.isBlockValidPath((LevelAccessor)level, pos)) continue;
                    double distance = Math.sqrt(x * x + y * y + z * z);
                    float fadeFactor = 1.0f - (float)(distance / maxDistance) * 0.75f;
                    float alpha = baseAlpha * fadeFactor;
                    float topY = (float)currentShape.m_83215_().f_82292_;
                    poseStack.m_85836_();
                    poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                    PoseStack.Pose blockPose = poseStack.m_85850_();
                    InvalidBlockRenderer.renderTopFace(blockPose, consumer, 0.0f, 1.0f, topY, 0.0f, 1.0f, alpha);
                    poseStack.m_85849_();
                }
            }
        }
        poseStack.m_85849_();
        bufferSource.m_109912_(RenderType.m_110470_((ResourceLocation)BARRIER_TEXTURE));
    }

    private static void renderTopFace(PoseStack.Pose pose, VertexConsumer consumer, float minX, float maxX, float y, float minZ, float maxZ, float alpha) {
        int light = 0xF000F0;
        int overlay = 655360;
        float yOffset = y + 0.06f;
        int color = (int)(alpha * 255.0f) << 24 | 0xFF0000 | 0xFF00 | 0xFF;
        Matrix4f matrix = pose.m_252922_();
        consumer.m_252986_(matrix, minX, yOffset, minZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, minX, yOffset, maxZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, maxX, yOffset, maxZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, maxX, yOffset, minZ).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }
}

