/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.render;

import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.rasanovum.viaromana.util.PathUtils;

public class RenderUtil {
    @OnlyIn(value=Dist.CLIENT)
    public static double findSuitableYPosition(ClientLevel level, BlockPos pos, float offsetY) {
        return RenderUtil.findSuitableYPosition(level, pos, offsetY, 5, 5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static double findSuitableYPosition(ClientLevel level, BlockPos pos, float offsetY, int maxUp, int maxDown) {
        if (level.m_7726_().m_62227_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, false) == null) {
            return (float)pos.m_123342_() + offsetY;
        }
        BlockPos belowSource = pos.m_7495_();
        BlockState belowSourceState = level.m_8055_(belowSource);
        VoxelShape belowSourceShape = belowSourceState.m_60742_((BlockGetter)level, belowSource, CollisionContext.m_82749_());
        double sourceSurfaceY = belowSourceShape.m_83281_() ? (double)pos.m_123342_() : (double)belowSource.m_123342_() + belowSourceShape.m_83297_(Direction.Axis.Y);
        ArrayList<Double> validPositions = new ArrayList<Double>();
        for (int yOffset = -maxDown; yOffset <= maxUp; ++yOffset) {
            BlockPos abovePos;
            BlockState aboveState;
            VoxelShape aboveShape;
            BlockPos checkPos = pos.m_7918_(0, yOffset, 0);
            BlockState checkState = level.m_8055_(checkPos);
            VoxelShape checkShape = checkState.m_60742_((BlockGetter)level, checkPos, CollisionContext.m_82749_());
            if (checkShape.m_83281_() && !PathUtils.isBlockValidPath((LevelAccessor)level, checkPos) || !(aboveShape = (aboveState = level.m_8055_(abovePos = checkPos.m_7494_())).m_60742_((BlockGetter)level, abovePos, CollisionContext.m_82749_())).m_83281_() || PathUtils.isBlockValidPath((LevelAccessor)level, abovePos)) continue;
            double surfaceY = checkShape.m_83281_() ? (double)checkPos.m_123342_() + 1.0 : (double)checkPos.m_123342_() + checkShape.m_83297_(Direction.Axis.Y);
            validPositions.add(surfaceY + (double)offsetY);
        }
        if (validPositions.isEmpty()) {
            return sourceSurfaceY + (double)offsetY;
        }
        double biasedTarget = sourceSurfaceY + (double)offsetY + 1.0;
        return validPositions.stream().min(Comparator.comparingDouble(a -> Math.abs(a - biasedTarget))).orElse(sourceSurfaceY + (double)offsetY);
    }
}

