/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.loaders.forge;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.rasanovum.viaromana.client.render.FadeRenderer;
import net.rasanovum.viaromana.client.render.InvalidBlockRenderer;
import net.rasanovum.viaromana.client.render.NodeRenderer;
import net.rasanovum.viaromana.client.render.VignetteRenderer;

@OnlyIn(value=Dist.CLIENT)
public class ForgeRenderInit {
    public static void load() {
        MinecraftForge.EVENT_BUS.addListener(ForgeRenderInit::onRenderGui);
        MinecraftForge.EVENT_BUS.addListener(ForgeRenderInit::onRenderLevelStage);
    }

    public static void onRenderGui(RenderGuiEvent.Post event) {
        GuiGraphics matrices = event.getGuiGraphics();
        float tickDelta = event.getPartialTick();
        VignetteRenderer.renderVignette(matrices);
        FadeRenderer.render(matrices, tickDelta);
    }

    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && mc.f_91073_ != null) {
                float tickDelta = mc.m_91296_();
                NodeRenderer.renderNodeBeams(event.getPoseStack(), (Level)mc.f_91073_, (Player)mc.f_91074_, tickDelta);
                InvalidBlockRenderer.renderInfrastructureBlocks(event.getPoseStack(), (Level)mc.f_91073_, (Player)mc.f_91074_, tickDelta);
            }
        }
    }
}

