/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.util.VersionUtils;

public record PathGraphSyncPacket(CompoundTag pathGraphData, ResourceKey<Level> dimension) {
    public static final ResourceLocation TYPE = VersionUtils.getLocation("via_romana:path_graph_sync_s2c");
    public static final Object STREAM_CODEC = null;

    public PathGraphSyncPacket(PathGraph graph, ResourceKey<Level> dimension) {
        this(graph.serialize(new CompoundTag()), dimension);
    }

    public static void encode(FriendlyByteBuf buf, PathGraphSyncPacket packet) {
        buf.m_130079_(packet.pathGraphData);
        buf.m_130070_(packet.dimension.m_135782_().toString());
    }

    public static PathGraphSyncPacket decode(FriendlyByteBuf buf) {
        CompoundTag data = buf.m_130260_();
        String dimensionStr = buf.m_130277_();
        ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)VersionUtils.getLocation(dimensionStr));
        return new PathGraphSyncPacket(data, (ResourceKey<Level>)dimension);
    }

    public static void handle(PacketContext<PathGraphSyncPacket> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            try {
                PathGraph clientGraph = new PathGraph();
                clientGraph.deserialize(((PathGraphSyncPacket)ctx.message()).pathGraphData());
                ResourceKey<Level> dimension = ((PathGraphSyncPacket)ctx.message()).dimension();
                ClientPathData.getInstance().updatePathData(clientGraph, dimension);
                ViaRomana.LOGGER.debug("Client received PathGraph sync for dimension {} with {} nodes", (Object)dimension.m_135782_(), (Object)clientGraph.size());
            }
            catch (Exception e) {
                ViaRomana.LOGGER.error("Failed to process PathGraph sync packet on client", (Throwable)e);
            }
        }
    }
}

