/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.path.PathDataManager;
import net.rasanovum.viaromana.util.PathSyncUtils;
import net.rasanovum.viaromana.util.VersionUtils;

public record RoutedActionC2S(Operation op) {
    public static final ResourceLocation TYPE = VersionUtils.getLocation("viaromana:action_request_c2s");
    public static final Object STREAM_CODEC = null;

    public static void encode(FriendlyByteBuf buf, RoutedActionC2S packet) {
        buf.m_130130_(packet.op.ordinal());
    }

    public static RoutedActionC2S decode(FriendlyByteBuf buf) {
        int ordinal = buf.m_130242_();
        return new RoutedActionC2S(Operation.values()[ordinal]);
    }

    public static void handle(PacketContext<RoutedActionC2S> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            ctx.sender().f_8924_.execute(() -> {
                ServerPlayer player = ctx.sender();
                ServerLevel level = player.m_284548_();
                PathGraph graph = PathGraph.getInstance(level);
                Optional<Node> nearestOpt = graph.getNearestNode(player.m_20183_(), CommonConfig.node_utility_distance, node -> true);
                if (nearestOpt.isEmpty()) {
                    ViaRomana.LOGGER.warn("No nearby node found for action {} by player {}", (Object)((RoutedActionC2S)ctx.message()).op(), (Object)player.m_7755_().getString());
                    return;
                }
                Node nearestNode = nearestOpt.get();
                switch (((RoutedActionC2S)ctx.message()).op().ordinal()) {
                    case 0: {
                        graph.removeNode(nearestNode);
                        break;
                    }
                    case 1: {
                        graph.removeBranch(nearestNode);
                    }
                }
                PathDataManager.markDirty(level);
                PathSyncUtils.syncPathGraphToAllPlayers(level);
            });
        }
    }

    public static enum Operation {
        SEVER_NEAREST_NODE,
        REMOVE_BRANCH;

    }
}

