/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.storage.player;

import dev.corgitaco.dataanchor.data.TrackedDataContainer;
import dev.corgitaco.dataanchor.data.registry.TrackedDataRegistries;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.rasanovum.viaromana.init.DataInit;
import net.rasanovum.viaromana.storage.player.PlayerTrackedData;

public class PlayerData {
    private static <T> T getValue(Player player, Function<PlayerTrackedData, T> getter, T defaultValue) {
        TrackedDataContainer container = TrackedDataRegistries.ENTITY.getContainer((Object)player);
        if (container == null) {
            return defaultValue;
        }
        return container.dataAnchor$getTrackedData(DataInit.PLAYER_DATA_KEY).filter(data -> data instanceof PlayerTrackedData).map(getter).orElse(defaultValue);
    }

    private static void setValue(Player player, Consumer<PlayerTrackedData> setter) {
        TrackedDataContainer container = TrackedDataRegistries.ENTITY.getContainer((Object)player);
        if (container == null) {
            return;
        }
        Optional<PlayerTrackedData> existing = container.dataAnchor$getTrackedData(DataInit.PLAYER_DATA_KEY).filter(data -> data instanceof PlayerTrackedData);
        if (existing.isEmpty()) {
            container.dataAnchor$createTrackedData();
        }
        container.dataAnchor$getTrackedData(DataInit.PLAYER_DATA_KEY).filter(data -> data instanceof PlayerTrackedData).ifPresent(setter);
    }

    public static boolean isChartingPath(Player player) {
        return PlayerData.getValue(player, PlayerTrackedData::isChartingPath, false);
    }

    public static void setChartingPath(Player player, boolean value) {
        PlayerData.setValue(player, data -> data.setChartingPath(value));
    }

    public static BlockPos getLastNodePos(Player player) {
        return PlayerData.getValue(player, PlayerTrackedData::getLastNodePos, null);
    }

    public static void setLastNodePos(Player player, BlockPos value, boolean sync) {
        PlayerData.setValue(player, data -> data.setLastNodePos(value, sync));
    }

    public static void setReceivedTutorial(Player player, boolean value) {
        PlayerData.setValue(player, data -> data.setReceivedTutorial(value));
    }

    public static void resetVariables(Player player) {
        PlayerData.setValue(player, PlayerTrackedData::resetVariables);
    }
}

