/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.util;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.tags.TagGenerator;

public class PathUtils {
    public static int CLEARANCE_CHECK = 32;

    public static float calculateNodeDistance(Entity entity) {
        if (!(entity instanceof Player)) {
            return 0.0f;
        }
        Player player = (Player)entity;
        BlockPos lastNodePos = PlayerData.getLastNodePos(player);
        double dx = player.m_20185_() - (double)lastNodePos.m_123341_();
        double dy = player.m_20186_() - (double)lastNodePos.m_123342_();
        double dz = player.m_20189_() - (double)lastNodePos.m_123343_();
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static boolean isBlockValidPath(LevelAccessor world, BlockPos targetBlock) {
        if (world.m_46859_(targetBlock)) {
            return false;
        }
        BlockState blockState = world.m_8055_(targetBlock);
        return blockState.m_204336_(TagGenerator.PATH_BLOCK_TAG);
    }

    public static boolean isBlockLeaveBlock(LevelAccessor world, BlockPos targetBlock) {
        if (world.m_46859_(targetBlock)) {
            return false;
        }
        BlockState blockState = world.m_8055_(targetBlock);
        return blockState.m_204336_(TagGenerator.LEAVES_BLOCK_TAG);
    }

    public static float calculateInfrastructureQuality(LevelAccessor world, Entity entity) {
        if (entity == null) {
            return 0.0f;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        if (!entity.m_20096_()) {
            int startY = mutablePos.m_123342_();
            while (world.m_46859_((BlockPos)mutablePos)) {
                mutablePos.m_142448_(mutablePos.m_123342_() - 1);
                if (startY - mutablePos.m_123342_() < 4) continue;
                return 0.0f;
            }
        }
        int surfaceY = mutablePos.m_123342_();
        int checkRadius = CommonConfig.infrastructure_check_radius;
        int pathQuality = 0;
        int entityX = (int)Math.floor(entity.m_20185_());
        int entityZ = (int)Math.floor(entity.m_20189_());
        for (int dx = -checkRadius; dx <= checkRadius; ++dx) {
            for (int dy = -checkRadius; dy <= checkRadius; ++dy) {
                for (int dz = -checkRadius; dz <= checkRadius; ++dz) {
                    mutablePos.m_122178_(entityX + dx, surfaceY + dy, entityZ + dz);
                    if (!PathUtils.isBlockValidPath(world, (BlockPos)mutablePos)) continue;
                    ++pathQuality;
                }
            }
        }
        float totalBlocksChecked = (float)Math.pow(checkRadius * 2 + 1, 2.0);
        return totalBlocksChecked == 0.0f ? 0.0f : (float)pathQuality / totalBlocksChecked;
    }

    public static float calculateClearance(LevelAccessor world, Entity entity) {
        if (entity == null) {
            return 0.0f;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        if (!entity.m_20096_()) {
            int startY = mutablePos.m_123342_();
            while (world.m_46859_((BlockPos)mutablePos)) {
                mutablePos.m_142448_(mutablePos.m_123342_() - 1);
                if (startY - mutablePos.m_123342_() < 4) continue;
                return 0.0f;
            }
        }
        int surfaceY = mutablePos.m_123342_();
        int clearance = 0;
        int entityX = (int)Math.floor(entity.m_20185_());
        int entityZ = (int)Math.floor(entity.m_20189_());
        for (int y = surfaceY + 1; y <= surfaceY + CLEARANCE_CHECK; ++y) {
            mutablePos.m_122178_(entityX, y, entityZ);
            BlockState blockState = world.m_8055_((BlockPos)mutablePos);
            if (!world.m_46859_((BlockPos)mutablePos) && !blockState.m_204336_(TagGenerator.LEAVES_BLOCK_TAG)) {
                return clearance;
            }
            ++clearance;
        }
        return 0.0f;
    }
}

