/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.util;

import java.lang.reflect.Field;
import java.util.Optional;
import net.mehvahdjukaar.supplementaries.client.screens.SignPostScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.client.gui.LinkSignScreen;
import net.rasanovum.viaromana.client.gui.WarpBlockScreen;
import net.rasanovum.viaromana.client.gui.elements.ForceTooltipButton;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.loaders.Platform;
import net.rasanovum.viaromana.mixins.client.AbstractSignEditScreenAccessor;
import net.rasanovum.viaromana.path.Node;

public class SignEditHelper {
    public static Button createLinkButton(Screen screen) {
        BlockPos signPos;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return null;
        }
        ClientPathData clientPathData = ClientPathData.getInstance();
        int yOffset = 0;
        if (screen instanceof AbstractSignEditScreen) {
            AbstractSignEditScreen signEditScreen = (AbstractSignEditScreen)screen;
            signPos = ((AbstractSignEditScreenAccessor)signEditScreen).getSign().m_58899_();
            yOffset = Platform.INSTANCE.isModLoaded("signcopy") ? -26 : 0;
        } else if (screen instanceof WarpBlockScreen) {
            WarpBlockScreen warpBlockScreen = (WarpBlockScreen)screen;
            signPos = warpBlockScreen.getBlockPos();
        } else if (screen instanceof SignPostScreen) {
            SignPostScreen signPostScreen = (SignPostScreen)screen;
            try {
                Field tileField = signPostScreen.getClass().getSuperclass().getDeclaredField("tile");
                tileField.setAccessible(true);
                Object tile = tileField.get(signPostScreen);
                if (!(tile instanceof BlockEntity)) {
                    return null;
                }
                BlockEntity blockEntity = (BlockEntity)tile;
                signPos = blockEntity.m_58899_();
            }
            catch (Exception e) {
                ViaRomana.LOGGER.error("Via Romana: Reflection failed: " + e.getMessage());
                return null;
            }
        } else {
            return null;
        }
        if (!LinkHandler.isSignBlock((LevelAccessor)minecraft.f_91073_, signPos)) {
            return null;
        }
        boolean isSignPermLinked = LinkHandler.isSignLinked((LevelAccessor)player.m_9236_(), signPos);
        boolean isSignTempLinked = clientPathData.isNodeSignLinked(null, signPos);
        Node linkedNode = LinkHandler.getLinkedNode((LevelAccessor)player.m_9236_(), signPos).orElse(null);
        boolean disableButton = false;
        boolean isNodeTemp = false;
        String buttonText = "";
        String tooltip = "";
        LinkHandler.LinkData linkData = null;
        if (isSignPermLinked || isSignTempLinked) {
            if (isSignPermLinked) {
                linkData = LinkHandler.getLinkData((LevelAccessor)player.m_9236_(), signPos).orElse(null);
            } else {
                linkData = clientPathData.getTemporarySignLink(signPos).orElse(null);
                if (linkData != null) {
                    isNodeTemp = clientPathData.isTemporaryNode(linkData.nodePos());
                }
            }
            boolean hasAccess = LinkHandler.hasAccess((Entity)player, linkedNode);
            if (hasAccess || isSignTempLinked) {
                buttonText = "gui.viaromana.edit_destination";
                tooltip = "gui.viaromana.edit_destination_tooltip";
            } else {
                disableButton = true;
                buttonText = "gui.viaromana.no_access";
                tooltip = "gui.viaromana.no_access_tooltip";
            }
        } else {
            Optional<Node> nearestNode = clientPathData.getNearestNode(signPos, CommonConfig.node_utility_distance * 2, true, node -> !node.isLinked(), node -> !clientPathData.isNodeSignLinked(node.getBlockPos(), null));
            boolean isNearNode = nearestNode.isPresent();
            buttonText = "gui.viaromana.add_to_path";
            if (isNearNode) {
                Node node2 = nearestNode.get();
                isNodeTemp = clientPathData.isTemporaryNode(node2.getBlockPos());
                linkData = new LinkHandler.LinkData(signPos, node2.getBlockPos(), Node.LinkType.DESTINATION, Node.Icon.SIGNPOST, Component.m_237115_((String)"gui.viaromana.default_destination_name").getString(), null);
                tooltip = "gui.viaromana.add_to_path_tooltip";
            } else {
                disableButton = true;
                tooltip = "gui.viaromana.place_near_node_tooltip";
            }
        }
        LinkHandler.LinkData finalLinkData = linkData;
        boolean finalIsNodeTemp = isNodeTemp;
        boolean finalIsSignLinked = isSignPermLinked || isSignTempLinked;
        ForceTooltipButton signLinkButton = new ForceTooltipButton(screen.f_96543_ / 2 - 100, screen.f_96544_ / 4 + 120 + yOffset, 200, 20, (Component)Component.m_237115_((String)buttonText), button -> {
            if (finalLinkData != null) {
                assert (Minecraft.m_91087_().f_91074_ != null);
                LinkSignScreen linkScreen = new LinkSignScreen((Player)Minecraft.m_91087_().f_91074_, finalLinkData, finalIsNodeTemp, finalIsSignLinked);
                Minecraft.m_91087_().m_91152_((Screen)linkScreen);
            }
        }, (Component)Component.m_237115_((String)tooltip));
        signLinkButton.f_93623_ = !disableButton;
        return signLinkButton;
    }
}

