/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.core;

import commonnetwork.api.Dispatcher;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.rasanovum.viaromana.client.ClientConfigCache;
import net.rasanovum.viaromana.client.HudMessageManager;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.network.packets.ChartedPathC2S;
import net.rasanovum.viaromana.network.packets.PreProcessChunksC2S;
import net.rasanovum.viaromana.network.packets.SignLinkRequestC2S;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.storage.player.PlayerData;
import net.rasanovum.viaromana.util.PathUtils;
import net.rasanovum.viaromana.util.VersionUtils;

public final class ChartingHandler {
    private static final int PREPROCESS_INTERVAL = 5;

    public static void chartPath(class_1936 level, class_1297 entity) {
        if (!PlayerData.isChartingPath((class_1657)entity)) {
            return;
        }
        float nodeDistance = PathUtils.calculateNodeDistance(entity);
        float infrastructureQuality = PathUtils.calculateInfrastructureQuality(level, entity);
        float clearance = PathUtils.calculateClearance(level, entity);
        if (nodeDistance > (float)ClientConfigCache.nodeDistanceMaximum) {
            HudMessageManager.queueMessage("message.via_romana.too_far_from_node_message");
            return;
        }
        if (infrastructureQuality < ClientConfigCache.pathQualityThreshold) {
            float threshold = ClientConfigCache.pathQualityThreshold;
            int areaCheck = ClientConfigCache.infrastructureCheckRadius * 2 + 1;
            areaCheck *= areaCheck;
            int requiredBlocks = (int)Math.ceil(threshold * (float)areaCheck);
            int currentBlocks = Math.round(infrastructureQuality * (float)areaCheck);
            HudMessageManager.queueMessage((class_2561)class_2561.method_43469((String)"gui.viaromana.infrastructure_insufficient", (Object[])new Object[]{currentBlocks, requiredBlocks}));
            return;
        }
        if (nodeDistance < (float)ClientConfigCache.nodeDistanceMinimum) {
            HudMessageManager.queueMessage("message.via_romana.path_charting");
            return;
        }
        ChartingHandler.addChartingNode(level, entity, entity.method_24515(), Float.valueOf(infrastructureQuality), Float.valueOf(clearance));
    }

    private static void playCartographySound(class_1936 level, class_1657 player) {
        if (!(level instanceof class_1937)) {
            return;
        }
        class_1937 lvl = (class_1937)level;
        class_2338 pos = class_2338.method_49637((double)player.method_23317(), (double)player.method_23318(), (double)player.method_23321());
        class_3414 sound = (class_3414)class_7923.field_41172.method_10223(VersionUtils.getLocation("minecraft:ui.cartography_table.take_result"));
        assert (sound != null);
        if (lvl.method_8608()) {
            lvl.method_8486(player.method_23317(), player.method_23318(), player.method_23321(), sound, class_3419.field_15248, 1.0f, 1.0f, false);
        } else {
            lvl.method_8396(null, pos, sound, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    public static void addChartingNode(class_1936 level, class_1297 entity, class_2338 pos, Float quality, Float clearance) {
        Optional<Node> nearbyNode;
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        if (Math.random() > 0.9) {
            ChartingHandler.playCartographySound(level, player);
        }
        if ((nearbyNode = ClientPathData.getInstance().getNearestNode(pos, ClientConfigCache.nodeUtilityDistance, 1.0, true)).isPresent()) {
            pos = nearbyNode.get().getBlockPos();
            quality = Float.valueOf(nearbyNode.get().getQuality());
            clearance = Float.valueOf(nearbyNode.get().getClearance());
        }
        PlayerData.setLastNodePos(player, pos, false);
        ClientPathData.getInstance().addTemporaryNode(pos, quality.floatValue(), clearance.floatValue());
        List<Node.NodeData> tempNodes = ClientPathData.getInstance().getTemporaryNodes();
        if (tempNodes.size() % 5 == 0 && tempNodes.size() >= 2) {
            PreProcessChunksC2S packet = new PreProcessChunksC2S(tempNodes);
            Dispatcher.sendToServer((Object)packet);
        }
    }

    public static void finishPath(class_746 player) {
        ClientPathData clientPathData = ClientPathData.getInstance();
        List<Node.NodeData> chartingNodes = clientPathData.getTemporaryNodes();
        List<LinkHandler.LinkData> chartingLinks = clientPathData.getTemporaryLinks();
        if (player == null || chartingNodes == null || chartingNodes.isEmpty()) {
            return;
        }
        ChartedPathC2S packet = new ChartedPathC2S(chartingNodes);
        Dispatcher.sendToServer((Object)packet);
        if (chartingLinks != null && !chartingLinks.isEmpty()) {
            for (LinkHandler.LinkData link : chartingLinks) {
                SignLinkRequestC2S linkPacket = new SignLinkRequestC2S(link, false);
                Dispatcher.sendToServer((Object)linkPacket);
            }
        }
        HudMessageManager.queueMessage("message.via_romana.finish_charting");
    }

    public static void initializeChartingNodes(class_746 player) {
        if (player != null) {
            ClientPathData.getInstance().clearTemporaryNodes();
        }
    }
}

