/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.render;

import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.client.render.NodeRenderer;
import net.rasanovum.viaromana.client.render.RenderUtil;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.util.VersionUtils;

@Environment(value=EnvType.CLIENT)
public final class NodeConnectionRenderer {
    private static final double RENDER_DISTANCE = 16.0;
    private static final double FADE_BUFFER_DISTANCE = 4.0;
    private static final float RIBBON_FADE_FRACTION = 0.25f;
    private static final int MIN_SEGMENTS = 4;
    private static final int MAX_SEGMENTS = 24;
    private static final float COHERENCE = 0.6f;
    private static final float WANDER_AMPLITUDE = 0.5f;
    private static final float POINT_DENSITY = 0.5f;
    private static final int SUB_SEGMENTS = 4;
    private static final float VERTICAL_WANDER_SCALE = 0.4f;
    private static final class_2960 CONNECTION_TEXTURE = VersionUtils.getLocation("via_romana:textures/effect/connection_ribbon.png");

    private static class_1921 getRenderType() {
        boolean shadersInUse = false;
        try {
            Class<?> irisApiClass = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            Object instance = irisApiClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            shadersInUse = (Boolean)irisApiClass.getMethod("isShaderPackInUse", new Class[0]).invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            shadersInUse = false;
        }
        return shadersInUse ? class_1921.method_42599((class_2960)CONNECTION_TEXTURE, (boolean)true) : class_1921.method_23592((class_2960)CONNECTION_TEXTURE, (boolean)true);
    }

    private NodeConnectionRenderer() {
    }

    public static void renderConnections(class_4587 poseStack, class_638 level, class_1657 player, PathGraph graph, float animationTime, class_4597 bufferSource, float globalAlpha) {
        if (graph == null || graph.nodesView().isEmpty() || globalAlpha <= 0.0f) {
            return;
        }
        class_243 playerPos = player.method_19538();
        double searchRadius = 20.0;
        List<Node> nearby = ClientPathData.getInstance().getNearbyNodes(class_2338.method_49638((class_2374)playerPos), searchRadius, false);
        if (nearby.isEmpty()) {
            return;
        }
        class_4587.class_4665 pose = poseStack.method_23760();
        RibbonConfig primaryConfig = new RibbonConfig(0.2f, 0.25f, 0.4f, (float)Math.toRadians(70.0), 1.0f, 1.0f, 1.0f, bufferSource.getBuffer(NodeConnectionRenderer.getRenderType()));
        RibbonConfig secondaryConfig = new RibbonConfig(0.2f, 0.3f, -0.3f, (float)Math.toRadians(70.0), 1.0f, 1.0f, 1.0f, bufferSource.getBuffer(NodeConnectionRenderer.getRenderType()));
        RibbonConfig signConfig = new RibbonConfig(0.3f, 0.2f, 0.16f, (float)Math.toRadians(70.0), 1.0f, 1.0f, 1.0f, bufferSource.getBuffer(NodeConnectionRenderer.getRenderType()));
        RibbonConfig tempSignConfig = new RibbonConfig(0.3f, 0.2f, 0.16f, (float)Math.toRadians(70.0), 0.0f, 1.0f, 0.0f, bufferSource.getBuffer(NodeConnectionRenderer.getRenderType()));
        for (Node a : nearby) {
            class_243 aCenter = class_243.method_24953((class_2382)class_2338.method_10092((long)a.getPos()));
            if (playerPos.method_1025(aCenter) > searchRadius * searchRadius) continue;
            LongIterator longIterator = a.getConnectedNodes().iterator();
            while (longIterator.hasNext()) {
                long bPacked = (Long)longIterator.next();
                if (bPacked <= a.getPos()) continue;
                graph.getNodeAt(class_2338.method_10092((long)bPacked)).ifPresent(b -> {
                    class_243 bCenter = class_243.method_24953((class_2382)class_2338.method_10092((long)b.getPos()));
                    if (playerPos.method_1025(aCenter.method_35590(bCenter, 0.5)) <= searchRadius * searchRadius) {
                        NodeConnectionRenderer.renderNodeConnection(pose, level, playerPos, animationTime, aCenter, bCenter, primaryConfig, secondaryConfig, globalAlpha);
                    }
                });
            }
            a.getSignPos().ifPresent(signPosPacked -> {
                class_243 signCenter;
                class_2338 signPos = class_2338.method_10092((long)signPosPacked);
                if (LinkHandler.isSignBlock((class_1936)level, signPos) && playerPos.method_1025(aCenter.method_35590(signCenter = class_243.method_24953((class_2382)signPos), 0.5)) <= searchRadius * searchRadius) {
                    NodeConnectionRenderer.renderSignConnection(pose, level, playerPos, animationTime, aCenter, signCenter, signConfig, globalAlpha);
                }
            });
        }
        ClientPathData clientData = ClientPathData.getInstance();
        for (LinkHandler.LinkData tempLink : clientData.getTemporaryLinks()) {
            class_243 signCenter;
            class_243 nodeCenter;
            class_2338 nodePos = tempLink.nodePos();
            class_2338 signPos = tempLink.signPos();
            if (!LinkHandler.isSignBlock((class_1936)level, signPos) || !(playerPos.method_1025((nodeCenter = class_243.method_24953((class_2382)nodePos)).method_35590(signCenter = class_243.method_24953((class_2382)signPos), 0.5)) <= searchRadius * searchRadius)) continue;
            NodeConnectionRenderer.renderSignConnection(pose, level, playerPos, animationTime, nodeCenter, signCenter, tempSignConfig, globalAlpha);
        }
    }

    private static void renderNodeConnection(class_4587.class_4665 pose, class_638 level, class_243 playerPos, float animationTime, class_243 start, class_243 end, RibbonConfig primary, RibbonConfig secondary, float globalAlpha) {
        class_243 clampedStart = new class_243(start.field_1352, RenderUtil.findSuitableYPosition(level, class_2338.method_49638((class_2374)start), 1.2f), start.field_1350);
        class_243 clampedEnd = new class_243(end.field_1352, RenderUtil.findSuitableYPosition(level, class_2338.method_49638((class_2374)end), 1.2f), end.field_1350);
        double midDist = playerPos.method_1022(clampedStart.method_35590(clampedEnd, 0.5));
        float alpha1 = NodeRenderer.calculateDistanceAlpha(midDist, primary.baseAlpha()) * globalAlpha;
        float alpha2 = NodeRenderer.calculateDistanceAlpha(midDist, secondary.baseAlpha()) * globalAlpha;
        if (alpha1 <= 0.01f && alpha2 <= 0.01f) {
            return;
        }
        PathData path = NodeConnectionRenderer.generateWanderingPath(clampedStart, clampedEnd, animationTime);
        if (alpha1 > 0.01f) {
            NodeConnectionRenderer.drawPath(pose, path, animationTime, primary, alpha1);
        }
        if (alpha2 > 0.01f) {
            NodeConnectionRenderer.drawPath(pose, path, animationTime, secondary, alpha2);
        }
    }

    private static void renderSignConnection(class_4587.class_4665 pose, class_638 level, class_243 playerPos, float animationTime, class_243 start, class_243 end, RibbonConfig config, float globalAlpha) {
        class_243 clampedStart = start.method_38499(class_2350.class_2351.field_11052, RenderUtil.findSuitableYPosition(level, class_2338.method_49638((class_2374)start), 1.2f));
        double midDist = playerPos.method_1022(clampedStart.method_35590(end, 0.5));
        float alpha = NodeRenderer.calculateDistanceAlpha(midDist, config.baseAlpha()) * globalAlpha;
        if (alpha <= 0.01f) {
            return;
        }
        PathData path = NodeConnectionRenderer.generateSimpleArcPath(clampedStart, end, animationTime);
        NodeConnectionRenderer.drawPath(pose, path, animationTime, config, alpha);
    }

    private static PathData generateWanderingPath(class_243 start, class_243 end, float animationTime) {
        ArrayList<class_243> points = new ArrayList<class_243>();
        ArrayList<class_243> tangents = new ArrayList<class_243>();
        class_243 diff = end.method_1020(start);
        double dist = diff.method_1033();
        if (dist < 0.01) {
            return new PathData(points, tangents);
        }
        float effectiveAmp = 0.19999999f;
        if (effectiveAmp <= 0.01f) {
            float baseArc = (float)(0.25 + 0.15 * Math.min(1.0, dist / 8.0));
            float pulse = (float)(Math.sin((double)animationTime * 2.0 + (start.field_1352 + start.field_1350) * 0.3) * 0.1);
            class_243 mid = start.method_1019(diff.method_1021(0.5)).method_1031(0.0, (double)(baseArc + pulse), 0.0);
            int segments = (int)class_3532.method_15350((double)(dist * 6.0), (double)4.0, (double)24.0);
            for (int i = 0; i <= segments; ++i) {
                float t = (float)i / (float)segments;
                points.add(NodeConnectionRenderer.quad(start, mid, end, t));
                tangents.add(NodeConnectionRenderer.quadDerivative(start, mid, end, t).method_1029());
            }
        } else {
            List<class_243> controlPoints = NodeConnectionRenderer.generateControlPoints(start, end, effectiveAmp);
            int numCurveSeg = controlPoints.size() - 1;
            if (numCurveSeg < 1) {
                return new PathData(points, tangents);
            }
            for (int i = 0; i < numCurveSeg; ++i) {
                class_243 p0 = i == 0 ? controlPoints.get(0) : controlPoints.get(i - 1);
                class_243 p1 = controlPoints.get(i);
                class_243 p2 = controlPoints.get(i + 1);
                class_243 p3 = i + 1 == numCurveSeg ? p2 : controlPoints.get(i + 2);
                for (int j = 0; j < 4; ++j) {
                    float t = (float)j / 4.0f;
                    points.add(NodeConnectionRenderer.catmullRom(p0, p1, p2, p3, t));
                    tangents.add(NodeConnectionRenderer.catmullRomDer(p0, p1, p2, p3, t).method_1029());
                }
            }
            points.add(controlPoints.get(controlPoints.size() - 1));
            tangents.add((class_243)tangents.get(tangents.size() - 1));
        }
        return new PathData(points, tangents);
    }

    private static PathData generateSimpleArcPath(class_243 start, class_243 end, float animationTime) {
        ArrayList<class_243> points = new ArrayList<class_243>();
        ArrayList<class_243> tangents = new ArrayList<class_243>();
        class_243 diff = end.method_1020(start);
        double dist = diff.method_1033();
        if (dist < 0.01) {
            return new PathData(points, tangents);
        }
        float baseArc = (float)(0.15 + 0.1 * Math.min(1.0, dist / 6.0));
        float pulse = (float)(Math.sin((double)animationTime * 3.0 + (start.field_1352 + end.field_1350) * 0.5) * 0.05);
        class_243 mid = start.method_1019(diff.method_1021(0.5)).method_1031(0.0, (double)(baseArc + pulse), 0.0);
        int segments = (int)class_3532.method_15350((double)(dist * 4.0), (double)4.0, (double)24.0);
        for (int i = 0; i <= segments; ++i) {
            float t = (float)i / (float)segments;
            points.add(NodeConnectionRenderer.quad(start, mid, end, t));
            tangents.add(NodeConnectionRenderer.quadDerivative(start, mid, end, t).method_1029());
        }
        return new PathData(points, tangents);
    }

    private static List<class_243> generateControlPoints(class_243 start, class_243 end, float effectiveAmp) {
        ArrayList<class_243> controlPoints = new ArrayList<class_243>();
        controlPoints.add(start);
        class_243 diff = end.method_1020(start);
        double dist = diff.method_1033();
        int numInter = (int)(dist * 0.5);
        class_243 tangent = diff.method_1029();
        class_243 perp = tangent.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
        if (perp.method_1027() < 0.1) {
            perp = tangent.method_1036(new class_243(1.0, 0.0, 0.0)).method_1029();
        }
        Random rand = new Random((long)(start.field_1352 * 31.0 + end.field_1352) ^ (long)(start.field_1350 * 31.0 + end.field_1350));
        for (int i = 1; i <= numInter; ++i) {
            float t = (float)i / (float)(numInter + 1);
            class_243 basePos = start.method_1019(diff.method_1021((double)t));
            float horizOffset = (float)(rand.nextGaussian() * (double)effectiveAmp);
            float vertOffset = (float)(rand.nextGaussian() * (double)effectiveAmp * (double)0.4f);
            controlPoints.add(basePos.method_1019(perp.method_1021((double)horizOffset)).method_1031(0.0, (double)vertOffset, 0.0));
        }
        controlPoints.add(end);
        return controlPoints;
    }

    private static void drawPath(class_4587.class_4665 pose, PathData path, float animationTime, RibbonConfig config, float baseAlpha) {
        if (path.points().size() < 2) {
            return;
        }
        float vScroll = -(animationTime * config.scrollSpeedSec());
        double totalDist = path.points().get(0).method_1022(path.points().get(path.points().size() - 1));
        for (int i = 0; i < path.points().size() - 1; ++i) {
            float t0 = (float)i / (float)(path.points().size() - 1);
            float t1 = (float)(i + 1) / (float)(path.points().size() - 1);
            float alpha0 = baseAlpha * NodeConnectionRenderer.fadeEnds(t0);
            float alpha1 = baseAlpha * NodeConnectionRenderer.fadeEnds(t1);
            float v0 = t0 * (float)totalDist * 0.25f + vScroll;
            float v1 = t1 * (float)totalDist * 0.25f + vScroll;
            NodeConnectionRenderer.renderCrossedQuads(pose, config.consumer(), path.points().get(i), path.points().get(i + 1), path.tangents().get(i), path.tangents().get(i + 1), v0, v1, alpha0, alpha1, config.width(), config.crossAngleRadians(), config.r(), config.g(), config.b());
        }
    }

    private static void renderCrossedQuads(class_4587.class_4665 pose, class_4588 consumer, class_243 p0, class_243 p1, class_243 tangent0, class_243 tangent1, float v0, float v1, float alpha0, float alpha1, float width, float crossAngleRadians, float r, float g, float b) {
        class_243 up = new class_243(0.0, 1.0, 0.0);
        class_243 offsetDir0 = up.method_1020(tangent0.method_1021(up.method_1026(tangent0))).method_1029().method_1021((double)width);
        class_243 offsetDir1 = up.method_1020(tangent1.method_1021(up.method_1026(tangent1))).method_1029().method_1021((double)width);
        class_243 normal0 = tangent0.method_1036(offsetDir0).method_1029();
        NodeConnectionRenderer.addDoubleSidedQuad(pose, consumer, p0, p1, offsetDir0, offsetDir1, v0, v1, alpha0, alpha1, normal0, r, g, b);
        class_243 rotatedOffset0 = NodeConnectionRenderer.rotateAroundAxis(offsetDir0, tangent0, crossAngleRadians);
        class_243 rotatedOffset1 = NodeConnectionRenderer.rotateAroundAxis(offsetDir1, tangent1, crossAngleRadians);
        class_243 rotatedNormal0 = tangent0.method_1036(rotatedOffset0).method_1029();
        NodeConnectionRenderer.addDoubleSidedQuad(pose, consumer, p0, p1, rotatedOffset0, rotatedOffset1, v0, v1, alpha0, alpha1, rotatedNormal0, r, g, b);
    }

    private static void addDoubleSidedQuad(class_4587.class_4665 pose, class_4588 consumer, class_243 p0, class_243 p1, class_243 n0, class_243 n1, float v0, float v1, float alpha0, float alpha1, class_243 frontNormal, float r, float g, float b) {
        class_243 e1s = p0.method_1020(n0);
        class_243 e1e = p1.method_1020(n1);
        class_243 e2s = p0.method_1019(n0);
        class_243 e2e = p1.method_1019(n1);
        int overlay = 0;
        int light = 0xF000F0;
        int rgb = (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
        int color0 = (int)(alpha0 * 255.0f) << 24 | rgb;
        int color1 = (int)(alpha1 * 255.0f) << 24 | rgb;
        NodeConnectionRenderer.put(pose, consumer, e1s, color0, 0.0f, v0, overlay, light, frontNormal);
        NodeConnectionRenderer.put(pose, consumer, e1e, color1, 0.0f, v1, overlay, light, frontNormal);
        NodeConnectionRenderer.put(pose, consumer, e2e, color1, 1.0f, v1, overlay, light, frontNormal);
        NodeConnectionRenderer.put(pose, consumer, e2s, color0, 1.0f, v0, overlay, light, frontNormal);
        class_243 backNormal = frontNormal.method_1021(-1.0);
        NodeConnectionRenderer.put(pose, consumer, e2s, color0, 0.0f, v0, overlay, light, backNormal);
        NodeConnectionRenderer.put(pose, consumer, e2e, color1, 0.0f, v1, overlay, light, backNormal);
        NodeConnectionRenderer.put(pose, consumer, e1e, color1, 1.0f, v1, overlay, light, backNormal);
        NodeConnectionRenderer.put(pose, consumer, e1s, color0, 1.0f, v0, overlay, light, backNormal);
    }

    private static void put(class_4587.class_4665 pose, class_4588 consumer, class_243 pos, int color, float u, float v, int overlay, int light, class_243 normal) {
        consumer.method_56824(pose, (float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350).method_39415(color).method_22913(u, v).method_22922(overlay).method_60803(light).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350);
    }

    private static class_243 rotateAroundAxis(class_243 v, class_243 axis, float angle) {
        float cos = class_3532.method_15362((float)angle);
        float sin = class_3532.method_15374((float)angle);
        float dot = (float)v.method_1026(axis);
        return v.method_1021((double)cos).method_1019(axis.method_1036(v).method_1021((double)sin)).method_1019(axis.method_1021((double)(dot * (1.0f - cos))));
    }

    private static float fadeEnds(float t) {
        return class_3532.method_15363((float)(Math.min(t, 1.0f - t) / 0.25f), (float)0.0f, (float)1.0f);
    }

    private static class_243 quad(class_243 p0, class_243 p1, class_243 p2, float t) {
        float it = 1.0f - t;
        return new class_243((double)(it * it) * p0.field_1352 + (double)(2.0f * it * t) * p1.field_1352 + (double)(t * t) * p2.field_1352, (double)(it * it) * p0.field_1351 + (double)(2.0f * it * t) * p1.field_1351 + (double)(t * t) * p2.field_1351, (double)(it * it) * p0.field_1350 + (double)(2.0f * it * t) * p1.field_1350 + (double)(t * t) * p2.field_1350);
    }

    private static class_243 quadDerivative(class_243 p0, class_243 p1, class_243 p2, float t) {
        return new class_243((double)(2.0f * (1.0f - t)) * (p1.field_1352 - p0.field_1352) + (double)(2.0f * t) * (p2.field_1352 - p1.field_1352), (double)(2.0f * (1.0f - t)) * (p1.field_1351 - p0.field_1351) + (double)(2.0f * t) * (p2.field_1351 - p1.field_1351), (double)(2.0f * (1.0f - t)) * (p1.field_1350 - p0.field_1350) + (double)(2.0f * t) * (p2.field_1350 - p1.field_1350));
    }

    private static class_243 catmullRom(class_243 p0, class_243 p1, class_243 p2, class_243 p3, float t) {
        float t2 = t * t;
        float t3 = t2 * t;
        return p0.method_1021((double)(-t3 + 2.0f * t2 - t)).method_1019(p1.method_1021((double)(3.0f * t3 - 5.0f * t2 + 2.0f))).method_1019(p2.method_1021((double)(-3.0f * t3 + 4.0f * t2 + t))).method_1019(p3.method_1021((double)(t3 - t2))).method_1021(0.5);
    }

    private static class_243 catmullRomDer(class_243 p0, class_243 p1, class_243 p2, class_243 p3, float t) {
        float t2 = t * t;
        return p0.method_1021((double)(-3.0f * t2 + 4.0f * t - 1.0f)).method_1019(p1.method_1021((double)(9.0f * t2 - 10.0f * t))).method_1019(p2.method_1021((double)(-9.0f * t2 + 8.0f * t + 1.0f))).method_1019(p3.method_1021((double)(3.0f * t2 - 2.0f * t))).method_1021(0.5);
    }

    private record RibbonConfig(float baseAlpha, float width, float scrollSpeedSec, float crossAngleRadians, float r, float g, float b, class_4588 consumer) {
    }

    private record PathData(List<class_243> points, List<class_243> tangents) {
    }
}

