/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import dev.corgitaco.dataanchor.data.TrackedDataContainer;
import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.registry.TrackedDataRegistries;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.init.DataInit;
import net.rasanovum.viaromana.storage.player.PlayerTrackedData;
import net.rasanovum.viaromana.util.VersionUtils;

public record SyncPlayerDataC2S(int playerId, class_2960 keyId, class_2487 dataTag) implements class_8710
{
    public static final class_8710.class_9154<SyncPlayerDataC2S> TYPE = new class_8710.class_9154(VersionUtils.getLocation("via_romana:sync_player_data_c2s"));
    public static final class_9139<class_2540, SyncPlayerDataC2S> STREAM_CODEC = new class_9139<class_2540, SyncPlayerDataC2S>(){

        public SyncPlayerDataC2S decode(class_2540 buffer) {
            return SyncPlayerDataC2S.decode(buffer);
        }

        public void encode(class_2540 buffer, SyncPlayerDataC2S packet) {
            SyncPlayerDataC2S.encode(buffer, packet);
        }
    };

    public SyncPlayerDataC2S(int playerId, class_2960 keyId, class_2487 dataTag) {
        this.playerId = playerId;
        this.keyId = keyId;
        this.dataTag = dataTag != null ? dataTag.method_10553() : new class_2487();
    }

    public SyncPlayerDataC2S(TrackedDataKey<?> key, class_1657 player, class_2487 dataTag) {
        this(player.method_5628(), key.getId(), dataTag);
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void encode(class_2540 buffer, SyncPlayerDataC2S packet) {
        buffer.method_10804(packet.playerId);
        buffer.method_10812(packet.keyId);
        buffer.method_10794((class_2520)packet.dataTag);
    }

    public static SyncPlayerDataC2S decode(class_2540 buffer) {
        int playerId = buffer.method_10816();
        class_2960 keyId = buffer.method_10810();
        class_2487 dataTag = buffer.method_10798();
        return new SyncPlayerDataC2S(playerId, keyId, dataTag);
    }

    public static void handle(PacketContext<SyncPlayerDataC2S> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            class_3222 player = ctx.sender();
            if (player == null || player.method_5628() != ((SyncPlayerDataC2S)ctx.message()).playerId) {
                ViaRomana.LOGGER.warn("Invalid player ID in sync packet from {}", (Object)(player != null ? player.method_5477().getString() : "unknown"));
                return;
            }
            SyncPlayerDataC2S packet = (SyncPlayerDataC2S)ctx.message();
            if (DataInit.PLAYER_DATA_KEY == null) {
                ViaRomana.LOGGER.warn("Unknown TrackedData key {} in sync packet from {}", (Object)packet.keyId, (Object)player.method_5477().getString());
                return;
            }
            TrackedDataContainer container = TrackedDataRegistries.ENTITY.getContainer((Object)player);
            if (container == null) {
                ViaRomana.LOGGER.warn("No data container for player {} on sync", (Object)player.method_5477().getString());
                return;
            }
            container.dataAnchor$getTrackedData(DataInit.PLAYER_DATA_KEY).filter(data -> data instanceof PlayerTrackedData).ifPresent(data -> {
                try {
                    data.readFromNetwork(packet.dataTag);
                }
                catch (Exception e) {
                    ViaRomana.LOGGER.error("Failed to apply C2S sync for player {}: {}", (Object)player.method_5477().getString(), (Object)e.getMessage());
                }
            });
        }
    }
}

