/*
 * Decompiled with CFR 0.152.
 */
package atonkish.reinfchest;

import atonkish.reinfchest.api.ReinforcedChestsModInitializer;
import atonkish.reinfchest.api.ReinforcedChestsRegistry;
import atonkish.reinfchest.util.ReinforcingMaterialSettings;
import atonkish.reinfcore.api.ReinforcedCoreModInitializer;
import atonkish.reinfcore.api.ReinforcedCoreRegistry;
import atonkish.reinfcore.util.ReinforcingMaterial;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReinforcedChestsMod
implements ReinforcedCoreModInitializer {
    public static final String MOD_ID = "reinfchest";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"reinfchest");

    public void onInitializeReinforcedCore() {
        ReinforcedChestsMod.initializeReinforcedCore();
        ReinforcedChestsMod.initializeReinforcedChests();
        FabricLoader.getInstance().getEntrypoints(MOD_ID, ReinforcedChestsModInitializer.class).forEach(ReinforcedChestsModInitializer::onInitializeReinforcedChests);
    }

    private static void initializeReinforcedCore() {
        for (ReinforcingMaterialSettings materialSettings : ReinforcingMaterialSettings.values()) {
            ReinforcingMaterial material = materialSettings.getMaterial();
            ReinforcedCoreRegistry.registerMaterialSingleBlockScreenModel((ReinforcingMaterial)material);
            ReinforcedCoreRegistry.registerMaterialDoubleBlockScreenModel((ReinforcingMaterial)material);
            ReinforcedCoreRegistry.registerMaterialSingleBlockScreenHandler((ReinforcingMaterial)material);
            ReinforcedCoreRegistry.registerMaterialDoubleBlockScreenHandler((ReinforcingMaterial)material);
        }
    }

    private static void initializeReinforcedChests() {
        for (ReinforcingMaterialSettings materialSettings : ReinforcingMaterialSettings.values()) {
            ReinforcingMaterial material = materialSettings.getMaterial();
            ReinforcedChestsRegistry.registerMaterialOpenStat(MOD_ID, material);
            ReinforcedChestsRegistry.registerMaterialBlock(MOD_ID, material, materialSettings.getBlockSettings());
            ReinforcedChestsRegistry.registerMaterialBlockEntityType(MOD_ID, material);
            ReinforcedChestsRegistry.registerMaterialItem(MOD_ID, material, materialSettings.getItemSettings());
        }
        if (!FabricLoader.getInstance().isModLoaded("reinfshulker")) {
            ReinforcedChestsRegistry.registerMaterialItemGroupIcon(MOD_ID, ReinforcingMaterialSettings.NETHERITE.getMaterial());
        }
    }
}

