/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.sounds;

import com.simibubi.create.infrastructure.config.AllConfigs;
import edn.stratodonut.trackwork.sounds.AmbientGroup;
import edn.stratodonut.trackwork.sounds.ContinuousSound;
import edn.stratodonut.trackwork.sounds.PitchGroups;
import edn.stratodonut.trackwork.sounds.RepeatingSound;
import edn.stratodonut.trackwork.sounds.TrackSoundScapes;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class TrackSoundScape {
    List<ContinuousSound> continuous;
    List<RepeatingSound> repeating;
    private int sound_volume_arg_max = 15;
    private final float pitch;
    private final AmbientGroup group;
    private Vec3 meanPos;
    private final PitchGroups.Group pitchGroup;

    public TrackSoundScape(float pitch, AmbientGroup group) {
        this.pitchGroup = PitchGroups.getGroupFromPitch(pitch);
        this.pitch = pitch;
        this.group = group;
        this.continuous = new ArrayList<ContinuousSound>();
        this.repeating = new ArrayList<RepeatingSound>();
    }

    public TrackSoundScape continuous(SoundEvent sound, float relativeVolume, float relativePitch) {
        return this.add(new ContinuousSound(sound, this, this.pitch * relativePitch, relativeVolume));
    }

    public TrackSoundScape repeating(SoundEvent sound, float relativeVolume, float relativePitch, int delay) {
        return this.add(new RepeatingSound(sound, this, this.pitch * relativePitch, relativeVolume, delay));
    }

    public TrackSoundScape withArgMax(int max) {
        this.sound_volume_arg_max = max;
        return this;
    }

    public TrackSoundScape add(ContinuousSound continuousSound) {
        this.continuous.add(continuousSound);
        return this;
    }

    public TrackSoundScape add(RepeatingSound repeatingSound) {
        this.repeating.add(repeatingSound);
        return this;
    }

    public void play() {
        this.continuous.forEach(arg_0 -> ((SoundManager)Minecraft.m_91087_().m_91106_()).m_120367_(arg_0));
    }

    public void tick() {
        if (AnimationTickHolder.getTicks() % 5 == 0) {
            this.meanPos = null;
        }
        this.repeating.forEach(RepeatingSound::tick);
    }

    public void remove() {
        this.continuous.forEach(ContinuousSound::remove);
    }

    public Vec3 getMeanPos() {
        return this.meanPos == null ? (this.meanPos = this.determineMeanPos()) : this.meanPos;
    }

    private Vec3 determineMeanPos() {
        this.meanPos = Vec3.f_82478_;
        int amount = 0;
        Minecraft mc = Minecraft.m_91087_();
        for (BlockPos blockPos : TrackSoundScapes.getAllLocations(this.group, this.pitchGroup)) {
            if (mc.f_91073_ != null) {
                blockPos = BlockPos.m_274446_((Position)VSGameUtilsKt.toWorldCoordinates((Level)mc.f_91073_, (Vec3)Vec3.m_82512_((Vec3i)blockPos)));
            }
            this.meanPos = this.meanPos.m_82549_(VecHelper.getCenterOf((Vec3i)blockPos));
            ++amount;
        }
        if (amount == 0) {
            return this.meanPos;
        }
        return this.meanPos.m_82490_((double)(1.0f / (float)amount));
    }

    public float getVolume() {
        Entity renderViewEntity = Minecraft.m_91087_().f_91075_;
        float distanceMultiplier = 0.0f;
        if (renderViewEntity != null) {
            double distanceTo = renderViewEntity.m_20182_().m_82554_(this.getMeanPos());
            distanceMultiplier = (float)Mth.m_14139_((double)(distanceTo / (double)TrackSoundScapes.getMaxAmbientSourceDistance()), (double)2.0, (double)0.0);
        }
        int soundCount = TrackSoundScapes.getSoundCount(this.group, this.pitchGroup);
        float max = AllConfigs.client().ambientVolumeCap.getF();
        return Mth.m_14036_((float)((float)soundCount / ((float)this.sound_volume_arg_max * 10.0f)), (float)0.025f, (float)max) * distanceMultiplier;
    }
}

