/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.blocks;

import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.infrastructure.config.AllConfigs;
import edn.stratodonut.trackwork.TrackAmbientGroups;
import edn.stratodonut.trackwork.TrackDamageSources;
import edn.stratodonut.trackwork.TrackPackets;
import edn.stratodonut.trackwork.TrackSounds;
import edn.stratodonut.trackwork.TrackworkConfigs;
import edn.stratodonut.trackwork.TrackworkUtil;
import edn.stratodonut.trackwork.sounds.TrackSoundScapes;
import edn.stratodonut.trackwork.tracks.ITrackPointProvider;
import edn.stratodonut.trackwork.tracks.blocks.SuspensionTrackBlock;
import edn.stratodonut.trackwork.tracks.blocks.TrackBaseBlock;
import edn.stratodonut.trackwork.tracks.blocks.TrackBaseBlockEntity;
import edn.stratodonut.trackwork.tracks.data.PhysTrackData;
import edn.stratodonut.trackwork.tracks.forces.PhysicsTrackController;
import edn.stratodonut.trackwork.tracks.forces.SimpleWheelController;
import edn.stratodonut.trackwork.tracks.network.SuspensionWheelPacket;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.physics_api.PoseVel;

public class SuspensionTrackBlockEntity
extends TrackBaseBlockEntity
implements ITrackPointProvider {
    private float wheelRadius = 0.5f;
    private float suspensionTravel = 1.5f;
    protected final Random random = new Random();
    @NotNull
    protected final Supplier<Ship> ship = () -> VSGameUtilsKt.getShipObjectManagingPos((Level)this.f_58857_, (Vec3i)pos);
    private Integer trackID;
    public boolean assembled = false;
    public boolean assembleNextTick = true;
    private float wheelTravel;
    private float prevWheelTravel;
    private double suspensionScale = 1.0;
    private float horizontalOffset;

    public SuspensionTrackBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static SuspensionTrackBlockEntity large(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        SuspensionTrackBlockEntity be = new SuspensionTrackBlockEntity(type, pos, state);
        be.wheelRadius = 1.0f;
        be.suspensionTravel = 2.0f;
        return be;
    }

    public static SuspensionTrackBlockEntity med(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        SuspensionTrackBlockEntity be = new SuspensionTrackBlockEntity(type, pos, state);
        be.wheelRadius = 0.75f;
        be.suspensionTravel = 1.5f;
        return be;
    }

    public void onLoad() {
        super.onLoad();
    }

    public void remove() {
        ServerShip ship;
        super.remove();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.assembled && (ship = (ServerShip)this.ship.get()) != null) {
            PhysicsTrackController controller = PhysicsTrackController.getOrCreate(ship);
            controller.removeTrackBlock(this.trackID);
        }
    }

    private void assemble() {
        ServerShip ship;
        if (!TrackBaseBlock.isValidAxis((Direction.Axis)this.m_58900_().m_61143_((Property)RotatedPillarKineticBlock.AXIS))) {
            return;
        }
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (ship = (ServerShip)this.ship.get()) != null && org.joml.Math.abs((double)(1.0 - ship.getTransform().getShipToWorldScaling().length())) > 0.01) {
            this.assembled = true;
            PhysicsTrackController controller = PhysicsTrackController.getOrCreate(ship);
            PhysTrackData.PhysTrackCreateData data = new PhysTrackData.PhysTrackCreateData((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82512_((Vec3i)this.m_58899_())));
            this.trackID = controller.addTrackBlock(data);
            this.sendData();
            if (this.trackID != null) {
                // empty if block
            }
        }
    }

    public void disassemble() {
    }

    @Override
    public void tick() {
        super.tick();
        if (this.ship.get() != null && this.assembleNextTick && !this.assembled && this.f_58857_ != null) {
            this.assemble();
            this.assembleNextTick = false;
            return;
        }
        if (this.f_58857_.f_46443_ && this.ship.get() != null) {
            Vector3d pos = VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82539_((Vec3i)this.m_58899_()));
            Vector3d ground = VSGameUtilsKt.getWorldCoordinates((Level)this.f_58857_, (BlockPos)this.m_58899_(), (Vector3d)pos.sub((Vector3dc)PhysicsTrackController.UP.mul((double)this.wheelTravel * 1.2, new Vector3d())));
            BlockPos blockpos = BlockPos.m_274446_((Position)VectorConversionsMCKt.toMinecraft((Vector3dc)ground));
            BlockState blockstate = this.f_58857_.m_8055_(blockpos);
            if (blockstate.m_280296_()) {
                Ship s = this.ship.get();
                Vector3d reversedVel = s.getShipTransform().getShipToWorldRotation().transform(TrackworkUtil.getForwardVec3d((Direction.Axis)this.m_58900_().m_61143_((Property)RotatedPillarKineticBlock.AXIS), this.getSpeed()));
                if (org.joml.Math.abs((float)this.getSpeed()) > 64.0f && blockstate.m_60799_() != RenderShape.INVISIBLE) {
                    this.f_58857_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(blockpos), pos.x + (this.random.nextDouble() - 0.5), pos.y + 0.25, pos.z + (this.random.nextDouble() - 0.5) * (double)this.wheelRadius, reversedVel.x() * -1.0, 10.5, reversedVel.z() * -1.0);
                }
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this.lambda$tick$2(s, (Vector3dc)ground, (Vector3dc)reversedVel));
            }
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.assembled) {
            Vec3 start = Vec3.m_82512_((Vec3i)this.m_58899_());
            Direction.Axis axis = (Direction.Axis)this.m_58900_().m_61143_((Property)RotatedPillarKineticBlock.AXIS);
            double restOffset = this.wheelRadius - 0.5f;
            float trackRPM = this.getSpeed();
            double susScaled = (double)this.suspensionTravel * this.suspensionScale;
            ServerShip ship = (ServerShip)this.ship.get();
            if (ship != null) {
                BlockState b;
                Vec3 worldSpaceNormal = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getTransform().getShipToWorldRotation().transform((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)TrackworkUtil.getActionNormal(axis)), new Vector3d()).mul(susScaled + 0.5));
                Vec3 worldSpaceStart = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML((Vec3)start.m_82520_(0.0, -restOffset, 0.0))));
                Vector3d worldSpaceForward = ship.getTransform().getShipToWorldRotation().transform((Vector3dc)TrackworkUtil.getForwardVec3d(axis, 1.0f), new Vector3d());
                Vec3 worldSpaceFutureOffset = VectorConversionsMCKt.toMinecraft((Vector3dc)worldSpaceForward.mul(0.1 * ship.getVelocity().dot((Vector3dc)worldSpaceForward), new Vector3d()));
                Vec3 worldSpaceHorizontalOffset = VectorConversionsMCKt.toMinecraft((Vector3dc)worldSpaceForward.mul((double)this.getPointHorizontalOffset(), new Vector3d()));
                ClipResult clipResult = this.clipAndResolve(ship, axis, worldSpaceStart.m_82549_(worldSpaceFutureOffset).m_82549_(worldSpaceHorizontalOffset), worldSpaceNormal);
                Vector3d forceVec = clipResult.trackTangent.mul((double)this.wheelRadius / 0.5, new Vector3d());
                if (forceVec.lengthSquared() == 0.0 && (b = this.f_58857_.m_8055_(BlockPos.m_274446_((Position)worldSpaceStart))).m_60819_().m_205070_(FluidTags.f_13131_)) {
                    forceVec = ship.getTransform().getShipToWorldRotation().transform(TrackworkUtil.getForwardVec3d(axis, 1.0f)).mul((double)this.wheelRadius / 0.5).mul(0.2);
                }
                double suspensionTravel = clipResult.suspensionLength.m_82556_() == 0.0 ? susScaled : clipResult.suspensionLength.m_82553_() - 0.5;
                Vector3d suspensionForce = VectorConversionsMCKt.toJOML((Vec3)worldSpaceNormal.m_82490_(susScaled - suspensionTravel)).negate();
                PhysicsTrackController controller = PhysicsTrackController.getOrCreate(ship);
                if (this.trackID == null) {
                    return;
                }
                PhysTrackData.PhysTrackUpdateData data = new PhysTrackData.PhysTrackUpdateData((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)worldSpaceStart), (Vector3dc)forceVec, (Vector3dc)VectorConversionsMCKt.toJOML((Vec3)worldSpaceNormal), (Vector3dc)suspensionForce, clipResult.groundShipId, clipResult.suspensionLength.m_82556_() != 0.0, trackRPM);
                this.suspensionScale = controller.updateTrackBlock(this.trackID, data);
                this.prevWheelTravel = this.wheelTravel;
                float newWheelTravel = (float)(suspensionTravel + restOffset);
                float wheelTravelDelta = newWheelTravel - this.wheelTravel;
                if (wheelTravelDelta > 0.01f) {
                    TrackPackets.getChannel().send(this.packetTarget(), (Object)new SuspensionWheelPacket(this.m_58899_(), this.wheelTravel));
                }
                this.wheelTravel = newWheelTravel;
                List hits = this.f_58857_.m_45976_(LivingEntity.class, new AABB(this.m_58899_()).m_82406_(0.25).m_82363_(0.0, -1.5, 0.0));
                Vec3 worldPos = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82512_((Vec3i)this.m_58899_()))));
                for (LivingEntity e : hits) {
                    SuspensionTrackBlockEntity.push((Entity)e, worldPos);
                    Vec3 relPos = e.m_20182_().m_82546_(worldPos);
                    float speed = org.joml.Math.abs((float)this.getSpeed());
                    if (speed > 1.0f) {
                        e.m_6469_(TrackDamageSources.runOver(this.f_58857_), speed / 8.0f * (float)((Integer)AllConfigs.server().kinetics.crushingDamage.get()).intValue());
                    }
                    if (!(e instanceof ServerPlayer)) continue;
                    ServerPlayer p = (ServerPlayer)e;
                    p.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)p));
                }
                BlockState state = this.m_58900_();
                if ((double)wheelTravelDelta < -0.3 && state.m_61138_(SuspensionTrackBlock.WHEEL_VARIANT) && state.m_61143_(SuspensionTrackBlock.WHEEL_VARIANT) != SuspensionTrackBlock.TrackVariant.blank) {
                    this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)TrackSounds.SUSPENSION_CREAK.get(), SoundSource.BLOCKS, org.joml.Math.clamp((float)0.0f, (float)2.0f, (float)(org.joml.Math.abs((float)(wheelTravelDelta * 3.0f * (this.getSpeed() / 256.0f))) * 0.5f)), org.joml.Math.lerp((float)1.0f, (float)0.3f, (float)(-wheelTravelDelta)) + 0.4f * this.random.nextFloat());
                }
            }
        }
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.assembled && !this.f_58857_.f_46443_ && this.ship.get() != null) {
            TrackPackets.getChannel().send(this.packetTarget(), (Object)new SuspensionWheelPacket(this.m_58899_(), this.wheelTravel));
        }
    }

    @NotNull
    private ClipResult clipAndResolve(ServerShip ship, Direction.Axis axis, Vec3 start, Vec3 dir) {
        BlockHitResult bResult = this.f_58857_.m_45547_(new ClipContext(start, start.m_82549_(dir), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        if (bResult.m_6662_() != HitResult.Type.BLOCK) {
            return new ClipResult((Vector3dc)new Vector3d(0.0), Vec3.f_82478_, null);
        }
        LoadedShip hitShip = VSGameUtilsKt.getShipObjectManagingPos((Level)this.f_58857_, (Vec3i)bResult.m_82425_());
        Long hitShipId = null;
        if (hitShip != null) {
            if (hitShip.equals(ship)) {
                return new ClipResult((Vector3dc)new Vector3d(0.0), Vec3.f_82478_, null);
            }
            hitShipId = hitShip.getId();
        }
        Vec3 worldSpacehitExact = bResult.m_82450_();
        Vec3 forceNormal = start.m_82546_(worldSpacehitExact);
        Vec3 worldSpaceAxis = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getTransform().getShipToWorldRotation().transform(TrackworkUtil.getAxisAsVec(axis)));
        return new ClipResult((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)worldSpaceAxis.m_82537_(forceNormal)).normalize(), forceNormal, hitShipId);
    }

    public void setHorizontalOffset(Vector3dc offset) {
        Direction.Axis axis = (Direction.Axis)this.m_58900_().m_61143_((Property)RotatedPillarKineticBlock.AXIS);
        double factor = offset.dot((Vector3dc)TrackworkUtil.getForwardVec3d(axis, 1.0f));
        this.horizontalOffset = org.joml.Math.clamp((float)-0.5f, (float)0.5f, (float)((float)org.joml.Math.round((double)(factor * 8.0)) / 8.0f));
        this.m_6596_();
    }

    @Override
    public float getPointDownwardOffset(float partialTicks) {
        return this.getWheelTravel(partialTicks);
    }

    @Override
    public float getPointHorizontalOffset() {
        return this.horizontalOffset;
    }

    @Override
    public boolean isBeltLarge() {
        return (double)this.wheelRadius > 0.75;
    }

    @Override
    public Vec3 getTrackPointSlope(float partialTicks) {
        return new Vec3(0.0, (double)(Mth.m_14179_((float)partialTicks, (float)((Float)this.nextPointVerticalOffset.getFirst()).floatValue(), (float)((Float)this.nextPointVerticalOffset.getSecond()).floatValue()) - this.getWheelTravel(partialTicks)), (double)(this.nextPointHorizontalOffset - this.horizontalOffset));
    }

    @Override
    @NotNull
    public ITrackPointProvider.PointType getTrackPointType() {
        return ITrackPointProvider.PointType.GROUND;
    }

    @Override
    public float getWheelRadius() {
        return this.wheelRadius;
    }

    public float getSpeed() {
        if (!this.assembled) {
            return 0.0f;
        }
        return org.joml.Math.clamp((float)(-((Integer)TrackworkConfigs.server().maxRPM.get()).intValue()), (float)((Integer)TrackworkConfigs.server().maxRPM.get()).intValue(), (float)super.getSpeed());
    }

    public static void push(Entity entity, Vec3 worldPos) {
        double d1;
        double d0;
        double d2;
        if (!entity.f_19794_ && (d2 = Mth.m_14005_((double)(d0 = entity.m_20185_() - worldPos.f_82479_), (double)(d1 = entity.m_20189_() - worldPos.f_82481_))) >= (double)0.01f) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.1f;
            d1 *= (double)0.1f;
            if (!entity.m_20160_()) {
                entity.m_5997_(d0, 0.0, d1);
            }
        }
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Assembled", this.assembled);
        if (this.trackID != null) {
            compound.m_128405_("trackBlockID", this.trackID.intValue());
        }
        compound.m_128350_("WheelTravel", this.wheelTravel);
        compound.m_128350_("horizontalOffset", this.horizontalOffset);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.assembled = compound.m_128471_("Assembled");
        if (this.trackID == null && compound.m_128441_("trackBlockID")) {
            this.trackID = compound.m_128451_("trackBlockID");
        }
        this.wheelTravel = compound.m_128457_("WheelTravel");
        if (compound.m_128441_("horizontalOffset")) {
            this.horizontalOffset = compound.m_128457_("horizontalOffset");
        }
        this.prevWheelTravel = this.wheelTravel;
        super.read(compound, clientPacket);
    }

    public float getWheelTravel() {
        return this.wheelTravel;
    }

    public float getWheelTravel(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevWheelTravel, (float)this.wheelTravel);
    }

    protected boolean isNoisy() {
        return false;
    }

    public void handlePacket(SuspensionWheelPacket p) {
        this.prevWheelTravel = this.wheelTravel;
        this.wheelTravel = p.wheelTravel;
    }

    private /* synthetic */ Runnable lambda$tick$2(Ship s, Vector3dc ground, Vector3dc reversedVel) {
        return () -> {
            float spd = org.joml.Math.abs((float)this.getSpeed());
            float pitch = Mth.m_14036_((float)(spd / 256.0f + 0.45f), (float)0.85f, (float)1.0f);
            if (spd < 8.0f) {
                return;
            }
            TrackSoundScapes.play(TrackAmbientGroups.TRACK_GROUND_AMBIENT, this.f_58858_, pitch * 0.5f);
            Vector3dc shipSpeed = SimpleWheelController.accumulatedVelocity(s.getTransform(), new PoseVel(s.getTransform().getPositionInWorld(), s.getTransform().getShipToWorldRotation(), s.getVelocity(), s.getOmega()), ground);
            float slip = (float)reversedVel.add(shipSpeed, new Vector3d()).length();
            pitch = Mth.m_14036_((float)(org.joml.Math.abs((float)slip) / 10.0f + 0.45f), (float)0.85f, (float)3.0f);
            TrackSoundScapes.play(TrackAmbientGroups.TRACK_GROUND_SLIP, this.f_58858_, pitch);
        };
    }

    public record ClipResult(Vector3dc trackTangent, Vec3 suspensionLength, @Nullable Long groundShipId) {
    }
}

