/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.blocks;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import edn.stratodonut.trackwork.TrackBlockEntityTypes;
import edn.stratodonut.trackwork.tracks.blocks.WheelBlockEntity;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class WheelBlock
extends HorizontalKineticBlock
implements IBE<WheelBlockEntity> {
    public static final Property<VisualVariant> VISUAL_VARIANT = EnumProperty.m_61587_((String)"variant", VisualVariant.class);
    @Nonnull
    private final Supplier<BlockEntityType<WheelBlockEntity>> wbet;

    public WheelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.wbet = TrackBlockEntityTypes.SIMPLE_WHEEL;
    }

    public WheelBlock(BlockBehaviour.Properties properties, Supplier<BlockEntityType<WheelBlockEntity>> wbet) {
        super(properties);
        this.wbet = wbet;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{VISUAL_VARIANT}));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(handIn);
        if (AllItems.WRENCH.isIn(heldItem) && state.m_61138_(VISUAL_VARIANT)) {
            VisualVariant old = (VisualVariant)((Object)state.m_61143_(VISUAL_VARIANT));
            switch (old) {
                case vdefault: {
                    world.m_46597_(pos, (BlockState)state.m_61124_(VISUAL_VARIANT, (Comparable)((Object)VisualVariant.no_spring)));
                    break;
                }
                default: {
                    world.m_46597_(pos, (BlockState)state.m_61124_(VISUAL_VARIANT, (Comparable)((Object)VisualVariant.vdefault)));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, handIn, hit);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction preferred = this.getPreferredHorizontalFacing(context);
        if (context.m_43723_() != null && context.m_43723_().m_6144_() || preferred == null) {
            return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_FACING, (Comparable)context.m_8125_());
        }
        return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_FACING, (Comparable)preferred);
    }

    public static boolean isValid(Direction facing) {
        return !facing.m_122434_().m_122478_();
    }

    @NotNull
    public PushReaction getPistonPushReaction(@NotNull BlockState state) {
        return PushReaction.BLOCK;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == state.m_61143_(HORIZONTAL_FACING);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    public Class<WheelBlockEntity> getBlockEntityClass() {
        return WheelBlockEntity.class;
    }

    public BlockEntityType<WheelBlockEntity> getBlockEntityType() {
        return this.wbet.get();
    }

    public static enum VisualVariant implements StringRepresentable
    {
        vdefault,
        no_spring;


        @NotNull
        public String m_7912_() {
            return this.name();
        }
    }
}

