/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.blocks;

import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.infrastructure.config.AllConfigs;
import edn.stratodonut.trackwork.TrackAmbientGroups;
import edn.stratodonut.trackwork.TrackDamageSources;
import edn.stratodonut.trackwork.TrackPackets;
import edn.stratodonut.trackwork.TrackSounds;
import edn.stratodonut.trackwork.TrackworkConfigs;
import edn.stratodonut.trackwork.TrackworkUtil;
import edn.stratodonut.trackwork.sounds.TrackSoundScapes;
import edn.stratodonut.trackwork.tracks.blocks.SuspensionTrackBlockEntity;
import edn.stratodonut.trackwork.tracks.blocks.WheelBlock;
import edn.stratodonut.trackwork.tracks.data.SimpleWheelData;
import edn.stratodonut.trackwork.tracks.forces.SimpleWheelController;
import edn.stratodonut.trackwork.tracks.network.SimpleWheelPacket;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.physics_api.PoseVel;

public class WheelBlockEntity
extends KineticBlockEntity {
    private float wheelRadius = 1.0f;
    private float suspensionTravel = 1.5f;
    private double suspensionScale = 1.0;
    private float steeringValue = 0.0f;
    private float linkedSteeringValue = 0.0f;
    protected final Random random = new Random();
    private float wheelTravel;
    private float prevWheelTravel;
    private float prevFreeWheelAngle;
    private float horizontalOffset;
    private float axialOffset;
    @NotNull
    protected final Supplier<Ship> ship = () -> VSGameUtilsKt.getShipObjectManagingPos((Level)this.f_58857_, (Vec3i)pos);
    public boolean isFreespin = true;
    public boolean assembled;
    public boolean assembleNextTick = true;

    public WheelBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(10);
    }

    public static WheelBlockEntity med(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        WheelBlockEntity be = new WheelBlockEntity(type, pos, state);
        be.wheelRadius = 0.75f;
        be.suspensionTravel = 1.5f;
        return be;
    }

    public void remove() {
        ServerShip ship;
        super.remove();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.assembled && (ship = (ServerShip)this.ship.get()) != null) {
            SimpleWheelController controller = SimpleWheelController.getOrCreate(ship);
            controller.removeTrackBlock(this.m_58899_());
        }
    }

    private void assemble() {
        ServerShip ship;
        if (!WheelBlock.isValid((Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING))) {
            return;
        }
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (ship = (ServerShip)this.ship.get()) != null && Math.abs((double)(1.0 - ship.getTransform().getShipToWorldScaling().length())) > 0.01) {
            this.assembled = true;
            SimpleWheelController controller = SimpleWheelController.getOrCreate(ship);
            SimpleWheelData.SimpleWheelCreateData data = new SimpleWheelData.SimpleWheelCreateData((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82512_((Vec3i)this.m_58899_())));
            controller.addTrackBlock(this.m_58899_(), data);
            this.sendData();
        }
    }

    public void tick() {
        KineticBlock ke;
        Block s;
        super.tick();
        if (this.ship.get() != null && this.assembleNextTick && !this.assembled && this.f_58857_ != null) {
            this.assemble();
            this.assembleNextTick = false;
            return;
        }
        if (this.f_58857_.f_46443_ && this.ship.get() != null) {
            Vector3d pos = VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82539_((Vec3i)this.m_58899_()));
            Vector3d ground = VSGameUtilsKt.getWorldCoordinates((Level)this.f_58857_, (BlockPos)this.m_58899_(), (Vector3d)pos.sub((Vector3dc)SimpleWheelController.UP.mul((double)this.wheelTravel * 1.2, new Vector3d())));
            BlockPos blockpos = BlockPos.m_274446_((Position)VectorConversionsMCKt.toMinecraft((Vector3dc)ground));
            BlockState blockstate = this.f_58857_.m_8055_(blockpos);
            if (blockstate.m_280296_()) {
                s = this.ship.get();
                Vector3d reversedWheelVel = s.getShipTransform().getShipToWorldRotation().transform(TrackworkUtil.getForwardVec3d(((Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_122434_(), this.getWheelSpeed()));
                if (Math.abs((float)this.getWheelSpeed()) > 64.0f && blockstate.m_60799_() != RenderShape.INVISIBLE) {
                    this.f_58857_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(blockpos), pos.x + (this.random.nextDouble() - 0.5), pos.y + 0.25, pos.z + (this.random.nextDouble() - 0.5) * (double)this.wheelRadius, reversedWheelVel.x() * -1.0, 10.5, reversedWheelVel.z() * -1.0);
                }
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this.lambda$tick$2((Ship)s, (Vector3dc)ground, (Vector3dc)reversedWheelVel));
            }
        }
        Direction dir = (Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
        BlockPos innerBlock = this.m_58899_().m_121945_(dir);
        BlockState innerState = this.f_58857_.m_8055_(innerBlock);
        s = innerState.m_60734_();
        if (s instanceof KineticBlock && (ke = (KineticBlock)s).hasShaftTowards((LevelReader)this.f_58857_, this.m_58899_(), innerState, dir.m_122424_())) {
            this.isFreespin = false;
        } else {
            this.isFreespin = true;
            if (this.f_58857_.f_46443_) {
                this.prevFreeWheelAngle += this.getWheelSpeed() * 3.0f / 10.0f;
            }
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.assembled) {
            Vec3 start = Vec3.m_82512_((Vec3i)this.m_58899_());
            Direction.Axis axis = dir.m_122434_();
            double restOffset = this.wheelRadius - 0.5f;
            float trackRPM = this.getDrivenSpeed();
            double susScaled = (double)this.suspensionTravel * this.suspensionScale;
            ServerShip ship = (ServerShip)this.ship.get();
            if (ship != null) {
                Vec3 worldSpaceNormal = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getTransform().getShipToWorldRotation().transform((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)TrackworkUtil.getActionNormal(axis)), new Vector3d()).mul(susScaled + 0.5));
                Vec3 worldSpaceStart = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML((Vec3)start.m_82520_(0.0, -restOffset, 0.0))));
                int bestSignal = this.f_58857_.m_277086_(this.m_58899_());
                float oldSteeringValue = this.steeringValue;
                this.steeringValue = (float)bestSignal / 15.0f * (float)(dir.m_122421_() == Direction.AxisDirection.POSITIVE ? 1 : -1);
                float deltaSteeringValue = oldSteeringValue - this.steeringValue;
                this.onLinkedWheel(wbe -> wbe.setLinkedSteeringValue(this.steeringValue));
                Vector3d worldSpaceForward = ship.getTransform().getShipToWorldRotation().transform((Vector3dc)this.getActionVec3d(axis, 1.0f), new Vector3d());
                float horizontalOffset = this.getPointHorizontalOffset();
                float axialOffset = this.getPointAxialOffset();
                Vec3 worldSpaceFutureOffset = VectorConversionsMCKt.toMinecraft((Vector3dc)worldSpaceForward.normalize(Math.clamp((double)(-0.4 - (double)horizontalOffset), (double)(0.4 - (double)horizontalOffset), (double)(0.05 * ship.getVelocity().dot((Vector3dc)worldSpaceForward))), new Vector3d()));
                Vec3 worldSpaceOffset = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getTransform().getShipToWorldRotation().transform((Vector3dc)TrackworkUtil.getForwardVec3d(axis, 1.0f).mul((double)horizontalOffset).add((Vector3dc)TrackworkUtil.getAxisAsVec(axis).mul((double)axialOffset)), new Vector3d()));
                ClipResult clipResult = this.clipAndResolve(ship, axis, worldSpaceStart.m_82549_(worldSpaceOffset).m_82549_(worldSpaceFutureOffset), worldSpaceNormal);
                Vector3d forceVec = clipResult.trackTangent.mul((double)this.wheelRadius / 0.5, new Vector3d());
                double suspensionTravel = clipResult.suspensionLength.m_82556_() == 0.0 ? susScaled : clipResult.suspensionLength.m_82553_() - 0.5;
                Vector3d suspensionForce = VectorConversionsMCKt.toJOML((Vec3)worldSpaceNormal.m_82490_(susScaled - suspensionTravel)).negate();
                boolean isOnGround = clipResult.suspensionLength.m_82556_() != 0.0;
                SimpleWheelController controller = SimpleWheelController.getOrCreate(ship);
                SimpleWheelData.SimpleWheelUpdateData data = new SimpleWheelData.SimpleWheelUpdateData((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)worldSpaceStart.m_82549_(worldSpaceOffset)), (Vector3dc)forceVec, (Vector3dc)VectorConversionsMCKt.toJOML((Vec3)worldSpaceNormal), (Vector3dc)suspensionForce, this.isFreespin, clipResult.groundShipId, isOnGround, trackRPM);
                this.suspensionScale = controller.updateTrackBlock(this.m_58899_(), data);
                float newWheelTravel = (float)(suspensionTravel + restOffset);
                float delta = newWheelTravel - this.wheelTravel;
                this.prevWheelTravel = this.wheelTravel;
                this.wheelTravel = newWheelTravel;
                if (Math.abs((float)delta) > 0.01f || Math.abs((float)deltaSteeringValue) > 0.05f) {
                    this.syncToClient();
                }
                List hits = this.f_58857_.m_45976_(LivingEntity.class, new AABB(this.m_58899_()).m_82406_(0.25).m_82363_(0.0, -1.5, 0.0));
                Vec3 worldPos = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82512_((Vec3i)this.m_58899_()))));
                for (LivingEntity e : hits) {
                    SuspensionTrackBlockEntity.push((Entity)e, worldPos);
                    Vec3 relPos = e.m_20182_().m_82546_(worldPos);
                    float speed = Math.abs((float)trackRPM);
                    if (speed > 1.0f) {
                        e.m_6469_(TrackDamageSources.runOver(this.f_58857_), speed / 16.0f * (float)((Integer)AllConfigs.server().kinetics.crushingDamage.get()).intValue());
                    }
                    if (!(e instanceof ServerPlayer)) continue;
                    ServerPlayer p = (ServerPlayer)e;
                    p.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)p));
                }
                if ((double)delta < -0.3) {
                    this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)TrackSounds.SUSPENSION_CREAK.get(), SoundSource.BLOCKS, Math.clamp((float)0.0f, (float)2.0f, (float)(Math.abs((float)(delta * 3.0f * (this.getSpeed() / 256.0f))) * 0.5f)), Math.lerp((float)1.2f, (float)0.8f, (float)(-delta)) + 0.4f * this.random.nextFloat());
                }
                if (isOnGround && (double)this.random.nextFloat() < (double)Math.abs((float)(this.getSpeed() / 256.0f)) * 0.1) {
                    this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)TrackSounds.WHEEL_ROCKTOSS.get(), SoundSource.BLOCKS, Math.max((float)0.2f, (float)(Math.abs((float)(this.getSpeed() / 256.0f)) * 0.5f)), 0.8f + 0.4f * this.random.nextFloat());
                }
            }
        }
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.assembled && !this.f_58857_.f_46443_ && this.ship.get() != null) {
            this.syncToClient();
        }
    }

    @NotNull
    private ClipResult clipAndResolve(ServerShip ship, Direction.Axis axis, Vec3 start, Vec3 dir) {
        BlockHitResult bResult = this.f_58857_.m_45547_(new ClipContext(start, start.m_82549_(dir), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        if (bResult.m_82436_()) {
            // empty if block
        }
        if (bResult.m_6662_() != HitResult.Type.BLOCK) {
            return new ClipResult((Vector3dc)new Vector3d(0.0), Vec3.f_82478_, null);
        }
        LoadedShip hitShip = VSGameUtilsKt.getShipObjectManagingPos((Level)this.f_58857_, (Vec3i)bResult.m_82425_());
        Long hitShipId = null;
        if (hitShip != null) {
            if (hitShip.equals(ship)) {
                return new ClipResult((Vector3dc)new Vector3d(0.0), Vec3.f_82478_, null);
            }
            hitShipId = hitShip.getId();
        }
        Vec3 worldSpacehitExact = bResult.m_82450_();
        Vec3 forceNormal = start.m_82546_(worldSpacehitExact);
        Vec3 worldSpaceAxis = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getTransform().getShipToWorldRotation().transform(TrackworkUtil.getAxisAsVec(axis).rotateAxis((double)(this.getSteeringValue() * Math.toRadians((float)30.0f)), 0.0, 1.0, 0.0)));
        return new ClipResult((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)worldSpaceAxis.m_82537_(forceNormal)).normalize(), forceNormal, hitShipId);
    }

    protected void onLinkedWheel(Consumer<WheelBlockEntity> action) {
        Direction dir = (Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
        for (int i = 1; i <= (Integer)TrackworkConfigs.server().wheelPairDist.get() + 1; ++i) {
            BlockPos bpos = this.m_58899_().m_5484_(dir, i);
            BlockEntity be = this.f_58857_.m_7702_(bpos);
            if (!(be instanceof WheelBlockEntity)) continue;
            WheelBlockEntity wbe = (WheelBlockEntity)be;
            action.accept(wbe);
            break;
        }
    }

    public void setLinkedSteeringValue(float v) {
        float old = this.getSteeringValue();
        this.linkedSteeringValue = v;
        float delta = this.getSteeringValue() - old;
        if (Math.abs((float)delta) > 0.05f) {
            this.syncToClient();
        }
    }

    protected void syncToClient() {
        if (!this.f_58857_.f_46443_) {
            TrackPackets.getChannel().send(this.packetTarget(), (Object)new SimpleWheelPacket(this.m_58899_(), this.wheelTravel, this.getSteeringValue(), this.horizontalOffset));
        }
    }

    public Vector3d getActionVec3d(Direction.Axis axis, float length) {
        return TrackworkUtil.getForwardVec3d(axis, length).rotateAxis((double)(this.getSteeringValue() * Math.toRadians((float)30.0f)), 0.0, 1.0, 0.0);
    }

    public float getFreeWheelAngle(float partialTick) {
        return (this.prevFreeWheelAngle + this.getWheelSpeed() * partialTick * 3.0f / 10.0f) % 360.0f;
    }

    public float getWheelSpeed() {
        Ship s;
        if (this.isFreespin && (s = this.ship.get()) != null) {
            Vector3d vel = s.getVelocity().add((Vector3dc)s.getOmega().cross((Vector3dc)s.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82539_((Vec3i)this.m_58899_()))).sub(s.getTransform().getPositionInWorld()), new Vector3d()), new Vector3d());
            Direction.Axis axis = ((Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_122434_();
            int sign = axis == Direction.Axis.X ? 1 : -1;
            return (float)sign * (float)TrackworkUtil.roundTowardZero(vel.dot((Vector3dc)s.getShipToWorld().transformDirection(this.getActionVec3d(axis, 1.0f))) * (double)9.3f * 1.0 / (double)this.wheelRadius);
        }
        return this.getDrivenSpeed();
    }

    public float getDrivenSpeed() {
        return this.getSpeed() * 1.0f / this.wheelRadius;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Assembled", this.assembled);
        compound.m_128350_("WheelTravel", this.wheelTravel);
        compound.m_128350_("HorizontalOffset", this.horizontalOffset);
        compound.m_128350_("AxialOffset", this.axialOffset);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.assembled = compound.m_128471_("Assembled");
        this.wheelTravel = compound.m_128457_("WheelTravel");
        this.horizontalOffset = compound.m_128457_("HorizontalOffset");
        this.axialOffset = compound.m_128457_("AxialOffset");
        this.prevWheelTravel = this.wheelTravel;
        super.read(compound, clientPacket);
    }

    public float getWheelRadius() {
        return this.wheelRadius;
    }

    public float getWheelTravel(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevWheelTravel, (float)this.wheelTravel);
    }

    public void setSteeringValue(float value) {
        this.steeringValue = value;
    }

    public float getSteeringValue() {
        return Math.abs((float)this.linkedSteeringValue) > Math.abs((float)this.steeringValue) ? this.linkedSteeringValue : this.steeringValue;
    }

    public void setOffset(Vector3dc offset, Direction face) {
        Direction.Axis axis = ((Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_122434_();
        if (face.m_122434_() == axis) {
            this.setHorizontalOffset(offset, axis);
        } else {
            this.setAxialOffset(offset, axis);
        }
    }

    public void setAxialOffset(Vector3dc offset, Direction.Axis axis) {
        double factor = offset.dot((Vector3dc)TrackworkUtil.getAxisAsVec(axis));
        this.axialOffset = Math.clamp((float)-0.4f, (float)0.4f, (float)((float)Math.round((double)(factor * 8.0)) / 8.0f));
        this.onLinkedWheel(wbe -> {
            wbe.axialOffset = -this.axialOffset;
            wbe.syncToClient();
        });
        this.syncToClient();
    }

    public float getPointAxialOffset() {
        return this.axialOffset;
    }

    public void setHorizontalOffset(Vector3dc offset, Direction.Axis axis) {
        double factor = offset.dot((Vector3dc)this.getActionVec3d(axis, 1.0f));
        this.horizontalOffset = Math.clamp((float)-0.4f, (float)0.4f, (float)((float)Math.round((double)(factor * 8.0)) / 8.0f));
        this.onLinkedWheel(wbe -> {
            wbe.horizontalOffset = this.horizontalOffset;
            wbe.syncToClient();
        });
        this.syncToClient();
    }

    public float getPointHorizontalOffset() {
        return this.horizontalOffset;
    }

    public float calculateStressApplied() {
        float impact;
        if (this.f_58857_.f_46443_ || !((Boolean)TrackworkConfigs.server().enableStress.get()).booleanValue() || !this.assembled) {
            return super.calculateStressApplied();
        }
        Ship ship = this.ship.get();
        if (ship == null) {
            return super.calculateStressApplied();
        }
        double mass = ((ServerShip)ship).getInertiaData().getMass();
        this.lastStressApplied = impact = this.calculateStressApplied((float)mass);
        return impact;
    }

    public float calculateStressApplied(float mass) {
        double impact = (double)(mass / 1000.0f) * (Double)TrackworkConfigs.server().stressMult.get() * (double)(2.0f * this.wheelRadius);
        if (impact < 0.0) {
            impact = 0.0;
        }
        return (float)impact;
    }

    protected boolean isNoisy() {
        return false;
    }

    public void handlePacket(SimpleWheelPacket p) {
        this.prevWheelTravel = this.wheelTravel;
        this.wheelTravel = p.wheelTravel;
        this.steeringValue = p.steeringValue;
        this.horizontalOffset = p.horizontalOffset;
    }

    private /* synthetic */ Runnable lambda$tick$2(Ship s, Vector3dc ground, Vector3dc reversedWheelVel) {
        return () -> {
            float wheelSpeed = this.getWheelSpeed();
            float pitch = Mth.m_14036_((float)(Math.abs((float)wheelSpeed) / 256.0f + 0.45f), (float)0.85f, (float)3.0f);
            if (Math.abs((float)wheelSpeed) < 8.0f) {
                return;
            }
            TrackSoundScapes.play(TrackAmbientGroups.WHEEL_GROUND_AMBIENT, this.f_58858_, pitch);
            Vector3dc shipSpeed = SimpleWheelController.accumulatedVelocity(s.getTransform(), new PoseVel(s.getTransform().getPositionInWorld(), s.getTransform().getShipToWorldRotation(), s.getVelocity(), s.getOmega()), ground);
            float slip = (float)reversedWheelVel.negate(new Vector3d()).sub(shipSpeed).length();
            pitch = Mth.m_14036_((float)(Math.abs((float)slip) / 10.0f + 0.45f), (float)0.85f, (float)3.0f);
            TrackSoundScapes.play(TrackAmbientGroups.WHEEL_GROUND_SLIP, this.f_58858_, pitch);
        };
    }

    public record ClipResult(Vector3dc trackTangent, Vec3 suspensionLength, @Nullable Long groundShipId) {
    }
}

