/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.forces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.mojang.datafixers.util.Pair;
import edn.stratodonut.trackwork.TrackworkMod;
import edn.stratodonut.trackwork.tracks.data.PhysEntityTrackData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.jvm.functions.Function1;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class PhysEntityTrackController
implements ShipForcesInducer {
    @JsonIgnore
    public static final double RPM_TO_RADS = 0.10471975512;
    @JsonIgnore
    public static final Vector3dc UP = new Vector3d(0.0, 1.0, 0.0);
    public final HashMap<Integer, PhysEntityTrackData> trackData = new HashMap();
    @JsonIgnore
    private final ConcurrentLinkedQueue<Pair<Integer, PhysEntityTrackData.CreateData>> createdTrackData = new ConcurrentLinkedQueue();
    @JsonIgnore
    private final ConcurrentHashMap<Integer, PhysEntityTrackData.UpdateData> trackUpdateData = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<Integer> removedTracks = new ConcurrentLinkedQueue();
    private int nextBearingID = 0;

    public static PhysEntityTrackController getOrCreate(ServerShip ship) {
        if (ship.getAttachment(PhysEntityTrackController.class) == null) {
            ship.saveAttachment(PhysEntityTrackController.class, (Object)new PhysEntityTrackController());
        }
        return (PhysEntityTrackController)ship.getAttachment(PhysEntityTrackController.class);
    }

    public void applyForces(@NotNull PhysShip physShip) {
    }

    public void applyForcesAndLookupPhysShips(@NotNull PhysShip physShip, @NotNull Function1<? super Long, ? extends PhysShip> lookupPhysShip) {
        while (!this.createdTrackData.isEmpty()) {
            Pair createData = (Pair)this.createdTrackData.remove();
            if (createData.getFirst() != null && createData.getSecond() != null) {
                this.trackData.put((Integer)createData.getFirst(), PhysEntityTrackData.from((PhysEntityTrackData.CreateData)createData.getSecond()));
                continue;
            }
            TrackworkMod.warn("Tried to create a PE track of ID {} with no data!", createData.getFirst());
        }
        this.trackUpdateData.forEach((id, data) -> {
            PhysEntityTrackData old = this.trackData.get(id);
            if (old != null) {
                this.trackData.put((Integer)id, old.updateWith((PhysEntityTrackData.UpdateData)data));
            }
        });
        this.trackUpdateData.clear();
        while (!this.removedTracks.isEmpty()) {
            Integer removeId = (Integer)this.removedTracks.remove();
            this.trackData.remove(removeId);
        }
        if (this.trackData.isEmpty()) {
            return;
        }
        Vector3d netLinearForce = new Vector3d(0.0);
        double coefficientOfPower = Math.min((double)1.0, (double)(4.0 / (double)this.trackData.size()));
        this.trackData.forEach((id, data) -> {
            PhysShip wheel = (PhysShip)lookupPhysShip.invoke((Object)data.shiptraptionID);
            Pair<Vector3dc, Vector3dc> forces = this.computeForce((PhysEntityTrackData)data, (PhysShipImpl)physShip, (PhysShipImpl)wheel, coefficientOfPower);
            if (forces != null) {
                netLinearForce.add((Vector3dc)forces.getFirst());
                if (((Vector3dc)forces.getSecond()).isFinite()) {
                    wheel.applyInvariantTorque((Vector3dc)forces.getSecond());
                }
            }
        });
        if (netLinearForce.isFinite()) {
            physShip.applyInvariantForce((Vector3dc)netLinearForce);
        }
    }

    private Pair<@NotNull Vector3dc, @NotNull Vector3dc> computeForce(PhysEntityTrackData data, PhysShipImpl ship, PhysShipImpl wheel, double coefficientOfPower) {
        if (wheel != null) {
            double m = ship.getInertia().getShipMass();
            ShipTransform shipTransform = ship.getTransform();
            Vector3d trackPos = shipTransform.getShipToWorld().transformPosition(data.trackPos, new Vector3d());
            Vector3d springVec = wheel.getTransform().getPositionInWorld().sub((Vector3dc)trackPos, new Vector3d());
            double springDist = Math.clamp((double)0.0, (double)1.5, (double)(1.5 - springVec.length()));
            assert (data.springConstraint != null);
            Vector3d springForce = data.springConstraint.getLocalPos0().mul(m * 8.0 * springDist, new Vector3d());
            double distDelta = Math.clamp((double)-5.0, (double)5.0, (double)(springDist - data.previousSpringDist));
            double damperForce = distDelta / 20.0 * m * 3000.0;
            springForce = springForce.add((Vector3dc)data.springConstraint.getLocalPos0().mul(damperForce, new Vector3d()), new Vector3d());
            data.previousSpringDist = springDist;
            Vector3d wheelAxis = shipTransform.getShipToWorldRotation().transform(data.wheelAxis, new Vector3d());
            double wheelSpeed = wheel.getPoseVel().getOmega().dot((Vector3dc)wheelAxis);
            double slip = Math.clamp((double)-3.0, (double)3.0, (double)(-data.trackRPM - wheelSpeed));
            Vector3d driveTorque = wheelAxis.mul(-slip * m * 0.4 * coefficientOfPower, new Vector3d());
            return new Pair((Object)new Vector3d(0.0), (Object)driveTorque);
        }
        return null;
    }

    public final int addTrackBlock(PhysEntityTrackData.CreateData data) {
        this.createdTrackData.add((Pair<Integer, PhysEntityTrackData.CreateData>)new Pair((Object)(++this.nextBearingID), (Object)data));
        return this.nextBearingID;
    }

    public final void updateTrackBlock(Integer id, PhysEntityTrackData.UpdateData data) {
        this.trackUpdateData.put(id, data);
    }

    public final void removeTrackBlock(ServerLevel level, int id) {
        PhysEntityTrackData data = this.trackData.get(id);
        if (data != null) {
            VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).removeConstraint(data.springId.intValue());
            VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).removeConstraint(data.axleId.intValue());
        }
        this.removedTracks.add(id);
    }

    public final void resetController() {
        for (int i = 0; i < this.nextBearingID; ++i) {
            this.removedTracks.add(i);
        }
        this.nextBearingID = 0;
    }

    public static <T> boolean areQueuesEqual(Queue<T> left, Queue<T> right) {
        return Arrays.equals(left.toArray(), right.toArray());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PhysEntityTrackController)) {
            return false;
        }
        PhysEntityTrackController otherController = (PhysEntityTrackController)other;
        return Objects.equals(this.trackData, otherController.trackData) && Objects.equals(this.trackUpdateData, otherController.trackUpdateData) && PhysEntityTrackController.areQueuesEqual(this.createdTrackData, otherController.createdTrackData) && PhysEntityTrackController.areQueuesEqual(this.removedTracks, otherController.removedTracks) && this.nextBearingID == otherController.nextBearingID;
    }
}

