/*
 * Decompiled with CFR 0.152.
 */
package lol.hub.autosort;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public final class Plugin
extends JavaPlugin
implements Listener {
    private static final Path configActives = Path.of("plugins", "autosort", "active.txt");
    private final Set<UUID> actives = ConcurrentHashMap.newKeySet();
    private final Map<Material, Integer> materialOrder = new HashMap<Material, Integer>();
    private final Set<InventoryType> inventories = Set.of(InventoryType.CHEST, InventoryType.BARREL, InventoryType.ENDER_CHEST, InventoryType.SHULKER_BOX);
    private final Comparator<Object> comparator = Comparator.comparing(itemStack -> ((ItemStack)itemStack).getType().getKey().getNamespace()).thenComparing(itemStack -> this.materialOrder.getOrDefault(((ItemStack)itemStack).getType(), 0)).thenComparing(itemStack -> ((ItemStack)itemStack).getType().getKey().getKey()).thenComparing(itemStack -> ((ItemStack)itemStack).getItemMeta().getAsString()).thenComparing(itemStack -> ((ItemStack)itemStack).getAmount());
    private final CommandExecutor toggle = (sender, command, label, args) -> {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command is not available for non-players.");
            return true;
        }
        Player player = (Player)sender;
        UUID uuid = player.getUniqueId();
        TextComponent message = Component.text((String)"Sorting ");
        if (this.actives.contains(uuid)) {
            this.actives.remove(uuid);
            message = (TextComponent)message.append(Component.text((String)"disabled").color((TextColor)NamedTextColor.RED));
        } else {
            this.actives.add(uuid);
            message = (TextComponent)((TextComponent)message.append(Component.text((String)"enabled").color((TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)(" for: " + this.inventories.stream().map(InventoryType::defaultTitle).map(comp -> PlainTextComponentSerializer.plainText().serialize(comp)).sorted().collect(Collectors.joining(", ")))));
        }
        player.sendMessage((Component)message);
        this.saveActives();
        return true;
    };

    public void onEnable() {
        int n = 0;
        for (Material material : Registry.MATERIAL) {
            this.materialOrder.put(material, n++);
        }
        PluginCommand cmd = this.getCommand("autosort");
        cmd.setExecutor(this.toggle);
        cmd.setTabCompleter((sender, command, label, args) -> Collections.emptyList());
        this.loadActives();
        this.getServer().getPluginManager().registerEvents((Listener)this, (org.bukkit.plugin.Plugin)this);
    }

    public void onDisable() {
        this.actives.clear();
        this.materialOrder.clear();
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryOpen(InventoryOpenEvent ev) {
        this.sort(ev.getInventory(), ev.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent ev) {
        this.sort(ev.getInventory(), ev.getPlayer());
    }

    private void sort(Inventory inventory, HumanEntity player) {
        if (!this.inventories.contains(inventory.getType())) {
            return;
        }
        if (!this.actives.contains(player.getUniqueId())) {
            return;
        }
        boolean hasViewers = inventory.getViewers().stream().anyMatch(viewer -> !viewer.getUniqueId().equals(player.getUniqueId()));
        if (hasViewers) {
            return;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(Arrays.stream(inventory.getContents()).filter(Objects::nonNull).filter(itemStack -> !itemStack.isEmpty()).toList());
        items.sort(this.comparator);
        inventory.clear();
        for (ItemStack item : items) {
            inventory.addItem(new ItemStack[]{item});
        }
    }

    private void loadActives() {
        try {
            if (configActives.toFile().exists()) {
                List<String> lines = Files.readAllLines(configActives);
                for (String line : lines) {
                    if (line.isBlank()) continue;
                    this.actives.add(UUID.fromString(line));
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().warning(ex.toString());
        }
    }

    private void saveActives() {
        configActives.getParent().toFile().mkdirs();
        try {
            Files.writeString(configActives, (CharSequence)this.actives.stream().map(UUID::toString).collect(Collectors.joining(System.lineSeparator())), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception ex) {
            this.getLogger().warning(ex.toString());
        }
    }
}

