/*
 * Decompiled with CFR 0.152.
 */
package dev.codedsakura.blossom.homes;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import dev.codedsakura.blossom.homes.BlossomHomesConfig;
import dev.codedsakura.blossom.homes.Home;
import dev.codedsakura.blossom.homes.HomeController;
import dev.codedsakura.blossom.lib.BlossomLib;
import dev.codedsakura.blossom.lib.config.ConfigManager;
import dev.codedsakura.blossom.lib.permissions.Permissions;
import dev.codedsakura.blossom.lib.teleport.TeleportConfig;
import dev.codedsakura.blossom.lib.teleport.TeleportUtils;
import dev.codedsakura.blossom.lib.text.CommandTextBuilder;
import dev.codedsakura.blossom.lib.text.JoiningCollector;
import dev.codedsakura.blossom.lib.text.TextUtils;
import dev.codedsakura.blossom.lib.utils.CustomLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2270;
import net.minecraft.class_2277;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5454;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.core.Logger;

public class BlossomHomes
implements ModInitializer {
    static BlossomHomesConfig CONFIG = (BlossomHomesConfig)ConfigManager.register(BlossomHomesConfig.class, (String)"BlossomHomes.json", newConfig -> {
        CONFIG = newConfig;
    });
    public static final Logger LOGGER = CustomLogger.createLogger((String)"BlossomHomes");
    static HomeController homeController;

    public void onInitialize() {
        homeController = new HomeController();
        BlossomLib.addCommand((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"home").requires(Permissions.require((String)"blossom.home", (boolean)true))).executes(this::runHomeDefault)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)homeController).executes(this::runHomeNamed))));
        RequiredArgumentBuilder addHomeNamePosDim = (RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(this::addHomeNamed)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"position", (ArgumentType)class_2277.method_9735((boolean)true)).requires(Permissions.require((String)"blossom.home.set.pos", (boolean)false))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"rotation", (ArgumentType)class_2270.method_9717()).executes(this::addHomePosRot)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).requires(Permissions.require((String)"blossom.home.set.dim", (boolean)false))).executes(this::addHomeDimension))));
        BlossomLib.addCommand((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sethome").requires(Permissions.require((String)"blossom.home.set", (boolean)true))).executes(this::addHomeDefault)).then((ArgumentBuilder)addHomeNamePosDim)));
        BlossomLib.addCommand((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delhome").requires(Permissions.require((String)"blossom.home.remove", (boolean)true))).executes(this::removeHomeDefault)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)homeController).executes(this::removeHomeNamed))));
        BlossomLib.addCommand((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"listhomes").requires(Permissions.require((String)"blossom.home.list", (boolean)true))).executes(this::listHomes)));
        BlossomLib.addCommand((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"homes").requires(Permissions.require((String)"blossom.homes.list", (boolean)true))).executes(this::listHomes)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(Permissions.require((String)"blossom.homes.list", (boolean)true))).executes(this::listHomes))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(Permissions.require((String)"blossom.homes.set", (boolean)true))).executes(this::addHomeDefault)).then((ArgumentBuilder)addHomeNamePosDim))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(Permissions.require((String)"blossom.homes.add", (boolean)false))).executes(this::addHomeDefault)).then((ArgumentBuilder)addHomeNamePosDim))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(Permissions.require((String)"blossom.homes.remove", (boolean)false))).executes(this::removeHomeDefault)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)homeController).executes(this::removeHomeNamed)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delete").requires(Permissions.require((String)"blossom.homes.delete", (boolean)true))).executes(this::removeHomeDefault)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)homeController).executes(this::removeHomeNamed)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set-max").requires(Permissions.require((String)"blossom.homes.set-max", (int)2))).then(class_2170.method_9244((String)"new-max", (ArgumentType)IntegerArgumentType.integer((int)0)).then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(this::setMax))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"load-legacy").requires(Permissions.require((String)"blossom.homes.load-legacy", (int)4))).executes(this::loadLegacyDefault)).then(class_2170.method_9244((String)"overwrite", (ArgumentType)BoolArgumentType.bool()).executes(this::loadLegacyArgument)))));
    }

    private int listHomes(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        LOGGER.trace("home list {}", (Object)player);
        List<Home> homes = homeController.findPlayerHomes(player);
        if (homes.isEmpty()) {
            TextUtils.send(ctx, (String)"blossom.homes.list.empty", (Object[])new Object[]{homeController.getMaxHomes(player)});
            return 1;
        }
        class_5250 result = (class_5250)homes.stream().map(home -> TextUtils.translation((String)"blossom.homes.list.item.before", (Object[])new Object[0]).method_10852((class_2561)TextUtils.translation((String)"blossom.homes.list.item", (Object[])new Object[]{new CommandTextBuilder(home.name).setClickSuggest().setCommandRun("/home " + home.name).setHoverShowRun().setDescription((class_2561)TextUtils.translation((String)"blossom.homes.list.item.description", (Object[])home.toArgs()))})).method_10852((class_2561)TextUtils.translation((String)"blossom.homes.list.item.after", (Object[])new Object[0]))).collect(JoiningCollector.collector(class_5250::method_10852, (Object)class_2561.method_43470((String)"\n")));
        ((class_2168)ctx.getSource()).method_9226(() -> TextUtils.translation((String)"blossom.homes.list.header", (Object[])new Object[]{homes.size(), homeController.getMaxHomes(player)}).method_10852((class_2561)result), false);
        return 1;
    }

    private int runHome(CommandContext<class_2168> ctx, String homeName) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        Home home = homeController.findHome(player, homeName);
        LOGGER.trace("home player {} to {}", (Object)player, (Object)home);
        if (home == null) {
            if (!homeName.equals(BlossomHomes.CONFIG.defaultHome) || !BlossomHomes.CONFIG.fallbackToPlayerSpawnPoint) {
                TextUtils.sendErr(ctx, (String)"blossom.homes.not-found", (Object[])new Object[]{homeName});
                return 1;
            }
            class_5454 teleportTarget = player.method_60590(true, class_5454.field_52245);
            LOGGER.trace("found spawn position for {} @ {}", (Object)player.method_5845(), (Object)teleportTarget);
            TextUtils.sendWarn(ctx, (String)"blossom.homes.spawn", (Object[])new Object[0]);
            home = new Home(BlossomHomes.CONFIG.defaultHome, teleportTarget.comp_2820().method_27983().method_29177().toString(), teleportTarget.comp_2821().field_1352, teleportTarget.comp_2821().field_1351, teleportTarget.comp_2821().field_1350, teleportTarget.comp_2824(), teleportTarget.comp_2823());
        }
        Home finalHome = home;
        TeleportUtils.teleport((TeleportConfig)BlossomHomes.CONFIG.teleportation, (double)BlossomHomes.CONFIG.standStill, (long)BlossomHomes.CONFIG.cooldown, BlossomHomes.class, (class_3222)player, () -> finalHome.toDestination(((class_2168)ctx.getSource()).method_9211()));
        return 1;
    }

    private int runHomeDefault(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        return this.runHome(ctx, BlossomHomes.CONFIG.defaultHome);
    }

    private int runHomeNamed(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String homeName = StringArgumentType.getString(ctx, (String)"name");
        return this.runHome(ctx, homeName);
    }

    private int addHome(CommandContext<class_2168> ctx, Home home) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        LOGGER.info("adding home {} to {}", (Object)home, (Object)player);
        boolean invalidDimension = BlossomHomes.CONFIG.dimensionBlacklist.contains(home.world);
        if (BlossomHomes.CONFIG.useBlacklistAsWhitelist) {
            boolean bl = invalidDimension = !invalidDimension;
        }
        if (invalidDimension && !Permissions.check((class_2168)((class_2168)ctx.getSource()), (String)"blossom.homes.set.in-blacklist", (int)2)) {
            TextUtils.sendErr(ctx, (String)"blossom.homes.add.failed.dimension", (Object[])new Object[]{home.world});
            return 1;
        }
        HomeController.AddHomeResult result = homeController.addHome(player, home);
        switch (result) {
            case SUCCESS: {
                TextUtils.sendSuccess(ctx, (String)"blossom.homes.add", (Object[])new Object[]{home.name});
                break;
            }
            case NOT_ENOUGH_HOMES: {
                TextUtils.sendErr(ctx, (String)"blossom.homes.add.failed.max", (Object[])new Object[]{homeController.getMaxHomes(player)});
                break;
            }
            case NAME_TAKEN: {
                TextUtils.sendErr(ctx, (String)"blossom.homes.add.failed.name", (Object[])new Object[]{home.name});
            }
        }
        return 1;
    }

    private int addHomeDimension(CommandContext<class_2168> ctx, class_3218 dimension) throws CommandSyntaxException {
        String homeName = StringArgumentType.getString(ctx, (String)"name");
        class_243 position = class_2277.method_9734(ctx, (String)"position").method_9708((class_2168)ctx.getSource());
        class_241 rotation = class_2270.method_9716(ctx, (String)"rotation").method_9709((class_2168)ctx.getSource());
        return this.addHome(ctx, new Home(homeName, new TeleportUtils.TeleportDestination(dimension, position, rotation)));
    }

    private int addHomeNamed(CommandContext<class_2168> ctx, String name) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        return this.addHome(ctx, new Home(name, new TeleportUtils.TeleportDestination((class_1657)player)));
    }

    private int addHomeDefault(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        return this.addHomeNamed(ctx, BlossomHomes.CONFIG.defaultHome);
    }

    private int addHomeNamed(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String homeName = StringArgumentType.getString(ctx, (String)"name");
        return this.addHomeNamed(ctx, homeName);
    }

    private int addHomePosRot(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        return this.addHomeDimension(ctx, ((class_2168)ctx.getSource()).method_9225());
    }

    private int addHomeDimension(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3218 dimension = class_2181.method_9289(ctx, (String)"dimension");
        return this.addHomeDimension(ctx, dimension);
    }

    private int removeHome(CommandContext<class_2168> ctx, String name) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        Home home = homeController.findHome(player, name);
        LOGGER.debug("removing home {} from {}", (Object)home, (Object)player);
        boolean result = homeController.removeHome(player, name);
        if (result) {
            TextUtils.sendWarn(ctx, (String)"blossom.homes.remove", (Object[])new Object[]{name});
        } else {
            TextUtils.sendErr(ctx, (String)"blossom.homes.remove.failed", (Object[])new Object[]{name});
        }
        return 1;
    }

    private int removeHomeDefault(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        return this.removeHome(ctx, BlossomHomes.CONFIG.defaultHome);
    }

    private int removeHomeNamed(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String homeName = StringArgumentType.getString(ctx, (String)"name");
        return this.removeHome(ctx, homeName);
    }

    private int setMax(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        int newMax = IntegerArgumentType.getInteger(ctx, (String)"new-max");
        Collection players = class_2186.method_9312(ctx, (String)"players");
        players.forEach(p -> homeController.setMaxHomes((class_3222)p, newMax));
        TextUtils.sendOps(ctx, (String)"blossom.homes.setMax", (Object[])new Object[]{newMax, players.stream().map(player -> {
            if (player.method_14206() != null) {
                return player.method_14206();
            }
            return player.method_5476();
        }).filter(Objects::nonNull).map(class_2561::method_27661).collect(JoiningCollector.collector(class_5250::method_10852, (Object)TextUtils.translation((String)"blossom.homes.setMax.delimiter", (Object[])new Object[0])))});
        return 1;
    }

    private int loadLegacy(CommandContext<class_2168> ctx, boolean overwrite) {
        TextUtils.sendOps(ctx, (String)"blossom.homes.load-legacy.info", (Object[])new Object[0]);
        if (overwrite) {
            TextUtils.sendOps(ctx, (String)"blossom.homes.load-legacy.overwrite", (Object[])new Object[0]);
        }
        MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
        File[] playerDataFiles = server.method_27050(class_5218.field_24182).toFile().listFiles();
        int totalHomes = 0;
        int totalPlayers = 0;
        try {
            assert (playerDataFiles != null);
            for (File playerDataFile : playerDataFiles) {
                FileInputStream pdfIs = new FileInputStream(playerDataFile);
                class_2487 data = class_2507.method_10629((InputStream)pdfIs, (class_2505)class_2505.method_53898());
                if (!data.method_10545("cardinal_components") || !(data = (class_2487)data.method_10562("cardinal_components").get()).method_10545("fabrichomes:homes")) continue;
                List<Home> homes = ((class_2499)((class_2487)data.method_10562("fabrichomes:homes").get()).method_10554("homes").get()).stream().map(home -> {
                    String name = (String)((class_2487)home).method_10558("name").get();
                    String world = (String)((class_2487)home).method_10558("dim").get();
                    double x = ((Float)((class_2487)home).method_10583("x").get()).floatValue();
                    double y = ((Float)((class_2487)home).method_10583("y").get()).floatValue();
                    double z = ((Float)((class_2487)home).method_10583("z").get()).floatValue();
                    float yaw = ((Float)((class_2487)home).method_10583("yaw").get()).floatValue();
                    float pitch = ((Float)((class_2487)home).method_10583("pitch").get()).floatValue();
                    return new Home(name, world, x, y, z, yaw, pitch);
                }).toList();
                UUID uuid = UUID.fromString(FilenameUtils.removeExtension((String)playerDataFile.getName()));
                ++totalPlayers;
                totalHomes += homes.size();
                homeController.appendHomes(uuid, homes, overwrite);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        TextUtils.sendOps(ctx, (String)"blossom.homes.load-legacy.done", (Object[])new Object[]{totalHomes, totalPlayers});
        return 1;
    }

    private int loadLegacyArgument(CommandContext<class_2168> ctx) {
        boolean overwrite = BoolArgumentType.getBool(ctx, (String)"overwrite");
        return this.loadLegacy(ctx, overwrite);
    }

    private int loadLegacyDefault(CommandContext<class_2168> ctx) {
        return this.loadLegacy(ctx, false);
    }
}

