/*
 * Decompiled with CFR 0.152.
 */
package dev.codedsakura.blossom.homes;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.codedsakura.blossom.homes.BlossomHomes;
import dev.codedsakura.blossom.homes.Home;
import dev.codedsakura.blossom.homes.PlayerWithHomes;
import dev.codedsakura.blossom.lib.data.ListDataController;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

public class HomeController
extends ListDataController<PlayerWithHomes>
implements SuggestionProvider<class_2168> {
    public Class<PlayerWithHomes[]> getArrayClassType() {
        return PlayerWithHomes[].class;
    }

    public List<PlayerWithHomes> defaultData() {
        return new ArrayList<PlayerWithHomes>();
    }

    public String getFilename() {
        return "BlossomHomes";
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        UUID playerUuid = player.method_5667();
        String start = builder.getRemaining().toLowerCase();
        ((List)this.data).stream().filter(v -> v.uuid.equals(playerUuid)).flatMap(v -> v.homes.stream().map(home -> home.name)).sorted(String::compareToIgnoreCase).filter(pair -> pair.toLowerCase().startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    List<Home> findPlayerHomes(class_3222 player) {
        UUID uuid = player.method_5667();
        for (PlayerWithHomes playerWithHomes : (List)this.data) {
            if (!playerWithHomes.uuid.equals(uuid)) continue;
            return playerWithHomes.homes;
        }
        return List.of();
    }

    Home findHome(class_3222 player, String name) {
        for (Home home : this.findPlayerHomes(player)) {
            if (!home.name.equals(name)) continue;
            return home;
        }
        return null;
    }

    int getMaxHomes(class_3222 player) {
        UUID uuid = player.method_5667();
        for (PlayerWithHomes playerWithHomes : (List)this.data) {
            if (!playerWithHomes.uuid.equals(uuid)) continue;
            return playerWithHomes.maxHomes;
        }
        return BlossomHomes.CONFIG.startHomes;
    }

    void setMaxHomes(class_3222 player, int newMaxHomes) {
        UUID uuid = player.method_5667();
        for (PlayerWithHomes playerWithHomes : (List)this.data) {
            if (!playerWithHomes.uuid.equals(uuid)) continue;
            playerWithHomes.maxHomes = newMaxHomes;
            this.write();
            return;
        }
        ((List)this.data).add(new PlayerWithHomes(uuid, newMaxHomes));
        this.write();
    }

    AddHomeResult addHome(class_3222 player, Home home) {
        UUID uuid = player.method_5667();
        List<Home> homes = this.findPlayerHomes(player);
        if (homes.size() + 1 > this.getMaxHomes(player)) {
            return AddHomeResult.NOT_ENOUGH_HOMES;
        }
        if (homes.stream().map(v -> v.name).anyMatch(v -> v.equals(home.name))) {
            return AddHomeResult.NAME_TAKEN;
        }
        if (((List)this.data).stream().noneMatch(v -> v.uuid.equals(uuid))) {
            ((List)this.data).add(new PlayerWithHomes(uuid));
        }
        for (PlayerWithHomes playerWithHomes : (List)this.data) {
            if (!playerWithHomes.uuid.equals(uuid)) continue;
            playerWithHomes.homes.add(home);
            this.write();
            return AddHomeResult.SUCCESS;
        }
        this.write();
        return AddHomeResult.SUCCESS;
    }

    boolean removeHome(class_3222 player, String name) {
        UUID uuid = player.method_5667();
        boolean result = ((List)this.data).stream().filter(v -> v.uuid.equals(uuid)).findAny().map(v -> v.homes.removeIf(home -> home.name.equals(name))).orElse(false);
        if (result) {
            this.write();
        }
        return result;
    }

    void appendHomes(UUID player, List<Home> homes, boolean overwrite) {
        for (PlayerWithHomes playerWithHomes : (List)this.data) {
            if (!playerWithHomes.uuid.equals(player)) continue;
            if (overwrite) {
                playerWithHomes.homes.clear();
            }
            playerWithHomes.homes.addAll(homes);
            this.write();
            return;
        }
        PlayerWithHomes playerWithHomes = new PlayerWithHomes(player);
        playerWithHomes.homes.addAll(homes);
        ((List)this.data).add(playerWithHomes);
        this.write();
    }

    static enum AddHomeResult {
        SUCCESS,
        NOT_ENOUGH_HOMES,
        NAME_TAKEN;

    }
}

