/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.betterwhitelist.server;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.gitlab.jfronny.betterwhitelist.BetterWhitelist;
import io.gitlab.jfronny.betterwhitelist.DSerializer;
import io.gitlab.jfronny.betterwhitelist.packet.ChallengeResponsePacket;
import io.gitlab.jfronny.betterwhitelist.packet.HandshakePacket;
import io.gitlab.jfronny.betterwhitelist.server.Challenge;
import io.gitlab.jfronny.betterwhitelist.server.ServerScope;
import io.gitlab.jfronny.betterwhitelist.server.mixin.ServerLoginNetworkHandlerAccessor;
import io.gitlab.jfronny.commons.StringFormatter;
import io.gitlab.jfronny.muscript.ast.context.Script;
import io.gitlab.jfronny.muscript.core.LocationalException;
import io.gitlab.jfronny.muscript.core.MuScriptVersion;
import io.gitlab.jfronny.muscript.parser.Parser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.FutureTask;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.LoginPacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3248;

public class BetterWhitelistServer
implements DedicatedServerModInitializer {
    private String scriptSource;
    private Script script;
    private final Map<GameProfile, Challenge> challenges = new HashMap<GameProfile, Challenge>();

    public void onInitializeServer() {
        BetterWhitelist.initialize();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"better-whitelist").requires(source -> source.method_9259(4))).executes(this::printVersion)).then(class_2170.method_9247((String)"reload").executes(this::reloadScript))));
        ServerLoginConnectionEvents.QUERY_START.register((handler, server, sender, synchronizer) -> {
            GameProfile gp = this.profile(handler);
            Challenge challenge = new Challenge(gp, sender);
            this.challenges.put(gp, challenge);
            class_2540 buf = PacketByteBufs.create();
            HandshakePacket.CODEC.encode((Object)buf, (Object)new HandshakePacket(1));
            challenge.sender.sendPacket(BetterWhitelist.HANDSHAKE_CHANNEL, buf);
            synchronizer.waitFor(challenge.challengeCompleted);
        });
        ServerLoginNetworking.registerGlobalReceiver((class_2960)BetterWhitelist.HANDSHAKE_CHANNEL, (server, handler, understood, buf, synchronizer, responseSender) -> {
            if (!understood) {
                handler.method_14380((class_2561)class_2561.method_43470((String)"This server requires better-whitelist to be installed"));
                return;
            }
            LoginPacketSender rns = (LoginPacketSender)responseSender;
            HandshakePacket packet = (HandshakePacket)HandshakePacket.CODEC.decode((Object)buf);
            try {
                if (packet.version() != 1) {
                    handler.method_14380((class_2561)class_2561.method_43470((String)"This server requires a version of better-whitelist supporting the protocol version 1"));
                    return;
                }
                Challenge challenge = this.challenges.get(this.profile(handler));
                challenge.sender = rns;
                class_156.method_18349().execute(new FutureTask<Object>(() -> {
                    try {
                        ServerScope.run(this.script, challenge);
                        challenge.challengeCompleted.complete(null);
                        BetterWhitelist.LOG.info("Completed challenge for " + challenge.profile.name(), new Object[0]);
                    }
                    catch (ServerScope.AssertFail fail) {
                        BetterWhitelist.LOG.warn("Failed challenge for " + challenge.profile.name() + ": " + fail.getMessage(), new Object[0]);
                        if (handler.method_48106()) {
                            handler.method_14380((class_2561)class_2561.method_43470((String)fail.getMessage()));
                        }
                        challenge.challengeCompleted.cancel();
                    }
                    catch (Throwable t) {
                        BetterWhitelist.LOG.error("Something went wrong while trying to execute a challenge\n" + StringFormatter.toString((Throwable)t, e -> {
                            String string;
                            if (e instanceof LocationalException) {
                                LocationalException le = (LocationalException)e;
                                string = le.asPrintable().toString();
                            } else {
                                string = e.toString();
                            }
                            return string;
                        }), new Object[0]);
                        if (handler.method_48106()) {
                            handler.method_14380((class_2561)class_2561.method_43470((String)"Something went wrong"));
                        }
                        challenge.challengeCompleted.cancel();
                    }
                    this.challenges.remove(challenge.profile);
                    return null;
                }));
            }
            catch (Throwable t) {
                handler.method_14380((class_2561)class_2561.method_43470((String)"Handshake failed"));
            }
        });
        ServerLoginNetworking.registerGlobalReceiver((class_2960)BetterWhitelist.CHALLENGE_CHANNEL, (server, handler, understood, buf, synchronizer, responseSender) -> {
            if (!understood) {
                handler.method_14380((class_2561)class_2561.method_43470((String)"This server requires better-whitelist to be installed"));
                return;
            }
            LoginPacketSender rns = (LoginPacketSender)responseSender;
            ChallengeResponsePacket packet = (ChallengeResponsePacket)ChallengeResponsePacket.CODEC.decode((Object)buf);
            try {
                Challenge ch = this.challenges.get(this.profile(handler));
                ch.sender = rns;
                BetterWhitelist.LOG.info("Got response from " + ch.profile.name() + ": " + packet.message(), new Object[0]);
                ch.response.complete(DSerializer.deserialize(packet.message()));
            }
            catch (Throwable t) {
                BetterWhitelist.LOG.error("Failed login", t);
                handler.method_14380((class_2561)class_2561.method_43470((String)"Invalid dynamic"));
            }
        });
        try {
            this.reloadScript();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load whitelist script", e);
        }
    }

    private GameProfile profile(class_3248 handler) {
        GameProfile gp = ((ServerLoginNetworkHandlerAccessor)handler).getProfile();
        if (gp == null) {
            throw new NullPointerException("Missing GameProfile");
        }
        return gp;
    }

    private int printVersion(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Loaded " + BetterWhitelist.MOD_METADATA.getName() + " " + String.valueOf(BetterWhitelist.MOD_METADATA.getVersion()))));
        return 1;
    }

    private int reloadScript(CommandContext<class_2168> context) {
        try {
            this.reloadScript();
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Successfully reloaded script"));
        }
        catch (Throwable t) {
            BetterWhitelist.LOG.error("Could not reload script", t);
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Could not reload script, check server log for details"));
        }
        return 1;
    }

    private void reloadScript() throws IOException {
        Path scriptPath = FabricLoader.getInstance().getConfigDir().resolve("better-whitelist.mu");
        if (!Files.exists(scriptPath, new LinkOption[0])) {
            Files.writeString(scriptPath, (CharSequence)"// Use this method to execute a closure on the client and get back the result\nclientVersion = challenge({ ->\n  // Note that closures sent to the client do not have access to things you declare elsewhere\n  mod('better-whitelist').version\n})\n\nprintln(\"You can, of course, use println-debugging\")\n\n// You have access to the same methods on the server as you do on the client\n// You may use the assert method to short-circuit if you encounter a case where the client should not be allowed access\n// Assert can also have a second argument for the message to send if the assertion fails\nassert(mod('better-whitelist').version == clientVersion, 'You have the wrong mod version')\n\n// you can also send server-evaluated parameters with your challenge\nassert(challenge({ arg ->\n  arg::allMatch({ v -> mods::values()::anyMatch({ m -> v.id == m.id & v.version == m.version }) })\n}, mods::values()::filter({ v -> v.environment != 'server' })::map({ v -> { id = v.id, version = v.version } })))\n", new OpenOption[0]);
        }
        String s = Files.readString(scriptPath);
        this.script = Parser.parseScript((MuScriptVersion)MuScriptVersion.DEFAULT, (String)s);
        this.scriptSource = s;
    }
}

