/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.betterwhitelist.server;

import io.gitlab.jfronny.betterwhitelist.BetterWhitelist;
import io.gitlab.jfronny.betterwhitelist.DSerializer;
import io.gitlab.jfronny.betterwhitelist.packet.ChallengePacket;
import io.gitlab.jfronny.betterwhitelist.server.Challenge;
import io.gitlab.jfronny.muscript.ast.context.Script;
import io.gitlab.jfronny.muscript.core.LocationalException;
import io.gitlab.jfronny.muscript.data.additional.DFinal;
import io.gitlab.jfronny.muscript.data.additional.context.Scope;
import io.gitlab.jfronny.muscript.data.dynamic.DNull;
import io.gitlab.jfronny.muscript.data.dynamic.Dynamic;
import io.gitlab.jfronny.muscript.runtime.Runtime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;

public class ServerScope {
    public static Dynamic run(Script script, Challenge challenge) {
        try {
            return Runtime.run((Script)script, (Scope)ServerScope.fork(challenge));
        }
        catch (LocationalException le) {
            for (Throwable t = le; t != null; t = t.getCause()) {
                if (!(t instanceof AssertFail)) continue;
                AssertFail af = (AssertFail)t;
                throw af;
            }
            throw le;
        }
    }

    private static Scope fork(Challenge challenge) {
        return BetterWhitelist.SCOPE.fork().set("assert", args -> {
            if (args.size() != 1 && args.size() != 2) {
                throw new IllegalArgumentException("Invalid number of arguments for assert: expected 1 or 2 but got " + args.size());
            }
            if (!args.get(0).asBool().getValue().booleanValue()) {
                throw new AssertFail(args.size() > 1 ? args.get(1).asString().getValue() : "Failed Whitelist Check");
            }
            return new DNull();
        }).set("challenge", args -> {
            if (args.isEmpty()) {
                throw new IllegalArgumentException("Invalid number of arguments for challenge: expected 1 or more but got 0");
            }
            String challengeString = DSerializer.serialize((Dynamic)args.get(0).asCallable());
            BetterWhitelist.LOG.info("Sending challenge to " + challenge.profile.name() + ": " + challengeString, new Object[0]);
            List<String> params = args.getValue().subList(1, args.size()).stream().map(DSerializer::serialize).toList();
            challenge.response.reset();
            class_2540 buf = PacketByteBufs.create();
            ChallengePacket.CODEC.encode((Object)buf, (Object)new ChallengePacket(challengeString, params));
            challenge.sender.sendPacket(BetterWhitelist.CHALLENGE_CHANNEL, buf);
            try {
                return challenge.response.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                throw new AssertFail("Took too long to respond");
            }
        }).set("user", Map.of("id", challenge.profile.id() == null ? new DNull() : DFinal.of((String)challenge.profile.id().toString()), "name", DFinal.of((String)challenge.profile.name())));
    }

    public static class AssertFail
    extends RuntimeException {
        public AssertFail(String message) {
            super(message);
        }
    }
}

