/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.betterwhitelist.server;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class ManualFuture<T>
implements Future<T> {
    private Result state = Result.RUNNING;
    private T result;

    @Override
    public boolean cancel(boolean b) {
        if (this.state != Result.RUNNING) {
            return false;
        }
        this.cancel();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.state == Result.CANCELLED;
    }

    @Override
    public boolean isDone() {
        return this.state == Result.DONE;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        while (this.state == Result.RUNNING) {
            Thread.sleep(10L);
        }
        if (this.state == Result.CANCELLED) {
            throw new CancellationException();
        }
        return this.result;
    }

    @Override
    public T get(long l, @NotNull TimeUnit timeUnit) throws TimeoutException {
        long millis = timeUnit.toMillis(l) / 10L;
        while (this.state == Result.RUNNING && millis-- > 0L) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (millis <= 0L) {
            throw new TimeoutException();
        }
        if (this.state == Result.CANCELLED) {
            throw new CancellationException();
        }
        return this.result;
    }

    public void cancel() {
        this.state = Result.CANCELLED;
    }

    public void complete(T result) {
        if (this.state != Result.RUNNING) {
            throw new IllegalStateException("Attempted to complete non-running future");
        }
        this.state = Result.DONE;
        this.result = result;
    }

    public void reset() {
        this.state = Result.RUNNING;
    }

    private static enum Result {
        RUNNING,
        CANCELLED,
        DONE;

    }
}

