/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter;

import com.github.sarhatabaot.chunkspawnerlimiter.CSLLogger;
import com.github.sarhatabaot.chunkspawnerlimiter.PluginConfig;
import com.github.sarhatabaot.chunkspawnerlimiter.command.AdminCommand;
import com.github.sarhatabaot.chunkspawnerlimiter.counter.CounterDataManager;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.CommandFramework;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.bukkit.Metrics;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.charts.SimplePie;
import com.github.sarhatabaot.chunkspawnerlimiter.listener.ChunkListener;
import com.github.sarhatabaot.chunkspawnerlimiter.listener.EventListener;
import com.github.sarhatabaot.chunkspawnerlimiter.removal.Checks;
import com.github.sarhatabaot.chunkspawnerlimiter.removal.ExternalChecks;
import com.github.sarhatabaot.chunkspawnerlimiter.removal.RemovalTaskManager;
import com.github.sarhatabaot.chunkspawnerlimiter.removal.modes.RemovalMode;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class ChunkSpawnerLimiter
extends JavaPlugin {
    private RemovalTaskManager removalTaskManager;
    private CounterDataManager counterDataManager;
    private PluginConfig pluginConfig;

    public void onEnable() {
        this.pluginConfig = new PluginConfig(this);
        CSLLogger.setup(this.pluginConfig);
        Checks.setup(this.pluginConfig);
        ExternalChecks.setup(this.pluginConfig);
        CommandFramework commandFramework = new CommandFramework((Plugin)this);
        commandFramework.registerCommands(new AdminCommand(this));
        this.counterDataManager = new CounterDataManager();
        this.removalTaskManager = new RemovalTaskManager(this, this.counterDataManager, this.pluginConfig);
        RemovalMode.setup(this.removalTaskManager);
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)new ChunkListener(this.pluginConfig, this.counterDataManager, this.removalTaskManager), (Plugin)this);
        pluginManager.registerEvents((Listener)new EventListener(this.pluginConfig, this.counterDataManager), (Plugin)this);
        if (this.pluginConfig.isMetrics()) {
            Metrics metrics = new Metrics((Plugin)this, 4195);
            metrics.addCustomChart(new SimplePie("removal_mode", () -> this.pluginConfig.getRemovalMode().getKey()));
        }
    }

    public void onDisable() {
        this.counterDataManager = null;
        this.removalTaskManager = null;
        this.pluginConfig = null;
    }

    public void onReload() {
        this.pluginConfig.reload();
    }
}

