/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter;

import com.github.sarhatabaot.chunkspawnerlimiter.removal.modes.RemovalMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Monster;
import org.bukkit.entity.NPC;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.WaterMob;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class PluginConfig {
    private final JavaPlugin plugin;
    private FileConfiguration config;
    private Map<String, Integer> entityLimits;
    private Map<String, Integer> blockLimits;
    private Map<String, Boolean> spawnReasons;
    private Map<String, List<String>> entityGroups;
    private static final String DEFAULT_STRING = "default";

    public PluginConfig(JavaPlugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "Plugin cannot be null");
        this.plugin.saveDefaultConfig();
        this.reload();
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.entityLimits = null;
        this.blockLimits = null;
        this.spawnReasons = null;
        this.entityGroups = null;
    }

    public boolean isEnabled() {
        return this.config.getBoolean("enabled", false);
    }

    public boolean isDebugMessages() {
        return this.config.getBoolean("debug-messages", false);
    }

    public boolean isMetrics() {
        return this.config.getBoolean("metrics", true);
    }

    public boolean isCreatureSpawnWatch() {
        return this.config.getBoolean("events.spawn.creature", true);
    }

    public boolean isVehicleSpawnWatch() {
        return this.config.getBoolean("events.spawn.vehicle", true);
    }

    public boolean isEntitySpawnWatch() {
        return this.config.getBoolean("events.spawn.entity", true);
    }

    public boolean isActiveInspections() {
        return this.config.getBoolean("events.inspections.enabled", true);
    }

    public int getInspectionFrequency() {
        return this.config.getInt("events.inspections.frequency", 300);
    }

    public int getSurroundingChunksRadius() {
        return this.config.getInt("events.chunk.surrounding-chunks-radius", 1);
    }

    public Map<String, Integer> getEntityLimits() {
        if (this.entityLimits == null) {
            this.entityLimits = new HashMap<String, Integer>();
            ConfigurationSection limitsSection = this.config.getConfigurationSection("entities.limits");
            if (limitsSection == null) {
                return Collections.emptyMap();
            }
            this.entityLimits = limitsSection.getKeys(false).stream().collect(Collectors.toMap(key -> key, arg_0 -> ((ConfigurationSection)limitsSection).getInt(arg_0)));
        }
        return this.entityLimits;
    }

    public boolean hasEntityLimit(Entity entity) {
        String entityGroup = this.getEntityGroup(entity);
        return this.hasEntityLimit(entity.getType().name()) || this.getEntityLimits().containsKey(entityGroup);
    }

    public Integer getEntityLimit(Entity entity) {
        String entityType = entity.getType().name();
        if (this.getEntityLimits().containsKey(entityType)) {
            return this.getEntityLimits().get(entityType);
        }
        String entityGroup = this.getEntityGroup(entity);
        return this.getEntityLimits().get(entityGroup);
    }

    public Integer getEntityLimit(EntityType entityType) {
        String entityTypeName = entityType.name();
        if (this.getEntityLimits().containsKey(entityTypeName)) {
            return this.getEntityLimits().get(entityTypeName);
        }
        String entityGroup = this.getEntityGroup(entityType);
        if (entityGroup != null && this.getEntityLimits().containsKey(entityGroup)) {
            return this.getEntityLimits().get(entityGroup);
        }
        return null;
    }

    public String getEntityGroup(EntityType entityType) {
        Map<String, List<String>> entityGroups = this.getEntityGroups();
        for (Map.Entry<String, List<String>> entry : entityGroups.entrySet()) {
            if (!entry.getValue().contains(entityType.name())) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean hasEntityLimit(EntityType entityType) {
        return this.getEntityLimit(entityType) != null;
    }

    public Map<String, List<String>> getEntityGroups() {
        if (this.entityGroups == null) {
            this.entityGroups = new HashMap<String, List<String>>();
            ConfigurationSection groupsSection = this.config.getConfigurationSection("entities.entity-groups");
            if (groupsSection == null) {
                return Collections.emptyMap();
            }
            for (String groupName : groupsSection.getKeys(false)) {
                List entities = groupsSection.getStringList(groupName);
                this.entityGroups.put(groupName.toUpperCase(), entities.stream().map(String::toUpperCase).collect(Collectors.toList()));
            }
        }
        return this.entityGroups;
    }

    public boolean hasEntityLimit(String entityType) {
        return this.getEntityLimits().containsKey(entityType);
    }

    public boolean hasBlockLimit(String material) {
        return this.getBlockLimits().containsKey(material);
    }

    public RemovalMode getRemovalMode() {
        String mode = this.config.getString("entities.removal.mode", "enforce");
        return RemovalMode.fromString(mode);
    }

    public boolean shouldDropArmorStandItems() {
        return this.config.getBoolean("entities.removal.armor-stand.drop", false);
    }

    public boolean shouldLogArmorStandWarnings() {
        return this.config.getBoolean("entities.removal.armor-stand.log-warnings", true);
    }

    public boolean shouldPreserveNamedEntities() {
        return this.config.getBoolean("entities.preservation.named-entities", true);
    }

    public boolean shouldPreserveRaidEntities() {
        return this.config.getBoolean("entities.preservation.raid-entities", true);
    }

    public List<String> getIgnoreMetadata() {
        return Objects.requireNonNullElse(this.config.getStringList("entities.ignore.metadata"), List.of("shopkeeper"));
    }

    public List<String> getIgnoreNbt() {
        return Objects.requireNonNullElse(this.config.getStringList("entities.ignore.nbt"), Collections.emptyList());
    }

    public Map<String, Boolean> getSpawnReasons() {
        if (this.spawnReasons == null) {
            ConfigurationSection reasonsSection = this.config.getConfigurationSection("spawn-reasons");
            if (reasonsSection == null) {
                return this.getDefaultSpawnReasons();
            }
            this.spawnReasons = reasonsSection.getKeys(false).stream().collect(Collectors.toMap(key -> key, arg_0 -> ((ConfigurationSection)reasonsSection).getBoolean(arg_0)));
        }
        return this.spawnReasons;
    }

    @NotNull
    private @Unmodifiable Map<String, Boolean> getDefaultSpawnReasons() {
        return Map.ofEntries(Map.entry("BREEDING", true), Map.entry("BUILD_IRONGOLEM", true), Map.entry("BUILD_SNOWMAN", true), Map.entry("BUILD_WITHER", true), Map.entry("CHUNK_GEN", true), Map.entry("DEFAULT", true), Map.entry("DISPENSE_EGG", true), Map.entry("DROWNED", true), Map.entry("EGG", true), Map.entry("JOCKEY", true), Map.entry("LIGHTNING", true), Map.entry("MOUNT", true), Map.entry("NATURAL", true), Map.entry("NETHER_PORTAL", true), Map.entry("OCELOT_BABY", true), Map.entry("REINFORCEMENTS", true), Map.entry("SILVERFISH_BLOCK", true), Map.entry("SPAWNER", true), Map.entry("SPAWNER_EGG", true), Map.entry("TRAP", true), Map.entry("VILLAGE_DEFENSE", true), Map.entry("VILLAGE_INVASION", true));
    }

    public Map<String, Integer> getBlockLimits() {
        if (this.blockLimits == null) {
            ConfigurationSection blocksSection = this.config.getConfigurationSection("blocks");
            if (blocksSection == null) {
                return Collections.emptyMap();
            }
            this.blockLimits = blocksSection.getKeys(false).stream().collect(Collectors.toMap(key -> key, arg_0 -> ((ConfigurationSection)blocksSection).getInt(arg_0)));
        }
        return this.blockLimits;
    }

    public String getWorldsMode() {
        return this.config.getString("worlds.mode", "excluded");
    }

    public List<String> getWorldsList() {
        return Objects.requireNonNullElse(this.config.getStringList("worlds.list"), List.of());
    }

    public boolean shouldNotifyPlayersInChunk() {
        return this.config.getBoolean("notifications.players-in-chunk", false);
    }

    public boolean shouldUseTitleNotifications() {
        return this.config.getBoolean("notifications.method.title", true);
    }

    public boolean shouldUseMessageNotifications() {
        return this.config.getBoolean("notifications.method.message", false);
    }

    public String getEntitiesRemovedMessage() {
        return this.config.getString("notifications.messages.entities-removed", "&7Removed %s %s in your chunk.");
    }

    public String getReloadCompleteMessage() {
        return this.config.getString("notifications.messages.reload-complete", "&cReloaded csl config.");
    }

    public String getMaxBlocksMessage() {
        return this.config.getString("notifications.messages.max-blocks", "&6Cannot place more &4{material}&6. Max amount per chunk &2{amount}.");
    }

    @NotNull
    public String getEntityGroup(@NotNull Entity entity) {
        String fromConfig = this.getGroupFromConfig(entity.getType(), this.config);
        if (fromConfig != null) {
            return fromConfig;
        }
        return this.getGroupFromInstance(entity);
    }

    @Nullable
    private String getGroupFromConfig(EntityType type, @NotNull FileConfiguration config) {
        ConfigurationSection section = config.getConfigurationSection("entity-groups");
        if (section == null) {
            return null;
        }
        for (String group : section.getKeys(false)) {
            List members = config.getStringList("entity-groups." + group);
            if (!members.contains(type.name())) continue;
            return group;
        }
        return null;
    }

    @NotNull
    private String getGroupFromInstance(Entity entity) {
        if (entity instanceof Animals) {
            return "ANIMALS";
        }
        if (entity instanceof Monster) {
            return "MONSTER";
        }
        if (entity instanceof NPC) {
            return "NPC";
        }
        if (entity instanceof WaterMob) {
            return "WATER_MOB";
        }
        if (entity instanceof Ambient) {
            return "AMBIENT";
        }
        if (entity instanceof Golem) {
            return "GOLEM";
        }
        if (entity instanceof Vehicle) {
            return "VEHICLE";
        }
        return entity.getType().name();
    }

    public boolean isWorldDisabled(String worldName) {
        if (this.getWorldsMode().equalsIgnoreCase("exclude")) {
            return this.getWorldsList().contains(worldName);
        }
        return !this.getWorldsList().contains(worldName);
    }

    public boolean isKillPlayers() {
        return this.config.getBoolean("entities.removal.kill-players", false);
    }
}

