/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.chunk;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ChunkCoord(UUID worldUuid, int chunkX, int chunkZ) {
    @Contract(value="_, _, _ -> new")
    @NotNull
    public static ChunkCoord from(@NotNull World world, int chunkX, int chunkZ) {
        return new ChunkCoord(world.getUID(), chunkX, chunkZ);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ChunkCoord from(@NotNull Chunk chunk) {
        return new ChunkCoord(chunk.getWorld().getUID(), chunk.getX(), chunk.getZ());
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ChunkCoord from(@NotNull Location location) {
        return ChunkCoord.from(location.getChunk());
    }

    @Contract(value="_ -> new")
    @NotNull
    public static ChunkCoord from(@NotNull Entity entity) {
        return ChunkCoord.from(entity.getLocation());
    }

    public World getWorld() {
        return Bukkit.getWorld((UUID)this.worldUuid);
    }

    @Nullable
    public Chunk getChunk() {
        World world = this.getWorld();
        return world != null ? world.getChunkAt(this.chunkX, this.chunkZ) : null;
    }

    public boolean isLoaded() {
        World world = this.getWorld();
        return world != null && world.isChunkLoaded(this.chunkX, this.chunkZ);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String toString() {
        return String.format("ChunkCoord{world=%s, x=%d, z=%d}", this.worldUuid, this.chunkX, this.chunkZ);
    }
}

