/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.command;

import com.github.sarhatabaot.chunkspawnerlimiter.ChunkSpawnerLimiter;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.CommandArguments;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Command;
import com.github.sarhatabaot.chunkspawnerlimiter.libs.annotations.Completer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class AdminCommand {
    private final ChunkSpawnerLimiter plugin;

    public AdminCommand(ChunkSpawnerLimiter plugin) {
        this.plugin = plugin;
    }

    @Command(name="csl", aliases={"csl.help", "csl.version"}, permission="csl")
    public void onHelp(@NotNull CommandArguments arguments) {
        int page = arguments.getArgumentAsInt(0);
        this.showHelpPage((CommandSender)arguments.getSender(), page);
    }

    private void showHelpPage(CommandSender sender, int page) {
        List<String> helpPages = List.of("&6&lChunkSpawnerLimiter v%s Help &7(Page 1/2)\n&e/csl chunk info &7- Show chunk spawner info\n&7View current chunk's spawner counts\n&e/csl help [page] &7- Show help menu\n".formatted(this.plugin.getDescription().getVersion()), " &6&lChunkSpawnerLimiter Help &7(Page 2/2)\n &6Admin Commands:\n &e/csl version &7- Show plugin version\n &e/csl reload &7- Reload configuration\n &e/csl search entities &7- List entity types\n &e/csl search blocks &7- List block materials\n &e/csl rebuild &7- Rebuild all counters\n &c  \u26a0\ufe0f Can cause lag - use with caution\n");
        int maxPage = helpPages.size();
        if (page < 1 || page > maxPage) {
            page = 1;
        }
        String pageContent = helpPages.get(page - 1);
        for (String line : pageContent.split("\n")) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
        }
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Use /csl help " + (page % maxPage + 1) + " for next page");
    }

    @Command(name="csl.reload", permission="csl.reload")
    public void onReload(@NotNull CommandArguments arguments) {
        this.plugin.onReload();
        arguments.getSender().sendMessage("Reloaded config.");
    }

    @Command(name="csl.search.entities")
    public void onSearchEntities(@NotNull CommandArguments arguments) {
        arguments.getSender().sendMessage(Arrays.stream(EntityType.values()).map(Enum::name).collect(Collectors.joining(", ")));
    }

    @Command(name="csl.search.entities")
    public List<String> onSearchEntitiesCompletion() {
        return Arrays.stream(EntityType.values()).map(Enum::name).toList();
    }

    @Command(name="csl.search.blocks")
    public void onSearchBlocks(@NotNull CommandArguments arguments) {
        arguments.getSender().sendMessage(Arrays.stream(Material.values()).filter(material -> material != Material.AIR).map(Enum::name).collect(Collectors.joining(", ")));
    }

    @Completer(name="csl.search.blocks")
    public List<String> onSearchBlocksCompletion() {
        return Arrays.stream(Material.values()).map(Enum::name).toList();
    }

    public void onChunkInfo(CommandArguments commandArguments) {
    }
}

