/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarhatabaot.chunkspawnerlimiter.counter;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class CounterData {
    private final Map<Material, AtomicInteger> blockCounts = new ConcurrentHashMap<Material, AtomicInteger>();
    private final Map<EntityType, AtomicInteger> entityCounts = new ConcurrentHashMap<EntityType, AtomicInteger>();
    private final Map<String, AtomicInteger> entityGroupCounts = new ConcurrentHashMap<String, AtomicInteger>();

    public Set<EntityType> getTrackedEntityTypes() {
        return this.entityCounts.keySet();
    }

    public int getEntityGroupCount(String group) {
        AtomicInteger count = this.entityGroupCounts.get(group);
        return count != null ? count.get() : 0;
    }

    public int getBlockCount(Material type) {
        AtomicInteger count = this.blockCounts.get(type);
        return count != null ? count.get() : 0;
    }

    public int getEntityCount(EntityType type) {
        AtomicInteger count = this.entityCounts.get(type);
        return count != null ? count.get() : 0;
    }

    public void incrementBlock(Material type) {
        this.blockCounts.computeIfAbsent(type, k -> new AtomicInteger(0)).incrementAndGet();
    }

    public void decrementBlock(Material type) {
        AtomicInteger count = this.blockCounts.get(type);
        if (count != null) {
            count.decrementAndGet();
        }
    }

    public void incrementEntity(EntityType type) {
        this.entityCounts.computeIfAbsent(type, k -> new AtomicInteger(0)).incrementAndGet();
    }

    public void decrementEntity(EntityType type) {
        AtomicInteger count = this.entityCounts.get(type);
        if (count != null) {
            count.decrementAndGet();
        }
    }

    public void incrementEntityGroup(String group) {
        this.entityGroupCounts.computeIfAbsent(group, k -> new AtomicInteger(0)).incrementAndGet();
    }

    public void decrementEntityGroup(String group) {
        AtomicInteger count = this.entityGroupCounts.get(group);
        if (count != null) {
            count.decrementAndGet();
        }
    }

    public void setEntityGroupCount(String group, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count cannot be negative");
        }
        this.entityGroupCounts.put(group, new AtomicInteger(count));
    }

    public void setBlockCount(Material type, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count cannot be negative");
        }
        this.blockCounts.put(type, new AtomicInteger(count));
    }

    public void setEntityCount(EntityType type, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count cannot be negative");
        }
        this.entityCounts.put(type, new AtomicInteger(count));
    }
}

